/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.arduino.core.ArduinoLaunchConsoleService;
import org.eclipse.cdt.arduino.core.ArduinoProjectGenerator;
import org.eclipse.cdt.arduino.core.IArduinoRemoteConnection;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;

public class ArduinoLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String TYPE_ID = "org.eclipse.cdt.arduino.core.launchConfigurationType";
    public static final String CONNECTION_NAME = String.valueOf(Activator.getId()) + ".connectionName";

    private static IRemoteConnection getTarget(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connectionType = remoteManager.getConnectionType("org.eclipse.cdt.arduino.core.connectionType");
        String connectionName = configuration.getAttribute(CONNECTION_NAME, "");
        return connectionType.getConnection(connectionName);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection target = ArduinoLaunchConfigurationDelegate.getTarget(configuration);
        IProject project = configuration.getMappedResources()[0].getProject();
        ICProjectDescription projDesc = CCorePlugin.getDefault().getProjectDescription(project);
        ICConfigurationDescription configDesc = this.getBuildConfiguration(projDesc, target);
        boolean newConfig = false;
        if (configDesc == null) {
            IArduinoRemoteConnection arduinoRemote = (IArduinoRemoteConnection)target.getService(IArduinoRemoteConnection.class);
            configDesc = ArduinoProjectGenerator.createBuildConfiguration(projDesc, arduinoRemote.getBoard());
            newConfig = true;
        }
        if (newConfig || !projDesc.getActiveConfiguration().equals(configDesc)) {
            projDesc.setActiveConfiguration(configDesc);
            CCorePlugin.getDefault().setProjectDescription(project, projDesc);
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject project = configuration.getMappedResources()[0].getProject();
        return new IProject[]{project};
    }

    public void launch(final ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        new Job(Messages.ArduinoLaunchConfigurationDelegate_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ArduinoLaunchConsoleService consoleService = ArduinoLaunchConfigurationDelegate.this.getConsoleService();
                    IRemoteConnection target = ArduinoLaunchConfigurationDelegate.getTarget(configuration);
                    if (target == null) {
                        Status status = new Status(4, Activator.getId(), Messages.ArduinoLaunchConfigurationDelegate_2);
                        return status;
                    }
                    try {
                        IProject project = (IProject)configuration.getMappedResources()[0];
                        ICProjectDescription projDesc = CCorePlugin.getDefault().getProjectDescription(project);
                        ICConfigurationDescription configDesc = ArduinoLaunchConfigurationDelegate.this.getBuildConfiguration(projDesc, target);
                        IEnvironmentVariable[] envVars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(configDesc, true);
                        ArrayList<String> envVarList = new ArrayList<String>(envVars.length + 1);
                        IEnvironmentVariable[] iEnvironmentVariableArray = envVars;
                        int n = envVars.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                            envVarList.add(String.valueOf(var.getName()) + '=' + var.getValue());
                            ++n2;
                        }
                        IArduinoRemoteConnection arduinoRemote = (IArduinoRemoteConnection)target.getService(IArduinoRemoteConnection.class);
                        envVarList.add("SERIAL_PORT=" + arduinoRemote.getPortName());
                        String[] envp = envVarList.toArray(new String[envVarList.size()]);
                        File projectDir = new File(project.getLocationURI());
                        IConfiguration buildConfig = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDesc);
                        String command = buildConfig.getBuilder().getCommand();
                        boolean wasOpened = target.isOpen();
                        if (wasOpened) {
                            arduinoRemote.pause();
                        }
                        Process process = Runtime.getRuntime().exec(String.valueOf(command) + " load", envp, projectDir);
                        consoleService.monitor(process);
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {}
                        if (wasOpened) {
                            arduinoRemote.resume();
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        return iStatus;
                    }
                    catch (IOException e) {
                        Status status = new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e);
                        return status;
                    }
                }
                finally {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private ArduinoLaunchConsoleService getConsoleService() throws CoreException {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(Activator.getId(), "consoleService");
        IExtension extension = point.getExtensions()[0];
        return (ArduinoLaunchConsoleService)extension.getConfigurationElements()[0].createExecutableExtension("class");
    }

    private ICConfigurationDescription getBuildConfiguration(ICProjectDescription projDesc, IRemoteConnection target) throws CoreException {
        String boardId;
        if (target != null) {
            IArduinoRemoteConnection arduinoRemote = (IArduinoRemoteConnection)target.getService(IArduinoRemoteConnection.class);
            boardId = arduinoRemote.getBoard().getId();
        } else {
            boardId = "uno";
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projDesc.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDesc = iCConfigurationDescriptionArray[n2];
            IConfiguration config = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDesc);
            if (ArduinoProjectGenerator.getBoard(config).getId().equals(boardId)) {
                return configDesc;
            }
            ++n2;
        }
        return null;
    }
}

