/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.arduino.core.Board;
import org.eclipse.cdt.arduino.core.IArduinoBoardManager;
import org.eclipse.cdt.arduino.core.IArduinoRemoteConnection;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class ArduinoTargetPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Combo portSelector;
    private Combo boardSelector;
    private Board[] boards;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        IRemoteConnection remoteConnection = (IRemoteConnection)this.getElement().getAdapter(IRemoteConnection.class);
        IArduinoRemoteConnection arduinoRemote = (IArduinoRemoteConnection)remoteConnection.getService(IArduinoRemoteConnection.class);
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.ArduinoTargetPropertyPage_0);
        this.portSelector = new Combo(comp, 8);
        this.portSelector.setLayoutData((Object)new GridData(768));
        String currentPort = arduinoRemote.getPortName();
        int i = 0;
        int portSel = -1;
        try {
            String[] stringArray = SerialPort.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String port = stringArray[n2];
                this.portSelector.add(port);
                portSel = port.equals(currentPort) ? i : (portSel < 0 ? 0 : portSel);
                ++i;
                ++n2;
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
        if (portSel >= 0) {
            this.portSelector.select(portSel);
        } else {
            this.setMessage(Messages.ArduinoTargetPropertyPage_1, 3);
            this.setValid(false);
        }
        Label boardLabel = new Label(comp, 0);
        boardLabel.setText(Messages.ArduinoTargetPropertyPage_2);
        this.boardSelector = new Combo(comp, 8);
        this.boardSelector.setLayoutData((Object)new GridData(768));
        Board currentBoard = arduinoRemote.getBoard();
        IArduinoBoardManager boardManager = Activator.getService(IArduinoBoardManager.class);
        Collection boardList = boardManager.getBoards();
        this.boards = new Board[boardList.size()];
        i = 0;
        int boardSel = 0;
        Iterator iterator = boardList.iterator();
        while (iterator.hasNext()) {
            Board board;
            this.boards[i] = board = (Board)iterator.next();
            this.boardSelector.add(board.getName());
            if (board.equals(currentBoard)) {
                boardSel = i;
            }
            ++i;
        }
        this.boardSelector.select(boardSel);
        return comp;
    }

    public boolean performOk() {
        IRemoteConnection remoteConnection = (IRemoteConnection)this.getElement().getAdapter(IRemoteConnection.class);
        IRemoteConnectionWorkingCopy workingCopy = remoteConnection.getWorkingCopy();
        String portName = this.portSelector.getItem(this.portSelector.getSelectionIndex());
        workingCopy.setAttribute("ardiuno.portname", portName);
        Board board = this.boards[this.boardSelector.getSelectionIndex()];
        workingCopy.setAttribute("arduino.board", board.getId());
        try {
            workingCopy.save();
        }
        catch (RemoteConnectionException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return true;
    }
}

