/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.internal.autotools.ui.wizards.AutotoolsProjectImportWizardPage;
import org.eclipse.cdt.internal.autotools.ui.wizards.CProjectPlatformPage;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewMakeProjFromExisting;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class AutotoolsProjectImportWizard
extends NewMakeProjFromExisting {
    private final String TITLE = "Import Existing code as Autotools project";
    private static final String PREFIX = "WizardAutotoolsConversion";
    protected static final String CONF_TITLE = "WizardAutotoolsConversion.config.title";
    protected static final String CONF_DESC = "WizardAutotoolsConversion.config.desc";
    private AutotoolsProjectImportWizardPage page;
    protected CProjectPlatformPage projectConfigurationPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Import Existing code as Autotools project");
    }

    public void addPages() {
        this.page = new AutotoolsProjectImportWizardPage();
        this.addPage((IWizardPage)this.page);
        this.projectConfigurationPage = new CProjectPlatformPage(PREFIX, (Wizard)this);
        this.projectConfigurationPage.setTitle(AutotoolsUIPlugin.getResourceString(CONF_TITLE));
        this.projectConfigurationPage.setDescription(AutotoolsUIPlugin.getResourceString(CONF_DESC));
        this.addPage((IWizardPage)this.projectConfigurationPage);
        MBSCustomPageManager.init();
        MBSCustomPageManager.addStockPage((IWizardPage)this.projectConfigurationPage, (String)"org.eclipse.cdt.managedbuilder.ui.wizard.platformPage");
    }

    public IProjectType getProjectType() {
        return this.projectConfigurationPage.getProjectType();
    }

    public IConfiguration[] getSelectedConfigurations() {
        return this.projectConfigurationPage.getSelectedConfigurations();
    }

    public boolean performFinish() {
        final String projectName = this.page.getProjectName();
        final String locationStr = this.page.getLocation();
        final boolean isCPP = this.page.isCPP();
        final IToolChain toolChain = this.page.getToolChain();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.beginTask("Creating Autotools project", 10);
                try {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(projectName);
                    IProjectDescription description = workspace.newProjectDescription(projectName);
                    IPath defaultLocation = workspace.getRoot().getLocation().append(projectName);
                    Path location = new Path(locationStr);
                    if (!location.isEmpty() && !location.equals((Object)defaultLocation)) {
                        description.setLocation((IPath)location);
                    }
                    CCorePlugin.getDefault().createCDTProject(description, project, monitor);
                    if (isCPP) {
                        CCProjectNature.addCCNature((IProject)project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    ICProjectDescriptionManager pdMgr = CoreModel.getDefault().getProjectDescriptionManager();
                    ICProjectDescription projDesc = pdMgr.createProjectDescription(project, false);
                    ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
                    ManagedProject mProj = new ManagedProject(projDesc);
                    info.setManagedProject((IManagedProject)mProj);
                    monitor.worked(1);
                    CfgHolder cfgHolder = new CfgHolder(toolChain, null);
                    String s = toolChain == null ? "0" : ((ToolChain)toolChain).getId();
                    Configuration config = new Configuration(mProj, (ToolChain)toolChain, ManagedBuildManager.calculateChildId((String)s, null), cfgHolder.getName());
                    IBuilder builder = config.getEditableBuilder();
                    builder.setManagedBuildOn(false);
                    CConfigurationData data = config.getConfigurationData();
                    projDesc.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
                    monitor.worked(1);
                    pdMgr.setProjectDescription(project, projDesc);
                    AutotoolsProjectImportWizard.this.page.convertProject(project, monitor, projectName);
                }
                catch (Throwable throwable) {}
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }
}

