/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownMemberClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;

public class CPPUnknownTypeScope
implements ICPPInternalUnknownScope {
    private final IASTName fName;
    private final IType fScopeType;
    private CharArrayObjectMap<IBinding[]> map;

    public CPPUnknownTypeScope(IType scopeType, IASTName name) {
        this.fName = name;
        this.fScopeType = scopeType;
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    @Override
    public IASTNode getPhysicalNode() {
        return this.fName;
    }

    @Override
    public IName getScopeName() {
        return this.fName;
    }

    @Override
    public IType getScopeType() {
        return this.fScopeType;
    }

    @Override
    public IScope getParent() throws DOMException {
        if (this.fScopeType instanceof IBinding) {
            return ((IBinding)((Object)this.fScopeType)).getScope();
        }
        return null;
    }

    @Override
    public IBinding[] find(String name) {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        boolean type = false;
        boolean function = false;
        if (name.getPropertyInParent() == null) {
            type = true;
        } else {
            IASTName n = name;
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTTemplateId) {
                n = (IASTName)parent;
                parent = n.getParent();
            }
            if (parent instanceof ICPPASTQualifiedName) {
                ICPPASTQualifiedName qname = (ICPPASTQualifiedName)parent;
                if (qname.getLastName() != n) {
                    type = true;
                } else {
                    parent = qname.getParent();
                }
            }
            if (!type) {
                if (parent instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier || parent instanceof ICPPASTConstructorChainInitializer) {
                    type = true;
                } else if (parent instanceof ICPPASTNamedTypeSpecifier) {
                    ICPPASTNamedTypeSpecifier nts = (ICPPASTNamedTypeSpecifier)parent;
                    type = nts.isTypename();
                } else if (parent instanceof ICPPASTUsingDeclaration) {
                    ICPPASTUsingDeclaration ud = (ICPPASTUsingDeclaration)parent;
                    type = ud.isTypename();
                    function = true;
                }
                if (!type && parent.getPropertyInParent() == IASTFunctionCallExpression.FUNCTION_NAME) {
                    function = true;
                }
            }
        }
        int idx = type ? 0 : (function ? 1 : 2);
        IBinding result = this.getOrCreateBinding(name.getSimpleID(), idx);
        return result;
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public final IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        if (lookup.isPrefixLookup()) {
            IScope scope = CPPSemantics.heuristicallyFindConcreteScopeForType(this.fScopeType, lookup.getLookupPoint());
            if (scope != null) {
                return scope.getBindings(lookup);
            }
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        IASTName lookupName = lookup.getLookupName();
        if (lookupName != null) {
            return new IBinding[]{this.getBinding(lookupName, lookup.isResolve(), lookup.getIncludedFiles())};
        }
        return new IBinding[]{this.getOrCreateBinding(lookup.getLookupKey(), 0)};
    }

    public String toString() {
        return this.fName.toString();
    }

    @Override
    public void addName(IASTName name) {
    }

    protected IBinding getOrCreateBinding(char[] name, int idx) {
        IBinding result;
        IBinding[] o;
        if (this.map == null) {
            this.map = new CharArrayObjectMap(2);
        }
        if ((o = this.map.get(name)) == null) {
            o = new IBinding[3];
            this.map.put(name, o);
        }
        if ((result = o[idx]) == null) {
            switch (idx) {
                case 0: {
                    result = new CPPUnknownMemberClass(this.fScopeType, name);
                    break;
                }
                case 1: {
                    result = new CPPUnknownMethod(this.fScopeType, name);
                    break;
                }
                case 2: {
                    result = new CPPUnknownField(this.fScopeType, name);
                }
            }
            o[idx] = result;
        }
        return result;
    }

    @Override
    public void addBinding(IBinding binding) {
    }

    @Override
    public void populateCache() {
    }

    @Override
    public void removeNestedFromCache(IASTNode container) {
    }
}

