/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class EvalBinding
extends CPPDependentEvaluation {
    private ICPPFunction fParameterOwner;
    private int fParameterPosition;
    private IBinding fBinding;
    private final boolean fFixedType;
    private IType fType;
    private boolean fCheckedIsValueDependent;
    private boolean fIsValueDependent;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsTypeDependent;

    public EvalBinding(IBinding binding, IType type, IASTNode pointOfDefinition) {
        this(binding, type, EvalBinding.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalBinding(IBinding binding, IType type, IBinding templateDefinition) {
        super(templateDefinition);
        this.fParameterPosition = -1;
        this.fBinding = binding;
        this.fType = type;
        this.fFixedType = type != null;
    }

    public EvalBinding(ICPPFunction parameterOwner, int parameterPosition, IType type, IASTNode pointOfDefinition) {
        this(parameterOwner, parameterPosition, type, EvalBinding.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalBinding(ICPPFunction parameterOwner, int parameterPosition, IType type, IBinding templateDefinition) {
        super(templateDefinition);
        this.fParameterOwner = parameterOwner;
        this.fParameterPosition = parameterPosition;
        this.fType = type;
        this.fFixedType = type != null;
    }

    public IBinding getBinding() {
        if (this.fBinding == null) {
            ICPPParameter[] parameters = this.fParameterOwner.getParameters();
            this.fBinding = parameters[this.fParameterPosition];
        }
        return this.fBinding;
    }

    public int getFunctionParameterPosition() {
        if (this.fParameterPosition < 0) {
            if (this.fBinding instanceof CPPParameter) {
                this.fParameterPosition = ((CPPParameter)this.fBinding).getParameterPosition();
            } else {
                ICPPFunction parameterOwner = this.getParameterOwner();
                if (parameterOwner != null) {
                    Object[] parameters = this.fParameterOwner.getParameters();
                    this.fParameterPosition = EvalBinding.findInArray(parameters, this.fBinding);
                }
            }
        }
        return this.fParameterPosition;
    }

    private static int findInArray(Object[] array, Object obj) {
        int i = 0;
        while (i < array.length) {
            if (obj == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ICPPFunction getParameterOwner() {
        IBinding owner;
        if (this.fParameterOwner == null && this.fBinding instanceof ICPPParameter && (owner = this.fBinding.getOwner()) instanceof ICPPFunction) {
            this.fParameterOwner = (ICPPFunction)owner;
        }
        return this.fParameterOwner;
    }

    public int getTemplateParameterID() {
        return this.fBinding instanceof ICPPTemplateParameter ? ((ICPPTemplateParameter)this.fBinding).getParameterID() : -1;
    }

    public IType getFixedType() {
        return this.fFixedType ? this.fType : null;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = this.computeIsTypeDependent();
        }
        return this.fIsTypeDependent;
    }

    private boolean computeIsTypeDependent() {
        IType t = null;
        if (this.fFixedType) {
            t = this.fType;
        } else {
            IBinding binding = this.getBinding();
            if (binding instanceof IEnumerator) {
                t = ((IEnumerator)binding).getType();
            } else if (binding instanceof ICPPTemplateNonTypeParameter) {
                t = ((ICPPTemplateNonTypeParameter)binding).getType();
            } else if (binding instanceof IVariable) {
                t = ((IVariable)binding).getType();
            } else {
                if (binding instanceof ICPPUnknownBinding) {
                    return true;
                }
                if (binding instanceof IFunction) {
                    t = ((IFunction)binding).getType();
                } else {
                    return false;
                }
            }
        }
        return CPPTemplates.isDependentType(t);
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedIsValueDependent) {
            this.fCheckedIsValueDependent = true;
            this.fIsValueDependent = this.computeIsValueDependent();
        }
        return this.fIsValueDependent;
    }

    private boolean computeIsValueDependent() {
        if (this.fBinding instanceof IEnumerator) {
            return Value.isDependentValue(((IEnumerator)this.fBinding).getValue());
        }
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            return true;
        }
        if (this.fBinding instanceof IVariable) {
            return Value.isDependentValue(((IVariable)this.fBinding).getInitialValue());
        }
        if (this.fBinding instanceof ICPPUnknownBinding) {
            return true;
        }
        if (this.fBinding instanceof IFunction) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isConstantExpression(IASTNode point) {
        return this.fBinding instanceof IEnumerator || this.fBinding instanceof ICPPFunction || this.fBinding instanceof IVariable && EvalBinding.isConstexprValue(((IVariable)this.fBinding).getInitialValue(), point);
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        IBinding binding = this.getBinding();
        if (binding instanceof IEnumerator) {
            return ((IEnumerator)binding).getType();
        }
        if (binding instanceof ICPPTemplateNonTypeParameter) {
            IType type = ((ICPPTemplateNonTypeParameter)binding).getType();
            if (type instanceof ICPPParameterPackType) {
                type = ((ICPPParameterPackType)type).getType();
            }
            return ExpressionTypes.prvalueType(type);
        }
        if (binding instanceof IVariable) {
            IType type = ((IVariable)binding).getType();
            if (type instanceof IArrayType && ((IArrayType)type).getSize() == null && binding instanceof IIndexBinding && point != null) {
                IASTName[] definitions;
                IASTTranslationUnit ast = point.getTranslationUnit();
                IASTName[] iASTNameArray = definitions = ast.getDefinitionsInAST(binding);
                int n = definitions.length;
                int n2 = 0;
                while (n2 < n) {
                    IType localType;
                    IASTName definition = iASTNameArray[n2];
                    IASTDeclarator declarator = CPPVisitor.findAncestorWithType(definition, IASTDeclarator.class);
                    if (declarator != null && (localType = CPPVisitor.createType(declarator)) instanceof IArrayType && ((IArrayType)localType).getSize() != null) {
                        type = localType;
                        break;
                    }
                    ++n2;
                }
            }
            return SemanticUtil.mapToAST(ExpressionTypes.glvalueType(type), point);
        }
        if (binding instanceof IFunction) {
            IFunctionType type = ((IFunction)binding).getType();
            return SemanticUtil.mapToAST(type, point);
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.isValueDependent()) {
            return Value.create(this);
        }
        IValue value = null;
        if (this.fBinding instanceof IVariable) {
            value = ((IVariable)this.fBinding).getInitialValue();
        } else if (this.fBinding instanceof IEnumerator) {
            value = ((IEnumerator)this.fBinding).getValue();
        }
        if (value == null) {
            value = Value.UNKNOWN;
        }
        return value;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        if (this.fBinding instanceof ICPPTemplateNonTypeParameter) {
            return IASTExpression.ValueCategory.PRVALUE;
        }
        if (this.fBinding instanceof IFunction || this.fBinding instanceof IVariable || this.fBinding == null) {
            return IASTExpression.ValueCategory.LVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 3;
        ICPPFunction parameterOwner = this.getParameterOwner();
        if (parameterOwner != null) {
            buffer.putShort((short)35);
            buffer.marshalBinding(parameterOwner);
            buffer.putInt(this.getFunctionParameterPosition());
        } else {
            buffer.putShort(firstBytes);
            buffer.marshalBinding(this.fBinding);
        }
        buffer.marshalType(this.fFixedType ? this.fType : null);
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        if ((firstBytes & 0x20) != 0) {
            ICPPFunction parameterOwner = (ICPPFunction)buffer.unmarshalBinding();
            int parameterPosition = buffer.getInt();
            IType type = buffer.unmarshalType();
            IBinding templateDefinition = buffer.unmarshalBinding();
            return new EvalBinding(parameterOwner, parameterPosition, type, templateDefinition);
        }
        IBinding binding = buffer.unmarshalBinding();
        IType type = buffer.unmarshalType();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalBinding(binding, type, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPTypeSpecialization within, int maxdepth, IASTNode point) {
        IBinding origBinding = this.getBinding();
        if (origBinding instanceof ICPPTemplateNonTypeParameter) {
            ICPPTemplateArgument argument;
            if (tpMap != null && (argument = tpMap.getArgument((ICPPTemplateNonTypeParameter)origBinding, packOffset)) != null && argument.isNonTypeValue()) {
                return argument.getNonTypeEvaluation();
            }
        } else if (origBinding instanceof ICPPParameter) {
            IType instantiatedType;
            ICPPParameter parameter = (ICPPParameter)origBinding;
            IType origType = parameter.getType();
            if (origType instanceof ICPPParameterPackType && packOffset != -1) {
                origType = ((ICPPParameterPackType)origType).getType();
            }
            if (origType != (instantiatedType = CPPTemplates.instantiateType(origType, tpMap, packOffset, within, point))) {
                return new EvalFixed(instantiatedType, IASTExpression.ValueCategory.LVALUE, Value.create(this));
            }
        } else {
            IBinding instantiatedBinding = EvalBinding.instantiateBinding(origBinding, tpMap, packOffset, within, maxdepth, point);
            if (instantiatedBinding != origBinding) {
                return new EvalBinding(instantiatedBinding, null, this.getTemplateDefinition());
            }
        }
        return this;
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(CPPFunctionParameterMap parameterMap, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation eval;
        int pos = this.getFunctionParameterPosition();
        if (pos >= 0 && (eval = parameterMap.getArgument(pos)) != null) {
            return eval;
        }
        return this;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        IBinding binding = this.getBinding();
        if (binding instanceof IEnumerator) {
            return CPPTemplates.determinePackSize(((IEnumerator)binding).getValue(), tpMap);
        }
        if (binding instanceof ICPPTemplateNonTypeParameter) {
            return CPPTemplates.determinePackSize((ICPPTemplateNonTypeParameter)binding, tpMap);
        }
        if (binding instanceof ICPPUnknownBinding) {
            return CPPTemplates.determinePackSize((ICPPUnknownBinding)binding, tpMap);
        }
        if (binding instanceof ICPPParameter && ((ICPPParameter)binding).isParameterPack()) {
            ICPPParameterPackType type = (ICPPParameterPackType)((ICPPParameter)binding).getType();
            return CPPTemplates.determinePackSize(type.getType(), tpMap);
        }
        if (binding instanceof ICPPSpecialization) {
            binding = ((ICPPSpecialization)binding).getSpecializedBinding();
        }
        int r = Integer.MAX_VALUE;
        if (binding instanceof ICPPTemplateDefinition) {
            ICPPTemplateParameter[] parameters;
            ICPPTemplateParameter[] iCPPTemplateParameterArray = parameters = ((ICPPTemplateDefinition)binding).getTemplateParameters();
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateParameter param = iCPPTemplateParameterArray[n2];
                r = CPPTemplates.combinePackSize(r, CPPTemplates.determinePackSize(param, tpMap));
                ++n2;
            }
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.fBinding instanceof ICPPTemplateParameter;
    }
}

