/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;

public class RSEHelper {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";

    public static IHost getRemoteConnectionByName(String remoteConnection) {
        if (remoteConnection == null) {
            return null;
        }
        IHost[] connections = RSECorePlugin.getTheSystemRegistry().getHosts();
        int i = 0;
        while (i < connections.length) {
            if (connections[i].getAliasName().equals(remoteConnection)) {
                return connections[i];
            }
            ++i;
        }
        return null;
    }

    public static IService getConnectedRemoteFileService(IHost currentConnection, IProgressMonitor monitor) throws Exception {
        ISubSystem subsystem = RSEHelper.getFileSubsystem(currentConnection);
        if (subsystem == null) {
            throw new Exception(Messages.RemoteRunLaunchDelegate_4);
        }
        try {
            subsystem.connect(monitor, false);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (!subsystem.isConnected()) {
            throw new Exception(Messages.RemoteRunLaunchDelegate_5);
        }
        return ((IFileServiceSubSystem)subsystem).getFileService();
    }

    public static IService getConnectedRemoteShellService(IHost currentConnection, IProgressMonitor monitor) throws Exception {
        ISubSystem subsystem = RSEHelper.getSubSystemWithShellService(currentConnection);
        if (subsystem != null) {
            try {
                subsystem.connect(monitor, false);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            if (!subsystem.isConnected()) {
                throw new Exception(Messages.RemoteRunLaunchDelegate_5);
            }
            return (IService)subsystem.getSubSystemConfiguration().getService(currentConnection).getAdapter(IShellService.class);
        }
        throw new Exception(Messages.RemoteRunLaunchDelegate_4);
    }

    public static IShellService getShellService(IHost host) {
        ISubSystem ss = RSEHelper.getSubSystemWithShellService(host);
        if (ss != null) {
            return (IShellService)ss.getSubSystemConfiguration().getService(host).getAdapter(IShellService.class);
        }
        return null;
    }

    public static ISubSystem getSubSystemWithShellService(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        IShellService ssvc = null;
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            IService svc = subSystems[i].getSubSystemConfiguration().getService(host);
            if (svc != null && (ssvc = (IShellService)svc.getAdapter(IShellService.class)) != null) {
                return subSystems[i];
            }
            ++i;
        }
        return null;
    }

    public static ISubSystem getFileSubsystem(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        int i = 0;
        while (i < subSystems.length) {
            if (subSystems[i] instanceof IFileServiceSubSystem) {
                return subSystems[i];
            }
            ++i;
        }
        return null;
    }

    public static IHost[] getSuitableConnections() {
        ArrayList<IHost> shellConnections = new ArrayList<IHost>(Arrays.asList(RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory("shells")));
        ArrayList<IHost> terminalConnections = new ArrayList<IHost>(Arrays.asList(RSECorePlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory("terminals")));
        for (IHost terminalConnection : terminalConnections) {
            if (shellConnections.contains(terminalConnection)) continue;
            shellConnections.add(terminalConnection);
        }
        return shellConnections.toArray(new IHost[shellConnections.size()]);
    }

    public static void remoteFileDownload(ILaunchConfiguration config, ILaunch launch, String localExePath, String remoteExePath, IProgressMonitor monitor) throws CoreException {
        boolean skipDownload = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        if (skipDownload) {
            return;
        }
        monitor.beginTask(Messages.RemoteRunLaunchDelegate_2, 100);
        try {
            try {
                IFileService fileService = (IFileService)RSEHelper.getConnectedRemoteFileService(RSEHelper.getCurrentConnection(config), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                File file = new File(localExePath);
                Path remotePath = new Path(remoteExePath);
                fileService.upload(file, remotePath.removeLastSegments(1).toString(), remotePath.lastSegment(), true, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
                RSEHelper.remoteShellExec(config, "", "chmod", "+x " + RSEHelper.spaceEscapify(remotePath.toString()), (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            }
            catch (SystemOperationCancelledException e) {
                RSEHelper.abort(e.getLocalizedMessage(), null, 8);
                monitor.done();
            }
            catch (Exception e) {
                RSEHelper.abort(Messages.RemoteRunLaunchDelegate_6, e, 150);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public static String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public static IHost getCurrentConnection(ILaunchConfiguration config) throws CoreException {
        String remoteConnection = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, "");
        IHost connection = RSEHelper.getRemoteConnectionByName(remoteConnection);
        if (connection == null) {
            RSEHelper.abort(Messages.RemoteRunLaunchDelegate_13, null, 150);
        }
        return connection;
    }

    public static Process remoteShellExec(ILaunchConfiguration config, String prelaunchCmd, String remoteCommandPath, String arguments, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)arguments), 10);
        String realRemoteCommand = arguments == null ? RSEHelper.spaceEscapify(remoteCommandPath) : String.valueOf(RSEHelper.spaceEscapify(remoteCommandPath)) + " " + arguments;
        String remoteCommand = String.valueOf(realRemoteCommand) + CMD_DELIMITER + EXIT_CMD;
        if (!prelaunchCmd.trim().equals("")) {
            remoteCommand = String.valueOf(prelaunchCmd) + CMD_DELIMITER + remoteCommand;
        }
        Process p = null;
        try {
            IShellService shellService = (IShellService)RSEHelper.getConnectedRemoteShellService(RSEHelper.getCurrentConnection(config), (IProgressMonitor)new SubProgressMonitor(monitor, 7));
            String[] env = new String[]{};
            try {
                IHostShell hostShell = shellService.launchShell("", env, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                hostShell.writeToShell(remoteCommand);
                p = new HostShellProcessAdapter(hostShell);
            }
            catch (Exception e) {
                if (p != null) {
                    p.destroy();
                }
                RSEHelper.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
            }
        }
        catch (Exception e1) {
            RSEHelper.abort(e1.getMessage(), e1, 150);
        }
        monitor.done();
        return p;
    }

    public static IHostShell execCmdInRemoteShell(ILaunchConfiguration config, String prelaunchCmd, String remoteCommandPath, String arguments, IProgressMonitor monitor) throws Exception {
        monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)arguments), 10);
        String realRemoteCommand = arguments == null ? RSEHelper.spaceEscapify(remoteCommandPath) : String.valueOf(RSEHelper.spaceEscapify(remoteCommandPath)) + " " + arguments;
        String remoteCommand = String.valueOf(realRemoteCommand) + CMD_DELIMITER + EXIT_CMD;
        if (!prelaunchCmd.trim().equals("")) {
            remoteCommand = String.valueOf(prelaunchCmd) + CMD_DELIMITER + remoteCommand;
        }
        IShellService shellService = null;
        shellService = (IShellService)RSEHelper.getConnectedRemoteShellService(RSEHelper.getCurrentConnection(config), (IProgressMonitor)new SubProgressMonitor(monitor, 7));
        String[] env = new String[]{};
        IHostShell hostShell = null;
        if (shellService != null) {
            hostShell = shellService.launchShell("", env, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            hostShell.writeToShell(remoteCommand);
        }
        monitor.done();
        return hostShell;
    }

    public static String getRemoteHostname(ILaunchConfiguration config) throws CoreException {
        IHost currentConnection = RSEHelper.getCurrentConnection(config);
        return currentConnection.getHostName();
    }

    public static void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.cdt.launch.remote", code, message, exception);
            multiStatus.add((IStatus)new Status(4, "org.eclipse.cdt.launch.remote", code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, "org.eclipse.cdt.launch.remote", code, message, null);
        }
        throw new CoreException((IStatus)status);
    }
}

