/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IConnectHandler;
import org.eclipse.cdt.debug.internal.core.DebugStringVariableSubstitutor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.gdb.actions.IConnect;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.CSourceLookup;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIGDBVersionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;

public class FinalLaunchSequence
extends ReflectionSequence {
    private Map<String, Object> fAttributes;
    private IGDBControl fCommandControl;
    private IGDBBackend fGDBBackend;
    private IMIProcesses fProcService;
    private CommandFactory fCommandFactory;
    private DsfServicesTracker fTracker;
    private DsfSession fSession;
    private static final String INVALID = "invalid";

    public FinalLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session.getExecutor(), rm, LaunchMessages.getString("FinalLaunchSequence.0"), LaunchMessages.getString("FinalLaunchSequence.1"));
        this.fSession = session;
        this.fAttributes = attributes;
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            return new String[]{"stepInitializeFinalLaunchSequence", "stepGDBVersion", "stepSetEnvironmentDirectory", "stepSetBreakpointPending", "stepEnablePrettyPrinting", "stepSetPrintObject", "stepSetCharset", "stepSourceGDBInitFile", "stepSetAutoLoadSharedLibrarySymbols", "stepSetSharedLibraryPaths", "stepRemoteConnection", "stepNewProcess", "stepAttachToProcess", "stepDataModelInitializationComplete", "stepCleanup"};
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeFinalLaunchSequence(RequestMonitor requestMonitor) {
        this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSession.getId());
        this.fGDBBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fGDBBackend == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot obtain GDBBackend service", null));
            requestMonitor.done();
            return;
        }
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        if (this.fCommandControl == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot obtain control service", null));
            requestMonitor.done();
            return;
        }
        this.fCommandFactory = this.fCommandControl.getCommandFactory();
        this.fProcService = (IMIProcesses)this.fTracker.getService(IMIProcesses.class);
        if (this.fProcService == null) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot obtain process service", null));
            requestMonitor.done();
            return;
        }
        requestMonitor.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeFinalLaunchSequence")
    public void rollBackInitializeFinalLaunchSequence(RequestMonitor requestMonitor) {
        if (this.fTracker != null) {
            this.fTracker.dispose();
        }
        this.fTracker = null;
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepGDBVersion(final RequestMonitor requestMonitor) {
        this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBVersion(this.fCommandControl.getContext()), (DataRequestMonitor)new DataRequestMonitor<MIGDBVersionInfo>((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                requestMonitor.done();
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSetEnvironmentDirectory(RequestMonitor requestMonitor) {
        IPath dir = null;
        try {
            dir = this.fGDBBackend.getGDBWorkingDirectory();
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get working directory", (Throwable)e));
            requestMonitor.done();
            return;
        }
        if (dir != null) {
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIEnvironmentCD(this.fCommandControl.getContext(), dir.toPortableString()), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        } else {
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetBreakpointPending(RequestMonitor requestMonitor) {
        if (this.fGDBBackend.getSessionType() != SessionType.CORE) {
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetBreakpointPending(this.fCommandControl.getContext(), true), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        } else {
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepEnablePrettyPrinting(final RequestMonitor requestMonitor) {
        if (Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "enablePrettyPrinting", false, null)) {
            this.fCommandControl.enablePrettyPrintingForMIVariableObjects(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

                protected void handleCompleted() {
                    FinalLaunchSequence.this.fCommandControl.setPrintPythonErrors(false, (RequestMonitor)new ImmediateRequestMonitor(){

                        protected void handleCompleted() {
                            requestMonitor.done();
                        }
                    });
                }
            });
        } else {
            this.fCommandControl.setPrintPythonErrors(false, (RequestMonitor)new ImmediateRequestMonitor(){

                protected void handleCompleted() {
                    requestMonitor.done();
                }
            });
        }
    }

    @ReflectionSequence.Execute
    public void stepSetPrintObject(final RequestMonitor requestMonitor) {
        boolean useRtti = Platform.getPreferencesService().getBoolean("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb.useRtti", false, null);
        this.fCommandControl.queueCommand(this.fCommandControl.getCommandFactory().createMIGDBSetPrintObject(this.fCommandControl.getContext(), useRtti), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

            protected void handleCompleted() {
                requestMonitor.done();
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSetCharset(final RequestMonitor requestMonitor) {
        this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetPrintSevenbitStrings(this.fCommandControl.getContext(), true), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(requestMonitor){

            protected void handleCompleted() {
                FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetCharset(FinalLaunchSequence.this.fCommandControl.getContext(), "ISO-8859-1"), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(requestMonitor){

                    protected void handleCompleted() {
                        requestMonitor.done();
                    }
                });
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSourceGDBInitFile(final RequestMonitor requestMonitor) {
        try {
            String gdbinitFile = this.fGDBBackend.getGDBInitFile();
            if (gdbinitFile != null && !gdbinitFile.isEmpty()) {
                String projectName = (String)this.fAttributes.get("org.eclipse.cdt.launch.PROJECT_ATTR");
                final String expandedGDBInitFile = new DebugStringVariableSubstitutor(projectName).performStringSubstitution(gdbinitFile);
                this.fCommandControl.queueCommand(this.fCommandFactory.createCLISource(this.fCommandControl.getContext(), expandedGDBInitFile), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

                    protected void handleCompleted() {
                        if (!expandedGDBInitFile.equals(".gdbinit")) {
                            requestMonitor.setStatus(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                });
            } else {
                requestMonitor.done();
            }
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot get gdbinit option", (Throwable)e));
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetNonStop(final RequestMonitor requestMonitor) {
        boolean isNonStop = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.NON_STOP", (Object)LaunchUtils.getIsNonStopModeDefault());
        if (isNonStop) {
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetTargetAsync(this.fCommandControl.getContext(), true), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

                protected void handleSuccess() {
                    FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetPagination(FinalLaunchSequence.this.fCommandControl.getContext(), false), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleSuccess() {
                            FinalLaunchSequence.this.fCommandControl.queueCommand(FinalLaunchSequence.this.fCommandFactory.createMIGDBSetNonStop(FinalLaunchSequence.this.fCommandControl.getContext(), true), new DataRequestMonitor((Executor)FinalLaunchSequence.this.getExecutor(), requestMonitor));
                        }
                    });
                }
            });
        } else {
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetTargetAsync(this.fCommandControl.getContext(), false), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

                protected void handleError() {
                    requestMonitor.done();
                }
            });
        }
    }

    @ReflectionSequence.Execute
    public void stepSetAutoLoadSharedLibrarySymbols(RequestMonitor requestMonitor) {
        boolean autolib = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", (Object)true);
        this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetAutoSolib(this.fCommandControl.getContext(), autolib), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
    }

    @ReflectionSequence.Execute
    public void stepSetSharedLibraryPaths(final RequestMonitor requestMonitor) {
        try {
            List<String> p = this.fGDBBackend.getSharedLibraryPaths();
            if (!p.isEmpty()) {
                String[] paths = p.toArray(new String[p.size()]);
                this.fCommandControl.queueCommand(this.fCommandFactory.createMIGDBSetSolibSearchPath(this.fCommandControl.getContext(), paths), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

                    protected void handleSuccess() {
                        requestMonitor.done();
                    }
                });
            } else {
                requestMonitor.done();
            }
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Cannot set share library paths", (Throwable)e));
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetSourceLookupPath(RequestMonitor requestMonitor) {
        CSourceLookup sourceLookup = (CSourceLookup)((Object)this.fTracker.getService(CSourceLookup.class));
        ILaunch launch = (ILaunch)this.fSession.getModelAdapter(ILaunch.class);
        CSourceLookupDirector locator = (CSourceLookupDirector)launch.getSourceLocator();
        ISourceLookup.ISourceLookupDMContext sourceLookupDmc = (ISourceLookup.ISourceLookupDMContext)this.fCommandControl.getContext();
        sourceLookup.setSourceLookupPath(sourceLookupDmc, locator.getSourceContainers(), requestMonitor);
    }

    @ReflectionSequence.Execute
    public void stepRemoteConnection(RequestMonitor rm) {
        if (this.fGDBBackend.getSessionType() == SessionType.REMOTE && this.fGDBBackend.getIsAttachSession()) {
            boolean isTcpConnection = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.REMOTE_TCP", (Object)false);
            if (isTcpConnection) {
                String remoteTcpHost = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.HOST", (Object)INVALID);
                String remoteTcpPort = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.PORT", (Object)INVALID);
                this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetSelect((IDMContext)this.fCommandControl.getContext(), remoteTcpHost, remoteTcpPort, true), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
            } else {
                String serialDevice = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.DEV", (Object)INVALID);
                this.fCommandControl.queueCommand(this.fCommandFactory.createMITargetSelect((IDMContext)this.fCommandControl.getContext(), serialDevice, true), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
            }
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepNewProcess(final RequestMonitor rm) {
        if (!this.fGDBBackend.getIsAttachSession()) {
            boolean noBinarySpecified = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.USE_SOLIB_SYMBOLS_FOR_APP", (Object)false);
            String binary = null;
            IPath execPath = this.fGDBBackend.getProgramPath();
            if (!noBinarySpecified && execPath != null && !execPath.isEmpty()) {
                binary = execPath.toPortableString();
            }
            this.fProcService.debugNewProcess((IDMContext)this.fCommandControl.getContext(), binary, this.fAttributes, (DataRequestMonitor)new DataRequestMonitor<IDMContext>((Executor)this.getExecutor(), rm){

                protected void handleCancel() {
                    rm.cancel();
                    rm.done();
                }
            });
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepAttachToProcess(RequestMonitor requestMonitor) {
        if (this.fGDBBackend.getIsAttachSession() && this.fGDBBackend.getSessionType() != SessionType.REMOTE) {
            int pid = (Integer)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.launch.ATTACH_PROCESS_ID", (Object)-1);
            if (pid != -1) {
                this.fProcService.attachDebuggerToProcess(this.fProcService.createProcessContext(this.fCommandControl.getContext(), Integer.toString(pid)), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
            } else {
                IConnectHandler connectCommand = (IConnectHandler)this.fSession.getModelAdapter(IConnectHandler.class);
                if (connectCommand instanceof IConnect) {
                    ((IConnect)connectCommand).connect(requestMonitor);
                } else {
                    requestMonitor.done();
                }
            }
        } else {
            requestMonitor.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepDataModelInitializationComplete(RequestMonitor requestMonitor) {
        this.fSession.dispatchEvent((Object)new DataModelInitializedEvent((IDMContext)this.fCommandControl.getContext()), this.fCommandControl.getProperties());
        requestMonitor.done();
    }

    @ReflectionSequence.Execute
    public void stepCleanup(RequestMonitor requestMonitor) {
        this.fTracker.dispose();
        this.fTracker = null;
        requestMonitor.done();
    }
}

