/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui;

import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputRequestor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ViewerInputService;
import org.eclipse.debug.internal.ui.views.variables.details.DefaultDetailPane;
import org.eclipse.debug.internal.ui.views.variables.details.DetailPaneProxy;
import org.eclipse.debug.internal.ui.views.variables.details.IDetailPaneContainer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class ExpressionInformationControlCreator
implements IInformationControlCreator {
    protected final boolean fShowDetailPane;
    protected final int fExpansionLevel;

    public ExpressionInformationControlCreator() {
        this(true, 1);
    }

    public ExpressionInformationControlCreator(boolean showDetailPane, int expansionLevel) {
        this.fShowDetailPane = showDetailPane;
        this.fExpansionLevel = expansionLevel;
    }

    public IInformationControl createInformationControl(Shell parent) {
        return new ExpressionInformationControl(parent, false);
    }

    private static final class ExpressionHoverPresentationContext
    extends PresentationContext {
        private ExpressionHoverPresentationContext(String id) {
            super(id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof ExpressionHoverPresentationContext && this.getId().equals(((PresentationContext)obj).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }

    class ExpressionInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2,
    IViewerInputRequestor {
        private static final String HEIGHT = "HEIGHT";
        private static final String WIDTH = "WIDTH";
        private static final String SASH_WEIGHT_TREE = "SashWeightTree";
        private static final String SASH_WEIGHT_DETAILS = "SashWeightDetails";
        private Object fVariable;
        private TreeModelViewer fViewer;
        private SashForm fSashForm;
        private Composite fDetailPaneComposite;
        private DetailPaneProxy fDetailPane;
        private Tree fTree;
        private IViewerUpdateListener fViewerUpdateListener;
        private ViewerInputService fInputService;
        private IInformationControlCreator fInformationControlCreator;

        ExpressionInformationControl(Shell parentShell, boolean resize) {
            super(parentShell, resize);
            this.create();
        }

        public Point computeSizeConstraints(int widthInChars, int heightInChars) {
            Point dialogSettingsSize = this.getDialogSettingsSize();
            if (dialogSettingsSize != null) {
                return dialogSettingsSize;
            }
            return super.computeSizeConstraints(widthInChars, heightInChars);
        }

        public Point computeSizeHint() {
            Point dialogSettingsSize = this.getDialogSettingsSize();
            if (dialogSettingsSize != null) {
                return dialogSettingsSize;
            }
            return super.computeSizeHint();
        }

        private Point getDialogSettingsSize() {
            int y;
            int x;
            IDialogSettings settings = this.getDialogSettings(false);
            if (settings != null && (x = this.getIntSetting(settings, WIDTH)) > 0 && (y = this.getIntSetting(settings, HEIGHT)) > 0) {
                return new Point(x, y);
            }
            return null;
        }

        public void setSize(int width, int height) {
            if (!this.isResizable() && this.fDetailPaneComposite != null) {
                height += this.fDetailPaneComposite.computeSize((int)-1, (int)-1).y;
            }
            super.setSize(width, height);
        }

        private IDialogSettings getDialogSettings(boolean create) {
            IDialogSettings settings = DsfUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
            if (section == null & create) {
                section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
            }
            return section;
        }

        private int getIntSetting(IDialogSettings settings, String key) {
            try {
                return settings.getInt(key);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        public void dispose() {
            this.persistSettings(this.getShell());
            super.dispose();
        }

        private void persistSettings(Shell shell) {
            if (shell != null && !shell.isDisposed() && this.isResizable()) {
                IDialogSettings settings = this.getDialogSettings(true);
                Point size = shell.getSize();
                settings.put(WIDTH, size.x);
                settings.put(HEIGHT, size.y);
                int[] weights = this.fSashForm.getWeights();
                if (weights.length == 1) {
                    settings.put(SASH_WEIGHT_TREE, weights[0]);
                } else if (weights.length == 2) {
                    settings.put(SASH_WEIGHT_TREE, weights[0]);
                    settings.put(SASH_WEIGHT_DETAILS, weights[1]);
                }
            }
        }

        public void setVisible(boolean visible) {
            if (!visible) {
                if (this.fViewer != null && this.fViewerUpdateListener != null) {
                    this.fViewer.removeViewerUpdateListener(this.fViewerUpdateListener);
                    this.fViewerUpdateListener = null;
                }
                this.persistSettings(this.getShell());
            }
            super.setVisible(visible);
        }

        protected void createContent(Composite parent) {
            StructuredViewer structuredViewer;
            int i;
            this.fSashForm = new SashForm(parent, parent.getStyle());
            this.fSashForm.setOrientation(512);
            AbstractDebugView view = this.getViewToEmulate();
            ExpressionHoverPresentationContext context = new ExpressionHoverPresentationContext("org.eclipse.cdt.dsf.ui.expression_hover");
            if (view != null) {
                IPresentationContext copy = ((TreeModelViewer)view.getViewer()).getPresentationContext();
                try {
                    String[] properties = copy.getProperties();
                    i = 0;
                    while (i < properties.length) {
                        String key = properties[i];
                        context.setProperty(key, copy.getProperty(key));
                        ++i;
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            }
            this.fViewer = new TreeModelViewer((Composite)this.fSashForm, 0x10010002, (IPresentationContext)context);
            this.fViewer.setAutoExpandLevel(ExpressionInformationControlCreator.this.fExpansionLevel);
            if (view != null && (structuredViewer = (StructuredViewer)view.getViewer()) != null) {
                ViewerFilter[] filters = structuredViewer.getFilters();
                i = 0;
                while (i < filters.length) {
                    this.fViewer.addFilter(filters[i]);
                    ++i;
                }
            }
            this.fInputService = new ViewerInputService((ITreeModelViewer)this.fViewer, (IViewerInputRequestor)this);
            this.fTree = this.fViewer.getTree();
            if (ExpressionInformationControlCreator.this.fShowDetailPane) {
                this.fDetailPaneComposite = SWTFactory.createComposite((Composite)this.fSashForm, (int)1, (int)1, (int)1808);
                Layout layout = this.fDetailPaneComposite.getLayout();
                if (layout instanceof GridLayout) {
                    GridLayout gl = (GridLayout)layout;
                    gl.marginHeight = 0;
                    gl.marginWidth = 0;
                }
                this.fDetailPane = new DetailPaneProxy((IDetailPaneContainer)new DetailPaneContainer());
                this.fDetailPane.display(null);
                this.fTree.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ExpressionInformationControl.this.fDetailPane.display((IStructuredSelection)ExpressionInformationControl.this.fViewer.getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            this.initSashWeights();
            this.fViewerUpdateListener = new IViewerUpdateListener(){

                public void viewerUpdatesComplete() {
                    ExpressionInformationControl.this.fViewer.getDisplay().timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            if (!ExpressionInformationControl.this.fViewer.getTree().isDisposed()) {
                                TreeSelection selection = (TreeSelection)ExpressionInformationControl.this.fViewer.getSelection();
                                if (selection.isEmpty()) {
                                    selection = new TreeSelection(ExpressionInformationControl.this.fViewer.getTopElementPath());
                                }
                                ExpressionInformationControl.this.fViewer.setSelection((ISelection)selection);
                                if (ExpressionInformationControl.this.fDetailPane != null) {
                                    ExpressionInformationControl.this.fDetailPane.display((IStructuredSelection)selection);
                                }
                            }
                        }
                    });
                }

                public void viewerUpdatesBegin() {
                }

                public void updateStarted(IViewerUpdate update) {
                }

                public void updateComplete(IViewerUpdate update) {
                }
            };
            this.fViewer.addViewerUpdateListener(this.fViewerUpdateListener);
            this.setForegroundColor(this.getShell().getDisplay().getSystemColor(28));
            this.setBackgroundColor(this.getShell().getDisplay().getSystemColor(29));
        }

        private AbstractDebugView getViewToEmulate() {
            IWorkbenchPage page = DsfUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            AbstractDebugView expressionsView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.ExpressionView");
            if (expressionsView != null && expressionsView.isVisible()) {
                return expressionsView;
            }
            AbstractDebugView variablesView = (AbstractDebugView)page.findView("org.eclipse.debug.ui.VariableView");
            if (variablesView != null && variablesView.isVisible()) {
                return variablesView;
            }
            if (expressionsView != null) {
                return expressionsView;
            }
            return variablesView;
        }

        protected void initSashWeights() {
            int tree;
            IDialogSettings settings = this.getDialogSettings(false);
            if (settings != null && (tree = this.getIntSetting(settings, SASH_WEIGHT_TREE)) > 0) {
                if (this.fDetailPane != null) {
                    int details = this.getIntSetting(settings, SASH_WEIGHT_DETAILS);
                    if (details <= 0) {
                        details = tree / 2;
                    }
                    this.fSashForm.setWeights(new int[]{tree, details});
                } else {
                    this.fSashForm.setWeights(new int[]{tree});
                }
            }
        }

        public void setForegroundColor(Color foreground) {
            super.setForegroundColor(foreground);
            if (this.fDetailPaneComposite != null) {
                this.fDetailPaneComposite.setForeground(foreground);
            }
            this.fTree.setForeground(foreground);
        }

        public void setBackgroundColor(Color background) {
            super.setBackgroundColor(background);
            if (this.fDetailPaneComposite != null) {
                this.fDetailPaneComposite.setBackground(background);
            }
            this.fTree.setBackground(background);
        }

        public void setFocus() {
            super.setFocus();
            this.fTree.setFocus();
        }

        public boolean hasContents() {
            return this.fVariable != null;
        }

        public void setInput(Object input) {
            if (input instanceof IExpressions.IExpressionDMContext) {
                this.fVariable = input;
                this.fInputService.resolveViewerInput(input);
            }
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            if (this.fInformationControlCreator == null) {
                this.fInformationControlCreator = new ExpressionInformationControlCreator(ExpressionInformationControlCreator.this.fShowDetailPane, ExpressionInformationControlCreator.this.fExpansionLevel){

                    @Override
                    public IInformationControl createInformationControl(Shell shell) {
                        return new ExpressionInformationControl(shell, true);
                    }
                };
            }
            return this.fInformationControlCreator;
        }

        public void viewerInputComplete(IViewerInputUpdate update) {
            this.fVariable = update.getInputElement();
            this.fViewer.setInput(this.fVariable);
        }

        private class DetailPaneContainer
        implements IDetailPaneContainer {
            private DetailPaneContainer() {
            }

            public String getCurrentPaneID() {
                return ExpressionInformationControl.this.fDetailPane.getCurrentPaneID();
            }

            public IStructuredSelection getCurrentSelection() {
                return (IStructuredSelection)ExpressionInformationControl.this.fViewer.getSelection();
            }

            public void refreshDetailPaneContents() {
                ExpressionInformationControl.this.fDetailPane.display(this.getCurrentSelection());
            }

            public Composite getParentComposite() {
                return ExpressionInformationControl.this.fDetailPaneComposite;
            }

            public IWorkbenchPartSite getWorkbenchPartSite() {
                return null;
            }

            public void paneChanged(String newPaneID) {
                if (DefaultDetailPane.ID.equals(newPaneID)) {
                    ExpressionInformationControl.this.fDetailPane.getCurrentControl().setBackground(ExpressionInformationControl.this.getShell().getDisplay().getSystemColor(29));
                }
            }
        }
    }
}

