/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.ui.refactoring.changes.CCompositeChange;
import org.eclipse.cdt.internal.ui.refactoring.changes.RenameTranslationUnitChange;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameTypeProcessor;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class CRenameClassProcessor
extends CRenameTypeProcessor {
    private final List<Change> tuRenames = new ArrayList<Change>();

    public CRenameClassProcessor(CRenameProcessor processor, String kind) {
        super(processor, kind);
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange compositeChange;
        Change change = super.createChange(pm);
        if (this.tuRenames.isEmpty()) {
            return change;
        }
        if (change instanceof CompositeChange) {
            compositeChange = (CompositeChange)change;
        } else {
            compositeChange = new CCompositeChange("");
            compositeChange.markAsSynthetic();
            compositeChange.add(change);
        }
        for (Change tuRename : this.tuRenames) {
            compositeChange.add(tuRename);
        }
        return compositeChange;
    }

    @Override
    protected IBinding[] getBindingsToBeRenamed(RefactoringStatus status) {
        this.tuRenames.clear();
        CRefactoringArgument argument = this.getArgument();
        IBinding binding = argument.getBinding();
        ArrayList<IBinding> bindings = new ArrayList<IBinding>();
        if (binding != null) {
            this.recordRename(binding);
            bindings.add(binding);
        }
        if (binding instanceof ICPPClassType) {
            Object[] dtors;
            IScope scope;
            ICPPClassType ctype = (ICPPClassType)binding;
            Object[] ctors = ctype.getConstructors();
            if (ctors != null) {
                ArrayUtil.addAll(bindings, (Object[])ctors);
            }
            if ((scope = ctype.getCompositeScope()) != null && (dtors = scope.find("~" + argument.getName())) != null) {
                ArrayUtil.addAll(bindings, (Object[])dtors);
            }
            this.renameTranslationUnits((ICPPBinding)ctype);
        }
        return bindings.toArray(new IBinding[bindings.size()]);
    }

    private void renameTranslationUnits(ICPPBinding binding) {
        IIndex index = this.getIndex();
        if (index == null) {
            return;
        }
        try {
            IIndexName[] names;
            index.acquireReadLock();
            HashSet<IIndexFileLocation> locations = new HashSet<IIndexFileLocation>();
            IIndexName[] iIndexNameArray = names = index.findNames((IBinding)binding, 2);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName name = iIndexNameArray[n2];
                locations.add(name.getFile().getLocation());
                ++n2;
            }
            if (locations.size() != 1) {
                return;
            }
            IIndexFileLocation location = (IIndexFileLocation)locations.iterator().next();
            String fullPath = location.getFullPath();
            if (fullPath == null) {
                return;
            }
            Path headerPath = new Path(fullPath);
            IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)headerPath);
            if (file == null || file.getType() != 1) {
                return;
            }
            IProject project = this.getProject();
            int headerCapitalization = PreferenceConstants.getPreference("nameStyle.cpp.header.capitalization", project, 0);
            String headerWordDelimiter = PreferenceConstants.getPreference("nameStyle.cpp.header.wordDelimiter", project, "");
            int sourceCapitalization = PreferenceConstants.getPreference("nameStyle.cpp.source.capitalization", project, 0);
            String sourceWordDelimiter = PreferenceConstants.getPreference("nameStyle.cpp.source.wordDelimiter", project, "");
            String headerName = headerPath.lastSegment();
            String className = binding.getName();
            NameComposer nameComposer = NameComposer.createByExample(className, headerName, headerCapitalization, headerWordDelimiter);
            if (nameComposer == null) {
                return;
            }
            try {
                IIndexInclude[] includedBy;
                String newClassName = this.getReplacementText();
                String newHeaderName = nameComposer.compose(newClassName);
                if (!newHeaderName.equals(headerName)) {
                    this.renameTranslationUnit((IFile)file, newHeaderName);
                }
                IIndexInclude[] iIndexIncludeArray = includedBy = index.findIncludedBy(names[0].getFile());
                int n3 = includedBy.length;
                int n4 = 0;
                while (n4 < n3) {
                    IIndexInclude include = iIndexIncludeArray[n4];
                    location = include.getIncludedByLocation();
                    fullPath = location.getFullPath();
                    if (fullPath != null) {
                        String newName;
                        String fileName;
                        Path filePath = new Path(fullPath);
                        file = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)filePath);
                        if (file != null && file.getType() == 1 && (nameComposer = CoreModel.isValidHeaderUnitName((IProject)project, (String)(fileName = filePath.lastSegment())) ? NameComposer.createByExample(className, fileName, headerCapitalization, headerWordDelimiter) : NameComposer.createByExample(className, fileName, sourceCapitalization, sourceWordDelimiter)) != null && !(newName = nameComposer.compose(newClassName)).equals(fileName)) {
                            this.renameTranslationUnit((IFile)file, newName);
                        }
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        finally {
            index.releaseReadLock();
        }
    }

    protected void renameTranslationUnit(IFile file, String newName) {
        ICElement elem = CoreModel.getDefault().create(file);
        if (elem instanceof ITranslationUnit) {
            this.tuRenames.add((Change)new RenameTranslationUnitChange((ITranslationUnit)elem, newName));
            this.getRenameModifications().rename((IResource)file, new RenameArguments(newName, true));
        }
    }

    protected IProject getProject() {
        IFile file = this.getArgument().getSourceFile();
        if (file == null) {
            return null;
        }
        return file.getProject();
    }
}

