/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;

public class Pattern
extends Resource {
    public long handle;
    long surface;

    public Pattern(Device device, Image image) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device.checkCairo();
        image.createSurface();
        this.handle = Cairo.cairo_pattern_create_for_surface(image.surface);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_pattern_set_extend(this.handle, 1);
        this.surface = image.surface;
        this.init();
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        this(device, x1, y1, x2, y2, color1, 255, color2, 255);
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        super(device);
        if (color1 == null) {
            SWT.error(4);
        }
        if (color1.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        this.device.checkCairo();
        this.handle = Cairo.cairo_pattern_create_linear(x1, y1, x2, y2);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        GC.setCairoPatternColor(this.handle, 0, color1, alpha1);
        GC.setCairoPatternColor(this.handle, 1, color2, alpha2);
        Cairo.cairo_pattern_set_extend(this.handle, 1);
        this.init();
    }

    void destroy() {
        Cairo.cairo_pattern_destroy(this.handle);
        this.surface = 0L;
        this.handle = 0L;
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + this.handle + "}";
    }
}

