/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTTypeIdInitializerExpression
extends ASTNode
implements ICASTTypeIdInitializerExpression {
    private IASTTypeId fTypeId;
    private IASTInitializer fInitializer;

    public CASTTypeIdInitializerExpression() {
    }

    public CASTTypeIdInitializerExpression(IASTTypeId t, IASTInitializer i) {
        this.setTypeId(t);
        this.fInitializer = i;
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.fTypeId;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fTypeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.fInitializer;
    }

    @Override
    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        this.fInitializer = initializer;
        if (initializer != null) {
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fTypeId != null && !this.fTypeId.accept(action)) {
            return false;
        }
        if (this.fInitializer != null && !this.fInitializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public final boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public IType getExpressionType() {
        return CVisitor.createType(this.getTypeId().getAbstractDeclarator());
    }

    @Override
    public CASTTypeIdInitializerExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTTypeIdInitializerExpression copy(IASTNode.CopyStyle style) {
        CASTTypeIdInitializerExpression copy = new CASTTypeIdInitializerExpression(this.fTypeId == null ? null : this.fTypeId.copy(style), this.fInitializer == null ? null : this.fInitializer.copy(style));
        return this.copy(copy, style);
    }
}

