/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IStartTracingHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl2;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

public class GdbStartTracingCommand
extends AbstractDebugCommand
implements IStartTracingHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbStartTracingCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        final IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IGDBTraceControl.ITraceTargetDMContext.class);
        if (dmc == null) {
            return;
        }
        Query<Object> startTracingQuery = new Query<Object>(){

            public void execute(final DataRequestMonitor<Object> rm) {
                final IGDBTraceControl traceControl = (IGDBTraceControl)GdbStartTracingCommand.this.fTracker.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    String user = System.getProperty("user.name");
                    if (user != null && !user.isEmpty() && traceControl instanceof IGDBTraceControl2) {
                        ((IGDBTraceControl2)traceControl).setTraceUser(dmc, user, (RequestMonitor)new ImmediateRequestMonitor(){

                            protected void handleCompleted() {
                                traceControl.startTracing(dmc, (RequestMonitor)rm);
                            }
                        });
                    } else {
                        traceControl.startTracing(dmc, rm);
                    }
                } else {
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)startTracingQuery);
            startTracingQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        final IGDBTraceControl.ITraceTargetDMContext dmc = (IGDBTraceControl.ITraceTargetDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IGDBTraceControl.ITraceTargetDMContext.class);
        if (dmc == null) {
            return false;
        }
        Query<Boolean> canStartTracingQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IGDBTraceControl traceControl = (IGDBTraceControl)GdbStartTracingCommand.this.fTracker.getService(IGDBTraceControl.class);
                if (traceControl != null) {
                    traceControl.canStartTracing(dmc, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canStartTracingQuery);
            return (Boolean)canStartTracingQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return false;
    }
}

