/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.eclipse.cdt.dsf.gdb.internal.CoreInfo;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.internal.core.ICoreInfo;

public class CoreList {
    private ICoreInfo[] fCoreList;
    private String fCoreFileName;
    private IGDBHardwareAndOS2.IResourcesInformation fResourcesInfo;
    private static final String PROCESSOR_ID_STR = "processor";
    private static final String PHYSICAL_ID_STR = "physical id";

    public CoreList() {
        this.fCoreFileName = "/proc/cpuinfo";
    }

    public CoreList(String fileName) {
        this.fCoreFileName = fileName;
    }

    public CoreList(IGDBHardwareAndOS2.IResourcesInformation info) {
        this.fResourcesInfo = info;
    }

    public ICoreInfo[] getCoreList() {
        if (this.fCoreList != null) {
            return this.fCoreList;
        }
        if (this.fCoreFileName != null) {
            this.getCoreListFromFile();
        } else if (this.fResourcesInfo != null) {
            this.getCoreListFromResourceInfo();
        }
        return this.fCoreList;
    }

    private void getCoreListFromFile() {
        Vector<CoreInfo> coreInfo;
        block19: {
            File cpuInfo = new File(this.fCoreFileName);
            coreInfo = new Vector<CoreInfo>();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    String processorId = null;
                    String physicalId = null;
                    InputStreamReader r = new InputStreamReader(new FileInputStream(cpuInfo));
                    reader = new BufferedReader(r);
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith(PROCESSOR_ID_STR)) {
                            if (processorId != null) {
                                physicalId = "0";
                                coreInfo.add(new CoreInfo(processorId, physicalId));
                                processorId = null;
                            }
                            processorId = line.split(":")[1].trim();
                            continue;
                        }
                        if (!line.startsWith(PHYSICAL_ID_STR)) continue;
                        assert (physicalId == null);
                        physicalId = line.split(":")[1].trim();
                        coreInfo.add(new CoreInfo(processorId, physicalId));
                        processorId = null;
                        physicalId = null;
                    }
                    if (processorId != null) {
                        coreInfo.add(new CoreInfo(processorId, "0"));
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    reader = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                reader = null;
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            reader = null;
        }
        this.fCoreList = coreInfo.toArray(new ICoreInfo[coreInfo.size()]);
    }

    private void getCoreListFromResourceInfo() {
        Vector<CoreInfo> coreInfo = new Vector<CoreInfo>();
        int processorIdIndex = -1;
        int physicalIdIndex = -1;
        String processorId = null;
        String physicalId = null;
        int column = 0;
        String[] stringArray = this.fResourcesInfo.getColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            if (col.equalsIgnoreCase(PROCESSOR_ID_STR)) {
                processorIdIndex = column;
            } else if (col.equalsIgnoreCase(PHYSICAL_ID_STR)) {
                physicalIdIndex = column;
            }
            ++column;
            ++n2;
        }
        if (processorIdIndex >= 0) {
            stringArray = this.fResourcesInfo.getContent();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                processorId = line[processorIdIndex];
                physicalId = physicalIdIndex >= 0 ? line[physicalIdIndex] : "0";
                coreInfo.add(new CoreInfo(processorId, physicalId));
                processorId = null;
                physicalId = null;
                ++n2;
            }
        }
        this.fCoreList = coreInfo.toArray(new ICoreInfo[coreInfo.size()]);
    }
}

