/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IDsfBreakpointExtension;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

public class GDBBreakpointsManager_7_0
extends MIBreakpointsManager {
    private String fDebugModelId;

    public GDBBreakpointsManager_7_0(DsfSession session, String debugModelId) {
        super(session, debugModelId);
        this.fDebugModelId = debugModelId;
    }

    @Override
    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GDBBreakpointsManager_7_0.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.register(new String[]{GDBBreakpointsManager_7_0.class.getName()}, new Hashtable());
        rm.done();
    }

    @DsfServiceEventHandler
    public void eventDispatched_7_0(IRunControl.IStartedDMEvent e) {
        this.updateContextOnStartEvent(e);
    }

    protected void updateContextOnStartEvent(IRunControl.IStartedDMEvent e) {
        if (e.getDMContext() instanceof IRunControl.IContainerDMContext) {
            IRunControl.IContainerDMContext containerWithPid = (IRunControl.IContainerDMContext)e.getDMContext();
            assert (this.getPlatformToAttributesMaps().keySet().size() == 1);
            for (IBreakpoints.IBreakpointsTargetDMContext oldBpTarget : this.getPlatformToAttributesMaps().keySet()) {
                assert (oldBpTarget instanceof IRunControl.IContainerDMContext);
                assert (!containerWithPid.equals(oldBpTarget));
                IBreakpoints.IBreakpointsTargetDMContext newBpTarget = (IBreakpoints.IBreakpointsTargetDMContext)containerWithPid;
                this.updateBpManagerMaps(newBpTarget, oldBpTarget);
                this.updateTargetFilters(containerWithPid);
            }
        }
    }

    private void updateBpManagerMaps(IBreakpoints.IBreakpointsTargetDMContext newBpTarget, IBreakpoints.IBreakpointsTargetDMContext oldBpTarget) {
        this.getPlatformToAttributesMaps().put(newBpTarget, this.getPlatformToAttributesMaps().remove(oldBpTarget));
        this.getPlatformToBPsMaps().put(newBpTarget, this.getPlatformToBPsMaps().get(oldBpTarget));
        this.getBPToPlatformMaps().put(newBpTarget, this.getBPToPlatformMaps().get(oldBpTarget));
        this.getPlatformToBPThreadsMaps().put(newBpTarget, this.getPlatformToBPThreadsMaps().get(oldBpTarget));
    }

    private void updateTargetFilters(IRunControl.IContainerDMContext newContainer) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.fDebugModelId);
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof ICBreakpoint && this.supportsBreakpoint(breakpoint)) {
                try {
                    IRunControl.IContainerDMContext[] filterContainers;
                    IDsfBreakpointExtension filterExt = this.getFilterExtension((ICBreakpoint)breakpoint);
                    IRunControl.IContainerDMContext[] iContainerDMContextArray = filterContainers = filterExt.getTargetFilters();
                    int n3 = filterContainers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICommandControlService.ICommandControlDMContext controlForNew;
                        IRunControl.IContainerDMContext oldContainer = iContainerDMContextArray[n4];
                        ICommandControlService.ICommandControlDMContext controldForOld = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)oldContainer, ICommandControlService.ICommandControlDMContext.class);
                        if (controldForOld.equals(controlForNew = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)newContainer, ICommandControlService.ICommandControlDMContext.class))) {
                            filterExt.removeTargetFilter(oldContainer);
                            filterExt.setTargetFilter(newContainer);
                        }
                        ++n4;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }
}

