/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.LargePipedInputStream;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.events.MIThreadGroupExitedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIGDBShowExitCodeInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MITargetStreamOutput;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MIInferiorProcess
extends Process
implements IEventListener,
ICommandListener {
    private boolean fStarted;
    private boolean fTerminated;
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private PipedOutputStream fInputStreamPiped;
    private PipedInputStream fErrorStream;
    private PipedOutputStream fErrorStreamPiped;
    private final DsfSession fSession;
    private final IMICommandControl fCommandControl;
    private CommandFactory fCommandFactory;
    private IRunControl.IContainerDMContext fContainerDMContext;
    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private boolean fDisposed = false;
    private int fSuppressTargetOutputCounter = 0;
    @ThreadSafe
    Integer fExitCode = null;

    protected boolean isStarted() {
        return this.fStarted;
    }

    protected IRunControl.IContainerDMContext getContainer() {
        return this.fContainerDMContext;
    }

    protected synchronized boolean isTerminated() {
        return this.fTerminated;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(IRunControl.IContainerDMContext container, OutputStream gdbOutputStream) {
        this(container, gdbOutputStream, null);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(IRunControl.IContainerDMContext container, PTY p) {
        this(container, null, p);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    protected MIInferiorProcess(IRunControl.IContainerDMContext container, final OutputStream gdbOutputStream, PTY pty) {
        this.fSession = DsfSession.getSession((String)container.getSessionId());
        this.fSession.addServiceEventListener((Object)this, null);
        this.fContainerDMContext = container;
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSession.getId());
        this.fCommandControl = (IMICommandControl)tracker.getService(IMICommandControl.class);
        tracker.dispose();
        this.fCommandFactory = this.fCommandControl.getCommandFactory();
        this.fCommandControl.addEventListener(this);
        this.fCommandControl.addCommandListener(this);
        if (pty != null) {
            this.fOutputStream = pty.getOutputStream();
            this.fInputStream = pty.getInputStream();
            this.fInputStreamPiped = null;
        } else {
            this.fOutputStream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    gdbOutputStream.write(b);
                }
            };
            this.fInputStreamPiped = new PipedOutputStream();
            LargePipedInputStream inputStream = null;
            try {
                inputStream = new LargePipedInputStream(this.fInputStreamPiped);
            }
            catch (IOException iOException) {}
            this.fInputStream = inputStream;
        }
        this.fErrorStreamPiped = new PipedOutputStream();
        LargePipedInputStream errorStream = null;
        try {
            errorStream = new LargePipedInputStream(this.fErrorStreamPiped);
        }
        catch (IOException iOException) {}
        this.fErrorStream = errorStream;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void dispose() {
        this.fSession.removeServiceEventListener((Object)this);
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.closeIO();
        this.setTerminated();
        this.fDisposed = true;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.fInputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.fErrorStream;
    }

    /*
     * Unable to fully structure code
     */
    @ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
    public synchronized void waitForSync() throws InterruptedException {
        if (MIInferiorProcess.$assertionsDisabled || !this.fSession.getExecutor().isInExecutorThread()) ** GOTO lbl4
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.wait(100L);
lbl4:
            // 2 sources

            ** while (!this.fTerminated)
        }
lbl5:
        // 1 sources

    }

    @Override
    @ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
    public int waitFor() throws InterruptedException {
        assert (!this.fSession.getExecutor().isInExecutorThread());
        this.waitForSync();
        return this.exitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
    public int exitValue() {
        block13: {
            assert (!this.fSession.getExecutor().isInExecutorThread());
            MIInferiorProcess mIInferiorProcess = this;
            synchronized (mIInferiorProcess) {
                if (this.fExitCode != null) {
                    return this.fExitCode;
                }
            }
            try {
                Query<Integer> exitCodeQuery = new Query<Integer>(){

                    protected void execute(final DataRequestMonitor<Integer> rm) {
                        if (!DsfSession.isSessionActive((String)MIInferiorProcess.this.fSession.getId())) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Debug session already shut down.", null));
                            rm.done();
                            return;
                        }
                        if (MIInferiorProcess.this.isDisposed()) {
                            rm.setData((Object)0);
                            rm.done();
                        } else if (!MIInferiorProcess.this.fTerminated) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Inferior is still running.", (Throwable)new IllegalThreadStateException()));
                            rm.done();
                        } else {
                            MIInferiorProcess.this.fCommandControl.queueCommand(MIInferiorProcess.this.fCommandFactory.createMIGDBShowExitCode(MIInferiorProcess.this.fCommandControl.getContext()), (DataRequestMonitor)new DataRequestMonitor<MIGDBShowExitCodeInfo>((Executor)MIInferiorProcess.this.fSession.getExecutor(), rm){

                                protected void handleSuccess() {
                                    rm.setData((Object)((MIGDBShowExitCodeInfo)this.getData()).getCode());
                                    rm.done();
                                }
                            });
                        }
                    }
                };
                this.fSession.getExecutor().execute((Runnable)exitCodeQuery);
                int exitCode = (Integer)exitCodeQuery.get();
                MIInferiorProcess mIInferiorProcess2 = this;
                synchronized (mIInferiorProcess2) {
                    this.fExitCode = exitCode;
                }
                return exitCode;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof CoreException) || !(((CoreException)e.getCause()).getStatus().getException() instanceof RuntimeException)) break block13;
                throw (RuntimeException)((CoreException)e.getCause()).getStatus().getException();
            }
        }
        return 0;
    }

    @Override
    public void destroy() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    MIInferiorProcess.this.doDestroy();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        this.closeIO();
    }

    private void closeIO() {
        try {
            if (this.fOutputStream != null) {
                this.fOutputStream.close();
            }
            this.fOutputStream = null;
        }
        catch (IOException iOException) {}
        try {
            if (this.fInputStream != null) {
                this.fInputStream.close();
            }
            this.fInputStream = null;
        }
        catch (IOException iOException) {}
        try {
            if (this.fInputStreamPiped != null) {
                this.fInputStreamPiped.close();
            }
            this.fInputStreamPiped = null;
        }
        catch (IOException iOException) {}
        try {
            if (this.fErrorStream != null) {
                this.fErrorStream.close();
            }
            this.fErrorStream = null;
        }
        catch (IOException iOException) {}
        try {
            if (this.fErrorStreamPiped != null) {
                this.fErrorStreamPiped.close();
            }
            this.fErrorStreamPiped = null;
        }
        catch (IOException iOException) {}
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private void doDestroy() {
        if (this.isDisposed() || !this.fSession.isActive() || this.fTerminated) {
            return;
        }
        DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSession.getId());
        IProcesses procService = (IProcesses)tracker.getService(IProcesses.class);
        tracker.dispose();
        if (procService != null) {
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)this.fContainerDMContext, IProcesses.IProcessDMContext.class);
            procService.terminate((IProcesses.IThreadDMContext)procDmc, (RequestMonitor)new ImmediateRequestMonitor());
        } else {
            this.setTerminated();
        }
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private synchronized void setTerminated() {
        if (this.fTerminated) {
            return;
        }
        this.fTerminated = true;
        this.closeIO();
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.fInputStreamPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.fErrorStreamPiped;
    }

    public void eventReceived(Object output) {
        MIOOBRecord[] mIOOBRecordArray = ((MIOutput)output).getMIOOBRecords();
        int n = mIOOBRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIOOBRecord oobr = mIOOBRecordArray[n2];
            if (oobr instanceof MITargetStreamOutput) {
                if (this.fSuppressTargetOutputCounter > 0) {
                    return;
                }
                MITargetStreamOutput tgtOut = (MITargetStreamOutput)oobr;
                if (this.fInputStreamPiped != null && tgtOut.getString() != null) {
                    try {
                        this.fInputStreamPiped.write(tgtOut.getString().getBytes());
                        this.fInputStreamPiped.flush();
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n2;
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
        if (token.getCommand() instanceof CLICommand) {
            ++this.fSuppressTargetOutputCounter;
        }
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        if (token.getCommand() instanceof CLICommand) {
            --this.fSuppressTargetOutputCounter;
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        if (e.getDMContext() instanceof IMIContainerDMContext && ((IRunControl.IExecutionDMContext)e.getDMContext()).equals(this.fContainerDMContext) && this.fStarted) {
            this.setTerminated();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadGroupExitedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        if (e.getDMContext() instanceof IMIContainerDMContext && !this.fStarted) {
            String inferiorGroup = ((IMIContainerDMContext)this.fContainerDMContext).getGroupId();
            if (inferiorGroup == null || inferiorGroup.length() == 0) {
                this.fStarted = true;
                this.fContainerDMContext = (IMIContainerDMContext)e.getDMContext();
            } else {
                String startedGroup = ((IMIContainerDMContext)e.getDMContext()).getGroupId();
                if (inferiorGroup.equals(startedGroup)) {
                    this.fStarted = true;
                    this.fContainerDMContext = (IMIContainerDMContext)e.getDMContext();
                }
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.dispose();
    }
}

