/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.IMILaunchConfigurationComponent;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class SolibSearchPathBlock
extends Observable
implements IMILaunchConfigurationComponent,
IDialogFieldListener {
    private Composite fControl;
    private static String[] fgStaticButtonLabels;
    private IProject fProject;
    private Shell fShell;
    private SolibSearchPathListDialogField fDirList;
    private IListAdapter fCustomListAdapter;
    private File[] fAutoSolibs = new File[0];

    static {
        String[] stringArray = new String[6];
        stringArray[0] = LaunchUIMessages.getString("SolibSearchPathBlock.0");
        stringArray[1] = LaunchUIMessages.getString("SolibSearchPathBlock.1");
        stringArray[2] = LaunchUIMessages.getString("SolibSearchPathBlock.2");
        stringArray[3] = LaunchUIMessages.getString("SolibSearchPathBlock.3");
        stringArray[4] = LaunchUIMessages.getString("SolibSearchPathBlock.6");
        fgStaticButtonLabels = stringArray;
    }

    public SolibSearchPathBlock() {
        this(new String[0], null);
    }

    public SolibSearchPathBlock(String[] customButtonLabels, IListAdapter customListAdapter) {
        this.fCustomListAdapter = customListAdapter;
        int length = fgStaticButtonLabels.length;
        if (customButtonLabels.length > 0) {
            length += customButtonLabels.length;
        }
        String[] buttonLabels = new String[length];
        System.arraycopy(fgStaticButtonLabels, 0, buttonLabels, 0, fgStaticButtonLabels.length);
        if (length > fgStaticButtonLabels.length) {
            int i = fgStaticButtonLabels.length;
            while (i < length) {
                buttonLabels[i] = customButtonLabels[i - fgStaticButtonLabels.length];
                ++i;
            }
        }
        IListAdapter listAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SolibSearchPathBlock.this.buttonPressed(index);
            }

            public void selectionChanged(DialogField field) {
            }
        };
        LabelProvider lp = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPath) {
                    return ((IPath)element).toOSString();
                }
                return super.getText(element);
            }
        };
        this.fDirList = new SolibSearchPathListDialogField(listAdapter, buttonLabels, (ILabelProvider)lp);
        this.fDirList.setLabelText(LaunchUIMessages.getString("SolibSearchPathBlock.4"));
        this.fDirList.setUpButtonIndex(1);
        this.fDirList.setDownButtonIndex(2);
        this.fDirList.setRemoveButtonIndex(3);
        this.fDirList.setDialogFieldListener(this);
    }

    @Override
    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)comp.getLayout()).marginHeight = 0;
        ((GridLayout)comp.getLayout()).marginWidth = 0;
        comp.setFont(parent.getFont());
        PixelConverter converter = new PixelConverter((Control)comp);
        this.fDirList.doFillIntoGrid(comp, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fDirList.getLabelControl(null), (int)2);
        LayoutUtil.setWidthHint((Control)this.fDirList.getLabelControl(null), (int)converter.convertWidthInCharsToPixels(30));
        LayoutUtil.setHorizontalGrabbing((Control)this.fDirList.getListControl(null));
        this.fControl = comp;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        IProject project = null;
        try {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
            if (projectName != null && !(projectName = projectName.trim()).isEmpty()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (CoreException coreException) {}
        this.setProject(project);
        if (this.fDirList != null) {
            try {
                List values = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", Collections.EMPTY_LIST);
                ArrayList<Path> paths = new ArrayList<Path>(values.size());
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    paths.add(new Path((String)it.next()));
                }
                this.fDirList.addElements(paths);
            }
            catch (CoreException coreException) {}
        }
        try {
            this.fAutoSolibs = SolibSearchPathBlock.getAutoSolibs(configuration);
        }
        catch (CoreException coreException) {}
    }

    public static File[] getAutoSolibs(ILaunchConfiguration configuration) throws CoreException {
        List autoSolibs = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB_LIST", Collections.EMPTY_LIST);
        ArrayList<File> list = new ArrayList<File>(autoSolibs.size());
        Iterator it = autoSolibs.iterator();
        while (it.hasNext()) {
            list.add(new File((String)it.next()));
        }
        return list.toArray(new File[list.size()]);
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", Collections.EMPTY_LIST);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fDirList != null) {
            List elements = this.fDirList.getElements();
            ArrayList<String> values = new ArrayList<String>(elements.size());
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                values.add(((IPath)it.next()).toOSString());
            }
            configuration.setAttribute("org.eclipse.cdt.dsf.gdb.SOLIB_PATH", values);
        }
        ArrayList<String> autoLibs = new ArrayList<String>(this.fAutoSolibs.length);
        int i = 0;
        while (i < this.fAutoSolibs.length) {
            autoLibs.add(this.fAutoSolibs[i].getPath());
            ++i;
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.AUTO_SOLIB_LIST", autoLibs);
    }

    protected void buttonPressed(int index) {
        boolean changed = false;
        if (index == 0) {
            changed = this.addDirectory();
        } else if (index == 4) {
            changed = this.selectFromList();
        } else if (index >= fgStaticButtonLabels.length && this.fCustomListAdapter != null) {
            this.fCustomListAdapter.customButtonPressed((DialogField)this.fDirList, index);
            changed = true;
        }
        if (changed) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    protected boolean getButtonState(ISelection sel, int index) {
        if (index == 4) {
            return !sel.isEmpty();
        }
        return true;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    private boolean addDirectory() {
        boolean changed = false;
        AddDirectoryDialog dialog = new AddDirectoryDialog(this.getShell());
        dialog.open();
        IPath result = dialog.getValue();
        if (result != null && !this.contains(result)) {
            this.fDirList.addElement(result);
            changed = true;
        }
        return changed;
    }

    @Override
    public void dispose() {
        this.deleteObservers();
    }

    @Override
    public Control getControl() {
        return this.fControl;
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        return false;
    }

    private boolean contains(IPath path) {
        List list = this.fDirList.getElements();
        for (IPath p : list) {
            if (!p.toFile().equals(path.toFile())) continue;
            return true;
        }
        return false;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    private void setProject(IProject project) {
        this.fProject = project;
    }

    protected boolean selectFromList() {
        boolean changed = false;
        List dirList = this.fDirList.getSelectedElements();
        final HashSet libs = new HashSet(10);
        if (this.generateLibraryList(dirList.toArray(new IPath[dirList.size()]), libs)) {
            ITreeContentProvider cp = new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    return this.getElements(parentElement);
                }

                public Object getParent(Object element) {
                    if (libs.contains(element)) {
                        return libs;
                    }
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof Set) {
                        return ((Set)inputElement).toArray();
                    }
                    return new Object[0];
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            };
            LabelProvider lp = new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof File) {
                        return ((File)element).getName();
                    }
                    return super.getText(element);
                }
            };
            CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, cp);
            dialog.setTitle(LaunchUIMessages.getString("SolibSearchPathBlock.7"));
            dialog.setMessage(LaunchUIMessages.getString("SolibSearchPathBlock.8"));
            dialog.setEmptyListMessage(LaunchUIMessages.getString("SolibSearchPathBlock.9"));
            dialog.setComparator((ViewerComparator)new ViewerSorter());
            dialog.setInput(libs);
            dialog.setInitialElementSelections(Arrays.asList(this.fAutoSolibs));
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                this.fAutoSolibs = Arrays.asList(result).toArray(new File[result.length]);
                changed = true;
            }
        }
        return changed;
    }

    private boolean generateLibraryList(final IPath[] paths, final Set libs) {
        boolean result = true;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                int i = 0;
                while (i < paths.length) {
                    File dir = paths[i].toFile();
                    if (dir.exists() && dir.isDirectory()) {
                        File[] all = dir.listFiles();
                        int j = 0;
                        while (j < all.length) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            monitor.subTask(all[j].getPath());
                            String libName = SolibSearchPathBlock.this.getSharedLibraryName(all[j]);
                            if (libName != null) {
                                libs.add(new File(libName));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        };
        try {
            ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
            context.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            result = false;
        }
        return result;
    }

    protected String getSharedLibraryName(File file) {
        if (!file.isFile()) {
            return null;
        }
        IProject project = this.getProject();
        if (project != null) {
            Path fullPath = new Path(file.getPath());
            try {
                ICConfigExtensionReference[] binaryParsersExt = CCorePlugin.getDefault().getDefaultBinaryParserExtensions(project);
                int i = 0;
                while (i < binaryParsersExt.length) {
                    IBinaryParser parser = CoreModelUtil.getBinaryParser((ICConfigExtensionReference)binaryParsersExt[i]);
                    try {
                        IBinaryParser.IBinaryFile bin = parser.getBinary((IPath)fullPath);
                        if (bin instanceof IBinaryParser.IBinaryShared) {
                            String soname = ((IBinaryParser.IBinaryShared)bin).getSoName();
                            return soname.length() != 0 ? soname : file.getName();
                        }
                    }
                    catch (IOException iOException) {}
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            return null;
        }
        Path path = new Path(file.getPath());
        String name = path.lastSegment();
        String extension = path.getFileExtension();
        if (extension != null && (extension.compareTo("so") == 0 || extension.compareToIgnoreCase("dll") == 0)) {
            return name;
        }
        return name.indexOf(".so.") >= 0 ? name : null;
    }

    protected boolean isSharedLibrary(File file) {
        if (!file.isFile()) {
            return false;
        }
        IProject project = this.getProject();
        if (project != null) {
            Path fullPath = new Path(file.getPath());
            try {
                ICConfigExtensionReference[] binaryParsersExt = CCorePlugin.getDefault().getDefaultBinaryParserExtensions(project);
                int i = 0;
                while (i < binaryParsersExt.length) {
                    IBinaryParser parser = CoreModelUtil.getBinaryParser((ICConfigExtensionReference)binaryParsersExt[i]);
                    try {
                        IBinaryParser.IBinaryFile bin = parser.getBinary((IPath)fullPath);
                        return bin instanceof IBinaryParser.IBinaryShared;
                    }
                    catch (IOException iOException) {
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {}
            return false;
        }
        Path path = new Path(file.getPath());
        String extension = path.getFileExtension();
        if (extension != null && (extension.compareTo("so") == 0 || extension.compareToIgnoreCase("dll") == 0)) {
            return true;
        }
        String name = path.lastSegment();
        return name.indexOf(".so.") >= 0;
    }

    public void dialogFieldChanged(DialogField field) {
        this.setChanged();
        this.notifyObservers();
    }

    class AddDirectoryDialog
    extends Dialog {
        protected Text fText;
        private Button fBrowseButton;
        private IPath fValue;

        public AddDirectoryDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite subComp = ControlFactory.createCompositeEx((Composite)composite, (int)2, (int)768);
            ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            subComp.setLayoutData((Object)data);
            subComp.setFont(parent.getFont());
            this.fText = new Text(subComp, 2052);
            this.fText.setLayoutData((Object)new GridData(768));
            this.fText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddDirectoryDialog.this.updateOKButton();
                }
            });
            this.fBrowseButton = ControlFactory.createPushButton((Composite)subComp, (String)LaunchUIMessages.getString("GDBServerDebuggerPage.7"));
            data = new GridData();
            data.horizontalAlignment = 4;
            this.fBrowseButton.setLayoutData((Object)data);
            this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    DirectoryDialog dialog = new DirectoryDialog(AddDirectoryDialog.this.getShell());
                    dialog.setMessage(LaunchUIMessages.getString("SolibSearchPathBlock.5"));
                    String res = dialog.open();
                    if (res != null) {
                        AddDirectoryDialog.this.fText.setText(res);
                    }
                }
            });
            AddDirectoryDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(LaunchUIMessages.getString("SolibSearchPathBlock.Add_Directory"));
        }

        public IPath getValue() {
            return this.fValue;
        }

        private void setValue(String value) {
            this.fValue = value != null ? new Path(value) : null;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.setValue(this.fText.getText());
            } else {
                this.setValue(null);
            }
            super.buttonPressed(buttonId);
        }

        protected void updateOKButton() {
            Button okButton = this.getButton(0);
            String text = this.fText.getText();
            okButton.setEnabled(this.isValid(text));
        }

        protected boolean isValid(String text) {
            return text.trim().length() > 0;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.updateOKButton();
            return control;
        }
    }

    public class SolibSearchPathListDialogField
    extends ListDialogField {
        public SolibSearchPathListDialogField(IListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected boolean managedButtonPressed(int index) {
            boolean result = super.managedButtonPressed(index);
            if (result) {
                SolibSearchPathBlock.this.buttonPressed(index);
            }
            return result;
        }

        protected boolean getManagedButtonState(ISelection sel, int index) {
            if (index > 3) {
                return SolibSearchPathBlock.this.getButtonState(sel, index);
            }
            return super.getManagedButtonState(sel, index);
        }
    }
}

