/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSignal;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class CSignalManager
implements IAdaptable {
    private CDebugTarget fDebugTarget;
    private ICSignal[] fSignals = null;
    private boolean fIsDisposed = false;

    public CSignalManager(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    public ICSignal[] getSignals() throws DebugException {
        if (!this.isDisposed() && this.fSignals == null) {
            try {
                ICDISignal[] cdiSignals = this.getDebugTarget().getCDITarget().getSignals();
                ArrayList<CSignal> list = new ArrayList<CSignal>(cdiSignals.length);
                int i = 0;
                while (i < cdiSignals.length) {
                    list.add(new CSignal(this.getDebugTarget(), cdiSignals[i]));
                    ++i;
                }
                this.fSignals = list.toArray(new ICSignal[list.size()]);
            }
            catch (CDIException e) {
                this.throwDebugException(e.getMessage(), 5010, e);
            }
        }
        return this.fSignals != null ? this.fSignals : new ICSignal[]{};
    }

    public void dispose() {
        if (this.fSignals != null) {
            int i = 0;
            while (i < this.fSignals.length) {
                ((CSignal)this.fSignals[i]).dispose();
                ++i;
            }
        }
        this.fSignals = null;
        this.fIsDisposed = true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(CSignalManager.class)) {
            return this;
        }
        if (adapter.equals(CDebugTarget.class)) {
            return this.getDebugTarget();
        }
        return null;
    }

    public void signalChanged(ICDISignal cdiSignal) {
        CSignal signal = this.find(cdiSignal);
        if (signal != null) {
            signal.fireChangeEvent(256);
        }
    }

    private CSignal find(ICDISignal cdiSignal) {
        try {
            ICSignal[] signals = this.getSignals();
            int i = 0;
            while (i < signals.length) {
                if (signals[i].getName().equals(cdiSignal.getName())) {
                    return (CSignal)signals[i];
                }
                ++i;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return null;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    protected void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), code, message, exception));
    }

    protected CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }
}

