/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIThreadListIdsInfo
extends MIInfo {
    int[] threadIds;

    public MIThreadListIdsInfo(MIOutput out) {
        super(out);
    }

    public int[] getThreadIds() {
        if (this.threadIds == null) {
            this.parse();
        }
        return this.threadIds;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue val;
                String var = results[i].getVariable();
                if (var.equals("thread-ids") && (val = results[i].getMIValue()) instanceof MITuple) {
                    this.parseThreadIds((MITuple)val);
                }
                ++i;
            }
        }
        if (this.threadIds == null) {
            this.threadIds = new int[0];
        }
    }

    void parseThreadIds(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        this.threadIds = new int[results.length];
        int i = 0;
        while (i < results.length) {
            MIValue value;
            String var = results[i].getVariable();
            if (var.equals("thread-id") && (value = results[i].getMIValue()) instanceof MIConst) {
                String str = ((MIConst)value).getCString();
                try {
                    this.threadIds[i] = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }
}

