/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoHelp;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;

public class ArduinoPackage {
    private String name;
    private String maintainer;
    private String websiteURL;
    private String email;
    private ArduinoHelp help;
    private List<ArduinoPlatform> platforms;
    private List<ArduinoTool> tools;
    private transient ArduinoManager manager;

    void setOwner(ArduinoManager manager) {
        this.manager = manager;
        for (ArduinoPlatform platform : this.platforms) {
            platform.setOwner(this);
        }
        for (ArduinoTool tool : this.tools) {
            tool.setOwner(this);
        }
    }

    ArduinoManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getWebsiteURL() {
        return this.websiteURL;
    }

    public String getEmail() {
        return this.email;
    }

    public ArduinoHelp getHelp() {
        return this.help;
    }

    public Collection<ArduinoPlatform> getPlatforms() {
        return Collections.unmodifiableCollection(this.platforms);
    }

    public Path getInstallPath() {
        return ArduinoPreferences.getArduinoHome().resolve("packages").resolve(this.getName());
    }

    public Map<String, ArduinoPlatform> getAvailablePlatforms() {
        HashMap<String, ArduinoPlatform> platformMap = new HashMap<String, ArduinoPlatform>();
        for (ArduinoPlatform platform : this.platforms) {
            ArduinoPlatform p = (ArduinoPlatform)platformMap.get(platform.getName());
            if (p != null && ArduinoManager.compareVersions(platform.getVersion(), p.getVersion()) <= 0) continue;
            platformMap.put(platform.getName(), platform);
        }
        return platformMap;
    }

    public Map<String, ArduinoPlatform> getInstalledPlatforms() {
        HashMap<String, ArduinoPlatform> platformMap = new HashMap<String, ArduinoPlatform>();
        for (ArduinoPlatform platform : this.platforms) {
            if (!platform.isInstalled()) continue;
            platformMap.put(platform.getName(), platform);
        }
        return platformMap;
    }

    public ArduinoPlatform getPlatform(String name) {
        ArduinoPlatform foundPlatform = null;
        for (ArduinoPlatform platform : this.platforms) {
            if (!platform.getName().equals(name)) continue;
            if (foundPlatform == null) {
                foundPlatform = platform;
                continue;
            }
            if (!platform.isInstalled() || ArduinoManager.compareVersions(platform.getVersion(), foundPlatform.getVersion()) <= 0) continue;
            foundPlatform = platform;
        }
        return foundPlatform;
    }

    public List<ArduinoTool> getTools() {
        return this.tools;
    }

    public ArduinoTool getTool(String toolName, String version) {
        for (ArduinoTool tool : this.tools) {
            if (!tool.getName().equals(toolName) || !tool.getVersion().equals(version)) continue;
            return tool;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArduinoPackage) {
            return ((ArduinoPackage)obj).getName().equals(this.name);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

