/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoConsoleParser;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoConsoleService;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoErrorParser;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.arduino.ui.internal.launch.ArduinoErrorMatchListener;
import org.eclipse.cdt.arduino.ui.internal.launch.ArduinoPatternMatchListener;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ArduinoConsole
implements ArduinoConsoleService,
IResourceChangeListener {
    private static MessageConsole console;
    private static MessageConsoleStream out;
    private static MessageConsoleStream err;
    private IFolder buildDirectory;
    List<ArduinoPatternMatchListener> listeners = new ArrayList<ArduinoPatternMatchListener>();

    public ArduinoConsole() {
        if (console == null) {
            console = new MessageConsole(Messages.ArduinoLaunchConsole_0, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
            out = console.newMessageStream();
            err = console.newMessageStream();
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    out.setColor(display.getSystemColor(2));
                    err.setColor(display.getSystemColor(3));
                }
            });
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 8);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 8: {
                if (event.getBuildKind() == 9) break;
                console.clearConsole();
            }
        }
    }

    public IFolder getBuildDirectory() {
        return this.buildDirectory;
    }

    public void monitor(final Process process, ArduinoConsoleParser[] consoleParsers, IFolder buildDirectory) throws IOException {
        this.buildDirectory = buildDirectory;
        for (ArduinoPatternMatchListener listener : this.listeners) {
            console.removePatternMatchListener((IPatternMatchListener)listener);
        }
        this.listeners.clear();
        if (consoleParsers != null) {
            ArduinoConsoleParser[] arduinoConsoleParserArray = consoleParsers;
            int n = consoleParsers.length;
            int n2 = 0;
            while (n2 < n) {
                ArduinoConsoleParser parser = arduinoConsoleParserArray[n2];
                if (parser instanceof ArduinoErrorParser) {
                    ArduinoErrorMatchListener listener = new ArduinoErrorMatchListener(this, (ArduinoErrorParser)parser);
                    this.listeners.add(listener);
                    console.addPatternMatchListener((IPatternMatchListener)listener);
                }
                ++n2;
            }
        }
        console.activate();
        final Semaphore sema = new Semaphore(-1);
        new Thread(Messages.ArduinoLaunchConsole_2){

            @Override
            public void run() {
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (BufferedReader processOut = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                            String line = processOut.readLine();
                            while (line != null) {
                                out.write(line);
                                out.write(10);
                                line = processOut.readLine();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        sema.release();
                    }
                }
                finally {
                    sema.release();
                }
            }
        }.start();
        new Thread(Messages.ArduinoLaunchConsole_2){

            @Override
            public void run() {
                try {
                    try {
                        Throwable throwable = null;
                        Object var2_4 = null;
                        try (BufferedReader processErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                            String line = processErr.readLine();
                            while (line != null) {
                                err.write(line);
                                out.write(10);
                                line = processErr.readLine();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        sema.release();
                    }
                }
                finally {
                    sema.release();
                }
            }
        }.start();
        try {
            sema.acquire();
            process.waitFor();
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
    }

    public void writeOutput(String msg) throws IOException {
        out.write(msg);
    }

    public void writeError(String msg) throws IOException {
        err.write(msg);
    }
}

