/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ActionsList
extends Composite {
    private Button removeButton;
    private Table table;

    public ActionsList(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        this.table = new Table((Composite)this, 67586);
        GridData gridData = new GridData(784);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 4;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsList.this.updateButtons();
            }
        });
        TableColumn nameTableColumn = new TableColumn(this.table, 0);
        nameTableColumn.setWidth(120);
        nameTableColumn.setText(Messages.getString("ActionsList.0"));
        TableColumn typeTableColumn = new TableColumn(this.table, 0);
        typeTableColumn.setWidth(120);
        typeTableColumn.setText(Messages.getString("ActionsList.1"));
        TableColumn summaryTableColumn = new TableColumn(this.table, 0);
        summaryTableColumn.setWidth(120);
        summaryTableColumn.setText(Messages.getString("ActionsList.2"));
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText(Messages.getString("ActionsList.3"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsList.this.HandleRemoveButton();
            }
        });
        Button upButton = new Button((Composite)this, 0);
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsList.this.HandleUpButton();
            }
        });
        upButton.setLayoutData((Object)new GridData(640));
        upButton.setText(Messages.getString("ActionsList.4"));
        Button downButton = new Button((Composite)this, 0);
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionsList.this.HandleDownButton();
            }
        });
        downButton.setText(Messages.getString("ActionsList.5"));
        this.updateButtons();
    }

    public void addAction(IBreakpointAction action) {
        TableItem[] currentItems = this.table.getItems();
        boolean alreadyInList = false;
        int i = 0;
        while (i < currentItems.length && !alreadyInList) {
            alreadyInList = ((IBreakpointAction)currentItems[i].getData()).equals(action);
            ++i;
        }
        if (!alreadyInList) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, action.getName());
            tableItem.setText(1, action.getTypeName());
            tableItem.setText(2, action.getSummary());
            tableItem.setData((Object)action);
        }
        this.updateButtons();
    }

    public void removeAction(IBreakpointAction action) {
        TableItem[] currentItems = this.table.getItems();
        int i = 0;
        while (i < currentItems.length) {
            if (((IBreakpointAction)currentItems[i].getData()).equals(action)) {
                this.table.remove(i);
                break;
            }
            ++i;
        }
        this.updateButtons();
    }

    public String getActionNames() {
        StringBuffer result = new StringBuffer();
        TableItem[] currentItems = this.table.getItems();
        int i = 0;
        while (i < currentItems.length) {
            if (i > 0) {
                result.append(',');
            }
            result.append(((IBreakpointAction)currentItems[i].getData()).getName());
            ++i;
        }
        return result.toString();
    }

    private void swapItems(TableItem item, TableItem item2) {
        String[] item2Text = new String[]{item2.getText(0), item2.getText(1), item2.getText(2)};
        Object item2Data = item2.getData();
        item2.setText(0, item.getText(0));
        item2.setText(1, item.getText(1));
        item2.setText(2, item.getText(2));
        item2.setData(item.getData());
        item.setText(0, item2Text[0]);
        item.setText(1, item2Text[1]);
        item.setText(2, item2Text[2]);
        item.setData(item2Data);
    }

    protected void HandleUpButton() {
        int[] selection = this.table.getSelectionIndices();
        if (selection.length == 1 && selection[0] > 0) {
            this.swapItems(this.table.getItem(selection[0]), this.table.getItem(selection[0] - 1));
        }
    }

    protected void HandleDownButton() {
        int[] selection = this.table.getSelectionIndices();
        if (selection.length == 1 && selection[0] < this.table.getItemCount() - 1) {
            this.swapItems(this.table.getItem(selection[0]), this.table.getItem(selection[0] + 1));
        }
    }

    protected void HandleRemoveButton() {
        this.table.remove(this.table.getSelectionIndices());
        if (this.table.getItemCount() > 0) {
            this.table.select(this.table.getItemCount() - 1);
        }
        this.updateButtons();
    }

    public void setNames(String actionNames) {
        this.table.removeAll();
        StringTokenizer tok = new StringTokenizer(actionNames, ",");
        while (tok.hasMoreTokens()) {
            String actionName = tok.nextToken();
            IBreakpointAction action = CDebugCorePlugin.getDefault().getBreakpointActionManager().findBreakpointAction(actionName);
            if (action == null) continue;
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, action.getName());
            tableItem.setText(1, action.getTypeName());
            tableItem.setText(2, action.getSummary());
            tableItem.setData((Object)action);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        TableItem[] selectedItems = this.table.getSelection();
        this.removeButton.setEnabled(selectedItems.length > 0);
    }

    void updateAction(IBreakpointAction action) {
        TableItem[] currentItems = this.table.getItems();
        int i = 0;
        while (i < currentItems.length) {
            if (((IBreakpointAction)currentItems[i].getData()).equals(action)) {
                TableItem tableItem = currentItems[i];
                tableItem.setText(0, action.getName());
                tableItem.setText(1, action.getTypeName());
                tableItem.setText(2, action.getSummary());
                break;
            }
            ++i;
        }
        this.updateButtons();
    }
}

