/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;

public class BuildInfoFactory {
    private static final String PREFIX = MakeCorePlugin.getUniqueIdentifier();
    static final String BUILD_COMMAND = String.valueOf(PREFIX) + ".buildCommand";
    static final String BUILD_LOCATION = String.valueOf(PREFIX) + ".buildLocation";
    static final String STOP_ON_ERROR = String.valueOf(PREFIX) + ".stopOnError";
    static final String USE_DEFAULT_BUILD_CMD = String.valueOf(PREFIX) + ".useDefaultBuildCmd";
    static final String BUILD_TARGET_AUTO = String.valueOf(PREFIX) + ".autoBuildTarget";
    static final String BUILD_TARGET_INCREMENTAL = String.valueOf(PREFIX) + ".incrementalBuildTarget";
    static final String BUILD_TARGET_FULL = String.valueOf(PREFIX) + ".fullBuildTarget";
    static final String BUILD_TARGET_CLEAN = String.valueOf(PREFIX) + ".cleanBuildTarget";
    static final String BUILD_FULL_ENABLED = String.valueOf(PREFIX) + ".enableFullBuild";
    static final String BUILD_CLEAN_ENABLED = String.valueOf(PREFIX) + ".enableCleanBuild";
    static final String BUILD_INCREMENTAL_ENABLED = String.valueOf(PREFIX) + ".enabledIncrementalBuild";
    static final String BUILD_AUTO_ENABLED = String.valueOf(PREFIX) + ".enableAutoBuild";
    static final String BUILD_ARGUMENTS = String.valueOf(PREFIX) + ".buildArguments";
    static final String ENVIRONMENT = String.valueOf(PREFIX) + ".environment";
    static final String BUILD_APPEND_ENVIRONMENT = String.valueOf(PREFIX) + ".append_environment";

    public static IMakeBuilderInfo create(Preferences prefs, String builderID, boolean useDefaults) {
        return new BuildInfoPreference(prefs, builderID, useDefaults);
    }

    public static IMakeBuilderInfo create(IProject project, String builderID) throws CoreException {
        return new BuildInfoProject(project, builderID);
    }

    public static IMakeBuilderInfo create(Map<String, String> args, String builderID) {
        return new BuildInfoMap(args, builderID);
    }

    private static abstract class AbstractBuildInfo
    implements IMakeBuilderInfo {
        private AbstractBuildInfo() {
        }

        @Override
        public void setUseDefaultBuildCmd(boolean on) throws CoreException {
            this.putString(USE_DEFAULT_BUILD_CMD, new Boolean(on).toString());
        }

        @Override
        public boolean isDefaultBuildCmd() {
            if (this.getString(USE_DEFAULT_BUILD_CMD) == null) {
                return true;
            }
            return this.getBoolean(USE_DEFAULT_BUILD_CMD);
        }

        @Override
        public String getBuildAttribute(String name, String defaultValue) {
            String value = this.getString(name);
            if (value == null) {
                if (IMakeCommonBuildInfo.BUILD_COMMAND.equals(name)) {
                    value = this.getString(BUILD_COMMAND);
                } else if (IMakeCommonBuildInfo.BUILD_ARGUMENTS.equals(name)) {
                    value = this.getString(BUILD_ARGUMENTS);
                } else if (IMakeCommonBuildInfo.BUILD_LOCATION.equals(name)) {
                    value = this.getString(BUILD_LOCATION);
                } else if (IMakeBuilderInfo.BUILD_TARGET_AUTO.equals(name)) {
                    value = this.getString(BUILD_TARGET_AUTO);
                } else if (IMakeBuilderInfo.BUILD_TARGET_CLEAN.equals(name)) {
                    value = this.getString(BUILD_TARGET_CLEAN);
                } else if (IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL.equals(name)) {
                    value = this.getString(BUILD_TARGET_INCREMENTAL);
                }
            }
            return value != null ? value : (defaultValue != null ? defaultValue : "");
        }

        @Override
        public void setBuildAttribute(String name, String value) throws CoreException {
            this.putString(name, value);
        }

        @Override
        public Map<String, String> getExpandedEnvironment() {
            Map<String, String> env = this.getEnvironment();
            HashMap<String, String> envMap = new HashMap<String, String>(env.entrySet().size());
            boolean win32 = Platform.getOS().equals("win32");
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String value;
                String key = entry.getKey();
                if (win32) {
                    key = key.toUpperCase();
                }
                String translated = value = entry.getValue();
                try {
                    translated = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, false);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                envMap.put(key, translated);
            }
            return envMap;
        }

        @Override
        public void setBuildCommand(IPath location) throws CoreException {
            this.putString(IMakeCommonBuildInfo.BUILD_COMMAND, null);
            this.putString(BUILD_COMMAND, location.toString());
        }

        @Override
        public IPath getBuildCommand() {
            if (this.isDefaultBuildCmd()) {
                String command = this.getBuildParameter("defaultCommand");
                if (command == null) {
                    return new Path("make");
                }
                return new Path(command);
            }
            String result = this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, this.getString(BUILD_COMMAND));
            try {
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return new Path(result);
        }

        protected String getBuildParameter(String name) {
            IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", this.getBuilderID());
            if (extension == null) {
                return null;
            }
            IConfigurationElement[] configs = extension.getConfigurationElements();
            if (configs.length == 0) {
                return null;
            }
            IConfigurationElement[] runElement = configs[0].getChildren("run");
            IConfigurationElement[] paramElement = runElement[0].getChildren("parameter");
            int i = 0;
            while (i < paramElement.length) {
                if (paramElement[i].getAttribute("name").equals(name)) {
                    return paramElement[i].getAttribute("value");
                }
                ++i;
            }
            return null;
        }

        protected abstract String getBuilderID();

        @Override
        public void setBuildLocation(IPath location) throws CoreException {
            this.putString(IMakeCommonBuildInfo.BUILD_LOCATION, null);
            this.putString(BUILD_LOCATION, location.toString());
        }

        @Override
        public IPath getBuildLocation() {
            String result = this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_LOCATION, this.getString(BUILD_LOCATION));
            try {
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return new Path(result);
        }

        @Override
        public String getBuildArguments() {
            String result = this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, this.getString(BUILD_ARGUMENTS));
            if (result == null) {
                return "";
            }
            try {
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public void setBuildArguments(String args) throws CoreException {
            this.putString(IMakeCommonBuildInfo.BUILD_ARGUMENTS, null);
            this.putString(BUILD_ARGUMENTS, args);
        }

        @Override
        public void setStopOnError(boolean enabled) throws CoreException {
            this.putString(STOP_ON_ERROR, new Boolean(enabled).toString());
        }

        @Override
        public boolean isStopOnError() {
            return this.getBoolean(STOP_ON_ERROR);
        }

        @Override
        public void setAutoBuildTarget(String target) throws CoreException {
            this.putString(IMakeBuilderInfo.BUILD_TARGET_AUTO, null);
            this.putString(BUILD_TARGET_AUTO, target);
        }

        @Override
        public String getAutoBuildTarget() {
            String result = this.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_AUTO, this.getString(BUILD_TARGET_AUTO));
            try {
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public void setIncrementalBuildTarget(String target) throws CoreException {
            this.putString(IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL, null);
            this.putString(BUILD_TARGET_INCREMENTAL, target);
        }

        @Override
        public String getIncrementalBuildTarget() {
            String result = this.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL, this.getString(BUILD_TARGET_INCREMENTAL));
            try {
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public void setFullBuildTarget(String target) throws CoreException {
        }

        @Override
        public String getFullBuildTarget() {
            String result = this.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL, this.getString(BUILD_TARGET_INCREMENTAL));
            try {
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public void setCleanBuildTarget(String target) throws CoreException {
            this.putString(IMakeBuilderInfo.BUILD_TARGET_CLEAN, null);
            this.putString(BUILD_TARGET_CLEAN, target);
        }

        @Override
        public String getCleanBuildTarget() {
            String result = this.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_CLEAN, this.getString(BUILD_TARGET_CLEAN));
            try {
                result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return result;
        }

        @Override
        public void setAutoBuildEnable(boolean enabled) throws CoreException {
            this.putString(BUILD_AUTO_ENABLED, new Boolean(enabled).toString());
        }

        @Override
        public boolean isAutoBuildEnable() {
            return this.getBoolean(BUILD_AUTO_ENABLED);
        }

        @Override
        public void setIncrementalBuildEnable(boolean enabled) throws CoreException {
            this.putString(BUILD_INCREMENTAL_ENABLED, new Boolean(enabled).toString());
        }

        @Override
        public boolean isIncrementalBuildEnabled() {
            return this.getBoolean(BUILD_INCREMENTAL_ENABLED);
        }

        @Override
        public void setFullBuildEnable(boolean enabled) throws CoreException {
            this.putString(BUILD_FULL_ENABLED, new Boolean(enabled).toString());
        }

        @Override
        public boolean isFullBuildEnabled() {
            return this.getBoolean(BUILD_FULL_ENABLED);
        }

        @Override
        public void setCleanBuildEnable(boolean enabled) throws CoreException {
            this.putString(BUILD_CLEAN_ENABLED, new Boolean(enabled).toString());
        }

        @Override
        public boolean isCleanBuildEnabled() {
            return this.getBoolean(BUILD_CLEAN_ENABLED);
        }

        @Override
        public String[] getErrorParsers() {
            String parsers = this.getString("org.eclipse.cdt.core.errorOutputParser");
            if (parsers != null && parsers.length() > 0) {
                StringTokenizer tok = new StringTokenizer(parsers, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                return list.toArray(new String[list.size()]);
            }
            return new String[0];
        }

        @Override
        public void setErrorParsers(String[] parsers) throws CoreException {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < parsers.length) {
                buf.append(parsers[i]).append(';');
                ++i;
            }
            this.putString("org.eclipse.cdt.core.errorOutputParser", buf.toString());
        }

        @Override
        public Map<String, String> getEnvironment() {
            return this.decodeMap(this.getString(ENVIRONMENT));
        }

        @Override
        public void setEnvironment(Map<String, String> env) throws CoreException {
            this.putString(ENVIRONMENT, this.encodeMap(env));
        }

        @Override
        public boolean appendEnvironment() {
            if (this.getString(BUILD_APPEND_ENVIRONMENT) != null) {
                return this.getBoolean(BUILD_APPEND_ENVIRONMENT);
            }
            return true;
        }

        @Override
        public void setAppendEnvironment(boolean append) throws CoreException {
            this.putString(BUILD_APPEND_ENVIRONMENT, new Boolean(append).toString());
        }

        public boolean getBoolean(String property) {
            return Boolean.valueOf(this.getString(property));
        }

        protected Map<String, String> decodeMap(String value) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (value != null) {
                StringBuffer envStr = new StringBuffer(value);
                String escapeChars = "|\\";
                char escapeChar = '\\';
                try {
                    while (envStr.length() > 0) {
                        int ndx = 0;
                        while (ndx < envStr.length()) {
                            if (escapeChars.indexOf(envStr.charAt(ndx)) != -1) {
                                if (envStr.charAt(ndx - 1) == escapeChar) {
                                    envStr.deleteCharAt(ndx - 1);
                                    if (ndx == envStr.length()) break;
                                }
                                if (envStr.charAt(ndx) == '|') break;
                            }
                            ++ndx;
                        }
                        StringBuffer line = new StringBuffer(envStr.substring(0, ndx));
                        int lndx = 0;
                        while (lndx < line.length()) {
                            if (line.charAt(lndx) == '=') {
                                if (line.charAt(lndx - 1) != escapeChar) break;
                                line.deleteCharAt(lndx - 1);
                            }
                            ++lndx;
                        }
                        map.put(line.substring(0, lndx), line.substring(lndx + 1));
                        envStr.delete(0, ndx + 1);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return map;
        }

        protected String encodeMap(Map<String, String> values) {
            StringBuffer str = new StringBuffer();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                str.append(this.escapeChars(entry.getKey(), "=|\\", '\\'));
                str.append("=");
                str.append(this.escapeChars(entry.getValue(), "|\\", '\\'));
                str.append("|");
            }
            return str.toString();
        }

        protected String escapeChars(String string, String escapeChars, char escapeChar) {
            StringBuffer str = new StringBuffer(string);
            int i = 0;
            while (i < str.length()) {
                if (escapeChars.indexOf(str.charAt(i)) != -1) {
                    str.insert(i, escapeChar);
                    ++i;
                }
                ++i;
            }
            return str.toString();
        }

        protected abstract void putString(String var1, String var2) throws CoreException;

        protected abstract String getString(String var1);
    }

    private static class BuildInfoMap
    extends AbstractBuildInfo {
        private Map<String, String> args;
        private String builderID;

        BuildInfoMap(Map<String, String> args, String builderID) {
            this.args = args;
            this.builderID = builderID;
        }

        @Override
        protected void putString(String name, String value) {
            if (value == null) {
                this.args.remove(name);
            } else {
                this.args.put(name, value);
            }
        }

        @Override
        protected String getString(String name) {
            return this.args.get(name);
        }

        @Override
        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildInfoPreference
    extends AbstractBuildInfo {
        private Preferences prefs;
        private String builderID;
        private boolean useDefaults;

        BuildInfoPreference(Preferences prefs, String builderID, boolean useDefaults) {
            this.prefs = prefs;
            this.builderID = builderID;
            this.useDefaults = useDefaults;
        }

        @Override
        protected void putString(String name, String value) {
            if (this.useDefaults) {
                if (value != null) {
                    this.prefs.setDefault(name, value);
                }
            } else {
                if (value == null) {
                    this.prefs.setValue(name, this.prefs.getDefaultString(name));
                    return;
                }
                this.prefs.setValue(name, value);
            }
        }

        @Override
        protected String getString(String property) {
            if (!this.prefs.contains(property)) {
                return null;
            }
            if (this.useDefaults) {
                return this.prefs.getDefaultString(property);
            }
            return this.prefs.getString(property);
        }

        @Override
        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildInfoProject
    extends AbstractBuildInfo {
        private IProject project;
        private String builderID;
        private Map<String, String> args;

        BuildInfoProject(IProject project, String builderID) throws CoreException {
            Map builderArgs;
            ICConfigurationDescription cConfigDescription;
            CBuildData buildData;
            this.project = project;
            this.builderID = builderID;
            ICommand builder = null;
            ICProjectDescription cProjectDescription = CoreModel.getDefault().getProjectDescription(project, false);
            if (cProjectDescription != null && (buildData = (cConfigDescription = cProjectDescription.getActiveConfiguration()).getConfigurationData().getBuildData()) != null) {
                builder = buildData.getBuildSpecCommand();
            }
            if (builder == null && (builder = MakeProjectNature.getBuildSpec(project.getDescription(), builderID)) == null) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, String.valueOf(MakeMessages.getString("BuildInfoFactory.Missing_Builder")) + builderID, null));
            }
            this.args = builderArgs = builder.getArguments();
        }

        @Override
        protected void putString(String name, String value) throws CoreException {
            String curValue = this.args.get(name);
            if (curValue != null && curValue.equals(value)) {
                return;
            }
            if (value == null) {
                this.args.remove(name);
            } else {
                this.args.put(name, value);
            }
            IProjectDescription description = this.project.getDescription();
            ICommand builder = MakeProjectNature.getBuildSpec(description, this.builderID);
            builder.setArguments(this.args);
            builder.setBuilding(9, this.isAutoBuildEnable());
            builder.setBuilding(6, this.isFullBuildEnabled());
            builder.setBuilding(10, this.isIncrementalBuildEnabled());
            builder.setBuilding(15, this.isCleanBuildEnabled());
            MakeProjectNature.setBuildSpec(description, builder);
            this.project.setDescription(description, null);
        }

        @Override
        protected String getString(String name) {
            return this.args.get(name);
        }

        @Override
        protected String getBuilderID() {
            return this.builderID;
        }
    }
}

