/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.QtFunctionCallUtil;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.qt.core.index.IQMethod;
import org.eclipse.cdt.qt.core.index.IQObject;
import org.eclipse.cdt.qt.core.index.QtIndex;
import org.eclipse.cdt.qt.ui.QtUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class QObjectConnectCompletion {
    private static final int MACRO_RELEVANCE = 1142;
    private static final int MACRO_PARAM_RELEVANCE = 1121;
    private final Param param;
    private final Data data;

    public QObjectConnectCompletion(Param param) {
        this.param = param;
        this.data = null;
    }

    public QObjectConnectCompletion(String replacement) {
        this.param = Param.Generic;
        this.data = new Data(replacement);
    }

    private static void addProposal(Collection<ICompletionProposal> proposals, ICEditorContentAssistInvocationContext context, Data data, int relevance) {
        if (data == null) {
            return;
        }
        ICompletionProposal proposal = data.createProposal(context, relevance);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    private void addProposals(Collection<ICompletionProposal> proposals, ICEditorContentAssistInvocationContext context) {
        if (this.data != null) {
            QObjectConnectCompletion.addProposal(proposals, context, this.data, 1121);
        } else {
            switch (this.param) {
                case Signal: {
                    QObjectConnectCompletion.addProposal(proposals, context, Data.SIGNAL, 1142);
                    break;
                }
                case Member: {
                    QObjectConnectCompletion.addProposal(proposals, context, Data.SLOT, 1142);
                    QObjectConnectCompletion.addProposal(proposals, context, Data.SIGNAL, 1141);
                    break;
                }
            }
        }
    }

    private static int indexOfClosingPeer(String code, char left, char right, int pos) {
        int level = 0;
        int length = code.length();
        while (pos < length) {
            char ch = code.charAt(pos);
            if (ch == left) {
                ++level;
            } else if (ch == right && --level == 0) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    private static int[] computeCommaPositions(String code) {
        int length = code.length();
        int pos = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(new Integer(-1));
        while (pos < length && pos != -1) {
            char ch = code.charAt(pos);
            switch (ch) {
                case ',': {
                    positions.add(new Integer(pos));
                    break;
                }
                case '(': {
                    pos = QObjectConnectCompletion.indexOfClosingPeer(code, '(', ')', pos);
                    break;
                }
                case '<': {
                    pos = QObjectConnectCompletion.indexOfClosingPeer(code, '<', '>', pos);
                    break;
                }
                case '[': {
                    pos = QObjectConnectCompletion.indexOfClosingPeer(code, '[', ']', pos);
                    break;
                }
            }
            if (pos == -1) continue;
            ++pos;
        }
        positions.add(new Integer(length));
        int[] fields = new int[positions.size()];
        int i = 0;
        while (i < fields.length) {
            fields[i] = (Integer)positions.get(i);
            ++i;
        }
        return fields;
    }

    private static Collection<QObjectConnectCompletion> getCompletionsFor(IType targetType, IASTInitializerClause arg) {
        if (!(targetType instanceof ICPPClassType)) {
            return null;
        }
        ICPPClassType cls = (ICPPClassType)targetType;
        QtIndex qtIndex = QtIndex.getIndex((IProject)ASTUtil.getProject((IASTNode)arg));
        if (qtIndex == null) {
            return null;
        }
        IQObject qobj = null;
        try {
            qobj = qtIndex.findQObject(cls.getQualifiedName());
        }
        catch (DOMException e) {
            CCorePlugin.log((Throwable)e);
        }
        if (qobj == null) {
            return null;
        }
        ArrayList<QObjectConnectCompletion> completions = new ArrayList<QObjectConnectCompletion>();
        String raw = arg.getRawSignature();
        if (raw.startsWith("SIGNAL")) {
            for (IQMethod method : qobj.getSignals().withoutOverrides()) {
                for (String signature : method.getSignatures()) {
                    completions.add(new QObjectConnectCompletion(signature));
                }
            }
        }
        if (raw.startsWith("SLOT")) {
            for (IQMethod method : qobj.getSlots().withoutOverrides()) {
                for (String signature : method.getSignatures()) {
                    completions.add(new QObjectConnectCompletion(signature));
                }
            }
        }
        return completions;
    }

    public static Collection<QObjectConnectCompletion> getConnectProposals(ICEditorContentAssistInvocationContext context, IASTName name, IASTCompletionContext astContext, IASTNode astNode) {
        if (QtFunctionCallUtil.isQObjectFunctionCall((IASTCompletionContext)astContext, (!context.isContextInformationStyle() ? 1 : 0) != 0, (IASTName)name)) {
            int parseOffset = context.getParseOffset();
            int invocationOffset = context.getInvocationOffset();
            String unparsed = "";
            try {
                unparsed = context.getDocument().get(parseOffset, invocationOffset - parseOffset);
            }
            catch (BadLocationException e) {
                CCorePlugin.log((Throwable)e);
            }
            if (unparsed.length() > 0 && unparsed.charAt(0) == '(') {
                unparsed = unparsed.substring(1);
            }
            int[] commas = QObjectConnectCompletion.computeCommaPositions(unparsed);
            switch (commas.length) {
                case 2: 
                case 3: {
                    return Collections.singletonList(new QObjectConnectCompletion(Param.Signal));
                }
                case 4: 
                case 5: {
                    return Collections.singletonList(new QObjectConnectCompletion(Param.Member));
                }
            }
            return null;
        }
        if (astNode.getPropertyInParent() == IASTFunctionCallExpression.ARGUMENT) {
            IASTNode parent = astNode.getParent();
            if (!(parent instanceof IASTFunctionCallExpression)) {
                return null;
            }
            IASTFunctionCallExpression call = (IASTFunctionCallExpression)parent;
            IASTExpression nameExpr = call.getFunctionNameExpression();
            IASTName funcName = null;
            if (nameExpr instanceof IASTIdExpression) {
                funcName = ((IASTIdExpression)nameExpr).getName();
            } else if (nameExpr instanceof ICPPASTFieldReference) {
                funcName = ((ICPPASTFieldReference)nameExpr).getFieldName();
            }
            if (!QtFunctionCallUtil.isQObjectFunctionCall((IASTCompletionContext)astContext, (!context.isContextInformationStyle() ? 1 : 0) != 0, (IASTName)funcName)) {
                return null;
            }
            IASTInitializerClause[] args = call.getArguments();
            if (args == null || args.length < 0) {
                return null;
            }
            int argIndex = args.length - 1;
            IType targetType = QtFunctionCallUtil.getTargetType((IASTFunctionCallExpression)call, (IASTInitializerClause[])args, (int)argIndex);
            if (targetType == null) {
                return null;
            }
            return QObjectConnectCompletion.getCompletionsFor(targetType, args[argIndex]);
        }
        return null;
    }

    public static Collection<ICompletionProposal> getProposals(ICEditorContentAssistInvocationContext context, IASTName name, IASTCompletionContext astContext, IASTNode astNode) {
        Collection<QObjectConnectCompletion> qtProposals = QObjectConnectCompletion.getConnectProposals(context, name, astContext, astNode);
        if (qtProposals == null || qtProposals.isEmpty()) {
            return null;
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (QObjectConnectCompletion qtProposal : qtProposals) {
            qtProposal.addProposals(proposals, context);
        }
        return proposals;
    }

    private static class Data {
        public final String replacement;
        public final String display;
        public final int cursorOffset;
        public static final Data SIGNAL = new Data("SIGNAL()", "SIGNAL(a)", -1);
        public static final Data SLOT = new Data("SLOT()", "SLOT(a)", -1);

        public Data(String replacement) {
            this(replacement, replacement, 0);
        }

        public Data(String replacement, String display, int cursorOffset) {
            this.replacement = replacement;
            this.display = display;
            this.cursorOffset = cursorOffset;
        }

        public ICompletionProposal createProposal(ICEditorContentAssistInvocationContext context, int relevance) {
            int repLength = this.replacement.length();
            int repOffset = context.getInvocationOffset();
            CCompletionProposal p = new CCompletionProposal(this.replacement, repOffset, repLength, QtUIPlugin.getQtLogo(), this.display, relevance, context.getViewer());
            p.setCursorPosition(repLength + this.cursorOffset);
            return p;
        }
    }

    public static enum Param {
        Signal,
        Member,
        Generic;

    }
}

