/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model.type;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerValue;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DerivedValue;

public class ArrayValue
extends DerivedValue
implements ICDIArrayValue,
ICDIPointerValue {
    private String hexAddress;

    public ArrayValue(Variable v) {
        super(v);
    }

    public ArrayValue(Variable v, String address) {
        this(v);
        this.hexAddress = address;
    }

    private String getAddressString() throws CDIException {
        if (this.hexAddress != null) {
            return this.hexAddress;
        }
        String address = this.getVariable().getHexAddress();
        if (address == null) {
            address = "";
        }
        this.hexAddress = address.startsWith("0x") || address.startsWith("0X") ? address.substring(2) : address;
        return this.hexAddress;
    }

    @Override
    public ICDIVariable[] getVariables() throws CDIException {
        int timeout = this.getVariable().getMIVar().getNumChild() * 8 + 5000;
        return this.getVariable().getChildren(timeout);
    }

    public ICDIVariable[] getVariables(int index, int length) throws CDIException {
        Variable variable = this.getVariable();
        if (variable instanceof Register) {
            ICDIVariable[] vars = this.getVariables();
            if (index < vars.length && index + length <= vars.length) {
                ICDIVariable[] newVars = new ICDIVariable[length];
                System.arraycopy(vars, index, newVars, 0, length);
                return newVars;
            }
            return new ICDIVariable[0];
        }
        ICDITarget target = this.getTarget();
        Session session = (Session)target.getSession();
        VariableManager mgr = session.getVariableManager();
        VariableDescriptor vo = mgr.getVariableDescriptorAsArray(variable, index, length);
        return mgr.createVariable(vo).getValue().getVariables();
    }

    public BigInteger pointerValue() throws CDIException {
        String address = this.getAddressString();
        if (address.length() > 0) {
            try {
                return new BigInteger(address, 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

