/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataWriteMemory;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;

public class MemoryBlock
extends CObject
implements ICDIMemoryBlock {
    String expression;
    boolean frozen;
    boolean dirty;
    private MIDataReadMemoryInfo mem;
    private int fWordSize;
    private BigInteger cStartAddress;
    private byte[] cBytes;
    private int[] badOffsets;
    private boolean fIsLittleEndian;

    public MemoryBlock(Target target, String exp, int wordSize, boolean isLittle, MIDataReadMemoryInfo info) {
        super(target);
        this.expression = exp;
        this.fWordSize = wordSize;
        this.frozen = true;
        this.fIsLittleEndian = isLittle;
        this.setMIDataReadMemoryInfo(info);
    }

    public String getExpression() {
        return this.expression;
    }

    public int getWordSize() {
        return this.fWordSize;
    }

    public void setMIDataReadMemoryInfo(MIDataReadMemoryInfo m) {
        this.cStartAddress = MIFormat.getBigInteger(m.getAddress());
        this.cBytes = this.getBytes(m);
        this.mem = m;
    }

    public MIDataReadMemoryInfo getMIDataReadMemoryInfo() {
        return this.mem;
    }

    public boolean contains(BigInteger[] adds) {
        int i = 0;
        while (i < adds.length) {
            if (this.contains(adds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean contains(BigInteger addr) {
        BigInteger start = this.getStartAddress();
        long length = this.getLength();
        return start.compareTo(addr) <= 0 && addr.compareTo(start.add(BigInteger.valueOf(length))) <= 0;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean d) {
        this.dirty = d;
    }

    private byte[] getBytes(MIDataReadMemoryInfo m) {
        byte[] bytes = new byte[]{};
        if (m == null) {
            return bytes;
        }
        MIMemory[] miMem = m.getMemories();
        int i = 0;
        while (i < miMem.length) {
            long[] data = miMem[i].getData();
            if (data != null && data.length > 0) {
                int j = 0;
                while (j < data.length) {
                    byte[] bs = this.longToBytes(data[j]);
                    int blen = bytes.length;
                    byte[] newBytes = new byte[blen + bs.length];
                    System.arraycopy(bytes, 0, newBytes, 0, blen);
                    System.arraycopy(bs, 0, newBytes, blen, bs.length);
                    bytes = newBytes;
                    ++j;
                }
            }
            ++i;
        }
        return bytes;
    }

    private int[] getBadOffsets(MIDataReadMemoryInfo m) {
        int[] offsets = new int[]{};
        if (m == null) {
            return offsets;
        }
        MIMemory[] miMem = m.getMemories();
        int i = 0;
        while (i < miMem.length) {
            int[] data = miMem[i].getBadOffsets();
            if (data.length > 0) {
                int olen = offsets.length;
                int[] newOffsets = new int[olen + data.length];
                System.arraycopy(offsets, 0, newOffsets, 0, olen);
                System.arraycopy(data, 0, newOffsets, olen, data.length);
                offsets = newOffsets;
            }
            ++i;
        }
        return offsets;
    }

    public byte[] getBytes() throws CDIException {
        return this.cBytes;
    }

    public void refresh() throws CDIException {
        Target target = (Target)this.getTarget();
        MemoryManager mgr = ((Session)target.getSession()).getMemoryManager();
        this.setDirty(true);
        BigInteger[] addresses = mgr.update(this, null);
        if (addresses.length > 0) {
            MemoryBlock[] blocks = mgr.getMemoryBlocks(target.getMISession());
            int i = 0;
            while (i < blocks.length) {
                MemoryBlock block = blocks[i];
                if (!block.equals(this) && block.contains(addresses)) {
                    block.setDirty(true);
                    mgr.update(block, null);
                }
                ++i;
            }
        }
    }

    public long getLength() {
        try {
            return this.getBytes().length;
        }
        catch (CDIException cDIException) {
            return this.mem.getTotalBytes();
        }
    }

    public BigInteger getStartAddress() {
        return this.cStartAddress;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(long offset, byte[] bytes) throws CDIException {
        VariableManager varMgr;
        ExpressionManager expMgr;
        if (offset >= this.getLength() || offset + (long)bytes.length > this.getLength()) {
            throw new CDIException(CdiResources.getString("cdi.model.MemoryBlock.Bad_Offset"));
        }
        MISession miSession = ((Target)this.getTarget()).getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        int i = 0;
        while (i < bytes.length) {
            long l = new Byte(bytes[i]).longValue() & 0xFFL;
            String value = "0x" + Long.toHexString(l);
            MIDataWriteMemory mw = factory.createMIDataWriteMemory(offset + (long)i, this.expression, 0, 1, value);
            try {
                miSession.postCommand(mw);
                MIInfo info = mw.getMIInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            ++i;
        }
        this.refresh();
        Target target = (Target)this.getTarget();
        RegisterManager regMgr = ((Session)target.getSession()).getRegisterManager();
        if (regMgr.isAutoUpdate()) {
            regMgr.update(target);
        }
        if ((expMgr = ((Session)target.getSession()).getExpressionManager()).isAutoUpdate()) {
            expMgr.update(target);
        }
        if ((varMgr = ((Session)target.getSession()).getVariableManager()).isAutoUpdate()) {
            varMgr.update(target);
        }
    }

    public synchronized byte getFlags(int offset) {
        if (offset < 0 || (long)offset >= this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.badOffsets == null) {
            this.badOffsets = this.getBadOffsets(this.mem);
        }
        if (this.badOffsets != null) {
            int i = 0;
            while (i < this.badOffsets.length) {
                if (this.badOffsets[i] == offset) {
                    return 0;
                }
                ++i;
            }
        }
        return 2;
    }

    private byte[] longToBytes(long v) {
        int count = 1;
        long value = v;
        count = 1;
        while ((value /= 256L) > 0L) {
            ++count;
        }
        if (this.fWordSize != count) {
            this.fWordSize = count;
        }
        byte[] bytes = new byte[count];
        if (this.fIsLittleEndian) {
            int i = count - 1;
            while (i >= 0) {
                int shift = i * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                --i;
            }
        } else {
            int i = 0;
            while (i < count) {
                int shift = (count - i - 1) * count;
                bytes[i] = (byte)(v >>> shift & 0xFFL);
                ++i;
            }
        }
        return bytes;
    }
}

