/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.commands.RadioState;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.expressions.LegacyActionSetExpression;
import org.eclipse.ui.internal.expressions.LegacyEditorContributionExpression;
import org.eclipse.ui.internal.expressions.LegacySelectionEnablerWrapper;
import org.eclipse.ui.internal.expressions.LegacyViewContributionExpression;
import org.eclipse.ui.internal.handlers.ActionDelegateHandlerProxy;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.services.RegistryPersistence;

public final class LegacyActionPersistence
extends RegistryPersistence {
    private static final int INDEX_ACTION_SETS = 0;
    private static final int INDEX_EDITOR_CONTRIBUTIONS = 1;
    private static final int INDEX_VIEW_CONTRIBUTIONS = 2;
    private final ICommandService commandService;
    private final Collection handlerActivations = new ArrayList();
    private final Collection menuContributions = new ArrayList();
    private final IWorkbenchWindow window;

    public LegacyActionPersistence(IWorkbenchWindow window) {
        this.commandService = (ICommandService)window.getService(ICommandService.class);
        this.window = window;
    }

    private final void clearActivations() {
        IHandlerService service = (IHandlerService)this.window.getService(IHandlerService.class);
        if (service == null) {
            this.handlerActivations.clear();
            return;
        }
        service.deactivateHandlers(this.handlerActivations);
        for (IHandlerActivation activation : this.handlerActivations) {
            IHandler handler = activation.getHandler();
            if (handler == null) continue;
            handler.dispose();
        }
        this.handlerActivations.clear();
    }

    private final void clearImages() {
    }

    private final void clearMenus() {
        this.menuContributions.clear();
    }

    private final ParameterizedCommand convertActionToCommand(IConfigurationElement element, String primaryId, String secondaryId, List warningsToLog) {
        String commandId = LegacyActionPersistence.readOptional(element, "definitionId");
        Command command = null;
        if (commandId != null) {
            command = this.commandService.getCommand(commandId);
        }
        IActionCommandMappingService mappingService = (IActionCommandMappingService)this.window.getService(IActionCommandMappingService.class);
        String label = null;
        if (commandId == null || !command.isDefined()) {
            if (commandId == null && mappingService != null) {
                commandId = mappingService.getGeneratedCommandId(primaryId, secondaryId);
            }
            if (commandId == null) {
                WorkbenchPlugin.log("MappingService unavailable");
                return null;
            }
            label = LegacyActionPersistence.readRequired(element, "label", warningsToLog, "Actions require a non-empty label or definitionId", commandId);
            if (label == null) {
                label = WorkbenchMessages.LegacyActionPersistence_AutogeneratedCommandName;
            }
            String tooltip = LegacyActionPersistence.readOptional(element, "tooltip");
            command = this.commandService.getCommand(commandId);
            Category category = this.commandService.getCategory(null);
            String name = LegacyActionTools.removeAcceleratorText((String)Action.removeMnemonics((String)label));
            command.define(name, tooltip, category, null);
            String style = LegacyActionPersistence.readOptional(element, "style");
            if ("radio".equals(style)) {
                RadioState state = new RadioState();
                boolean checked = LegacyActionPersistence.readBoolean(element, "state", false);
                state.setValue((Object)(checked ? Boolean.TRUE : Boolean.FALSE));
                command.addState("STYLE", (State)state);
            } else if ("toggle".equals(style)) {
                ToggleState state = new ToggleState();
                boolean checked = LegacyActionPersistence.readBoolean(element, "state", false);
                state.setValue((Object)(checked ? Boolean.TRUE : Boolean.FALSE));
                command.addState("STYLE", (State)state);
            }
        }
        if (mappingService != null && commandId != null) {
            mappingService.map(mappingService.getGeneratedCommandId(primaryId, secondaryId), commandId);
        }
        return new ParameterizedCommand(command, null);
    }

    private final void convertActionToHandler(IConfigurationElement element, String actionId, ParameterizedCommand command, Expression activeWhenExpression, String viewId, List warningsToLog) {
        boolean retarget = LegacyActionPersistence.readBoolean(element, "retarget", false);
        boolean classAvailable = element.getAttribute("class") != null || element.getChildren("class").length != 0;
        String classString = LegacyActionPersistence.readOptional(element, "class");
        if (classAvailable && classString == null) {
            classString = LegacyActionPersistence.readOptional(element.getChildren("class")[0], "class");
        }
        if (retarget) {
            IActionCommandMappingService mappingService;
            if (classAvailable && !LegacyActionPersistence.isPulldown(element)) {
                LegacyActionPersistence.addWarning(warningsToLog, "The class was not null but retarget was set to true", element, actionId, "class", classString);
            }
            if ((mappingService = (IActionCommandMappingService)this.window.getService(IActionCommandMappingService.class)) != null) {
                mappingService.map(actionId, command.getId());
            } else {
                LegacyActionPersistence.addWarning(warningsToLog, "Retarget service unavailable", element, actionId);
            }
            return;
        }
        if (!classAvailable) {
            LegacyActionPersistence.addWarning(warningsToLog, "There was no class provided, and the action is not retargettable", element, actionId);
            return;
        }
        SelectionEnabler enabler = null;
        if (element.getAttribute("enablesFor") != null) {
            enabler = new SelectionEnabler(element);
        } else {
            IConfigurationElement[] kids = element.getChildren("enablement");
            if (kids.length > 0) {
                enabler = new SelectionEnabler(element);
            }
        }
        LegacySelectionEnablerWrapper enabledWhenExpression = enabler == null ? null : new LegacySelectionEnablerWrapper(enabler, this.window);
        ActionDelegateHandlerProxy handler = new ActionDelegateHandlerProxy(element, "class", actionId, command, this.window, null, enabledWhenExpression, viewId);
        String helpContextId = LegacyActionPersistence.readOptional(element, "helpContextId");
        if (helpContextId != null) {
            this.commandService.setHelpContextId((IHandler)handler, helpContextId);
        }
        String commandId = command.getId();
        IHandlerService service = (IHandlerService)this.window.getService(IHandlerService.class);
        IHandlerActivation handlerActivation = activeWhenExpression == null ? service.activateHandler(commandId, (IHandler)handler) : service.activateHandler(commandId, (IHandler)handler, activeWhenExpression);
        this.handlerActivations.add(handlerActivation);
    }

    @Override
    public final void dispose() {
        super.dispose();
        this.clear();
    }

    private void clear() {
        this.clearActivations();
        this.clearImages();
        this.clearMenus();
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent event) {
        return event.getExtensionDeltas("org.eclipse.ui", "actionSets").length != 0 || event.getExtensionDeltas("org.eclipse.ui", "editorActions").length != 0 || event.getExtensionDeltas("org.eclipse.ui", "popupMenus").length != 0 || event.getExtensionDeltas("org.eclipse.ui", "viewActions").length != 0;
    }

    @Override
    public final void read() {
        this.clear();
        LegacyActionPersistence.super.read();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int actionSetCount = 0;
        int editorContributionCount = 0;
        int viewContributionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[5][];
        IConfigurationElement[] actionSetsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.actionSets");
        int i = 0;
        while (i < actionSetsExtensionPoint.length) {
            IConfigurationElement element = actionSetsExtensionPoint[i];
            String name = element.getName();
            if ("actionSet".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 0, actionSetCount++);
            }
            ++i;
        }
        IConfigurationElement[] editorActionsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.editorActions");
        int i2 = 0;
        while (i2 < editorActionsExtensionPoint.length) {
            IConfigurationElement element = editorActionsExtensionPoint[i2];
            String name = element.getName();
            if ("editorContribution".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 1, editorContributionCount++);
            }
            ++i2;
        }
        IConfigurationElement[] viewActionsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.viewActions");
        int i3 = 0;
        while (i3 < viewActionsExtensionPoint.length) {
            IConfigurationElement element = viewActionsExtensionPoint[i3];
            String name = element.getName();
            if ("viewContribution".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 2, viewContributionCount++);
            }
            ++i3;
        }
        this.readActionSets(indexedConfigurationElements[0], actionSetCount);
        this.readEditorContributions(indexedConfigurationElements[1], editorContributionCount);
        this.readViewContributions(indexedConfigurationElements[2], viewContributionCount);
    }

    private final void readActions(String primaryId, IConfigurationElement[] elements, List warningsToLog, Expression visibleWhenExpression, String viewId) {
        int i = 0;
        while (i < elements.length) {
            ParameterizedCommand command;
            IConfigurationElement element = elements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Actions require an id");
            if (id != null && (command = this.convertActionToCommand(element, primaryId, id, warningsToLog)) != null) {
                this.convertActionToHandler(element, id, command, visibleWhenExpression, viewId, warningsToLog);
            }
            ++i;
        }
    }

    private final void readActionsAndMenus(IConfigurationElement element, String id, List warningsToLog, Expression visibleWhenExpression, String viewId) {
        IConfigurationElement[] actionElements = element.getChildren("action");
        this.readActions(id, actionElements, warningsToLog, visibleWhenExpression, viewId);
    }

    private final void readActionSets(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String label;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Action sets need an id");
            if (id != null && (label = LegacyActionPersistence.readRequired(element, "label", warningsToLog, "Actions set need a label", id)) != null) {
                LegacyActionSetExpression expression = new LegacyActionSetExpression(id, this.window);
                this.readActionsAndMenus(element, id, warningsToLog, expression, null);
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the action sets from the 'org.eclipse.ui.actionSets' extension point");
    }

    private final void readEditorContributions(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String targetId;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Editor contributions need an id");
            if (id != null && (targetId = LegacyActionPersistence.readRequired(element, "targetID", warningsToLog, "Editor contributions need a target id", id)) != null) {
                LegacyEditorContributionExpression visibleWhenExpression = new LegacyEditorContributionExpression(targetId, this.window);
                this.readActionsAndMenus(element, id, warningsToLog, visibleWhenExpression, null);
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the editor contributions from the 'org.eclipse.ui.editorActions' extension point");
    }

    private final void readViewContributions(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String targetId;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "View contributions need an id");
            if (id != null && (targetId = LegacyActionPersistence.readRequired(element, "targetID", warningsToLog, "View contributions need a target id", id)) != null) {
                LegacyViewContributionExpression visibleWhenExpression = new LegacyViewContributionExpression(targetId, this.window);
                this.readActionsAndMenus(element, id, warningsToLog, visibleWhenExpression, targetId);
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the view contributions from the 'org.eclipse.ui.viewActions' extension point");
    }
}

