/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal;

import java.util.HashMap;
import org.eclipse.cdt.arduino.core.internal.ArduinoProjectNature;
import org.eclipse.cdt.arduino.core.internal.ArduinoTemplateGenerator;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuilder;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArduinoProjectGenerator {
    private final IProject project;
    private IFile sourceFile;

    public ArduinoProjectGenerator(IProject project) {
        this.project = project;
    }

    public void setupArduinoProject(IProgressMonitor monitor) throws CoreException {
        IProjectDescription projDesc = this.project.getDescription();
        String[] oldIds = projDesc.getNatureIds();
        String[] newIds = new String[oldIds.length + 3];
        System.arraycopy(oldIds, 0, newIds, 0, oldIds.length);
        newIds[newIds.length - 3] = "org.eclipse.cdt.core.cnature";
        newIds[newIds.length - 2] = "org.eclipse.cdt.core.ccnature";
        newIds[newIds.length - 1] = ArduinoProjectNature.ID;
        projDesc.setNatureIds(newIds);
        ICommand command = projDesc.newCommand();
        command.setBuilderName(ArduinoBuilder.ID);
        command.setBuilding(9, false);
        projDesc.setBuildSpec(new ICommand[]{command});
        projDesc.setBuildConfigs(new String[]{"uno"});
        this.project.setDescription(projDesc, monitor);
        IBuildConfiguration config = this.project.getBuildConfig("uno");
        ArduinoBuildConfiguration arduinoConfig = (ArduinoBuildConfiguration)config.getAdapter(ArduinoBuildConfiguration.class);
        ArduinoBoard board = ArduinoManager.instance.getBoard("Arduino/Genuino Uno", "Arduino AVR Boards", "arduino");
        arduinoConfig.setBoard(board);
        ArduinoTemplateGenerator templateGen = new ArduinoTemplateGenerator();
        HashMap<String, String> fmModel = new HashMap<String, String>();
        fmModel.put("projectName", this.project.getName());
        IPathEntry[] entries = new IPathEntry[]{CoreModel.newSourceEntry((IPath)this.project.getFullPath())};
        CoreModel.getDefault().create(this.project).setRawPathEntries(entries, monitor);
        this.sourceFile = this.project.getFile(String.valueOf(this.project.getName()) + ".cpp");
        templateGen.generateFile(fmModel, "arduino.cpp", this.sourceFile, monitor);
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }
}

