/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class ArduinoTemplateGenerator
implements TemplateLoader {
    private final Configuration config;
    private Path templateRoot = new Path("/templates");

    public ArduinoTemplateGenerator() throws CoreException {
        this.config = new Configuration(Configuration.VERSION_2_3_22);
        this.config.setTemplateLoader((TemplateLoader)this);
    }

    public void generateFile(Object model, String templateFile, IFile outputFile, IProgressMonitor monitor) throws CoreException {
        try {
            Template template = this.config.getTemplate(templateFile);
            Throwable throwable = null;
            Object var7_9 = null;
            try (StringWriter writer = new StringWriter();){
                template.process(model, (Writer)writer);
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (ByteArrayInputStream in = new ByteArrayInputStream(writer.getBuffer().toString().getBytes(StandardCharsets.UTF_8));){
                    if (outputFile.exists()) {
                        outputFile.setContents((InputStream)in, true, true, monitor);
                    } else {
                        outputFile.create((InputStream)in, true, monitor);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (TemplateException | IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Processing template " + templateFile, e));
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        return FileLocator.find((Bundle)Activator.getContext().getBundle(), (IPath)this.templateRoot.append(name), null);
    }

    public long getLastModified(Object source) {
        try {
            URL url = (URL)source;
            if (url.getProtocol().equals("file")) {
                File file = new File(url.toURI());
                return file.lastModified();
            }
            return 0L;
        }
        catch (URISyntaxException uRISyntaxException) {
            return 0L;
        }
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        URL url = (URL)source;
        return new InputStreamReader(url.openStream());
    }

    public void closeTemplateSource(Object arg0) throws IOException {
    }
}

