/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoHelp;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;

public class ArduinoPackage {
    private String name;
    private String maintainer;
    private String websiteURL;
    private String email;
    private ArduinoHelp help;
    private List<ArduinoPlatform> platforms;
    private List<ArduinoTool> tools;
    private transient ArduinoManager manager;

    void setOwner(ArduinoManager manager) {
        this.manager = manager;
        for (ArduinoPlatform platform : this.platforms) {
            platform.setOwner(this);
        }
        for (ArduinoTool tool : this.tools) {
            tool.setOwner(this);
        }
    }

    ArduinoManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getWebsiteURL() {
        return this.websiteURL;
    }

    public String getEmail() {
        return this.email;
    }

    public ArduinoHelp getHelp() {
        return this.help;
    }

    public Collection<ArduinoPlatform> getPlatforms() {
        return Collections.unmodifiableCollection(this.platforms);
    }

    public Collection<ArduinoPlatform> getLatestPlatforms() {
        HashMap<String, ArduinoPlatform> platformMap = new HashMap<String, ArduinoPlatform>();
        for (ArduinoPlatform platform : this.platforms) {
            ArduinoPlatform p = (ArduinoPlatform)platformMap.get(platform.getName());
            if (p != null && ArduinoPackage.compareVersions(platform.getVersion(), p.getVersion()) <= 0) continue;
            platformMap.put(platform.getName(), platform);
        }
        return Collections.unmodifiableCollection(platformMap.values());
    }

    public Collection<ArduinoPlatform> getInstalledPlatforms() {
        HashMap<String, ArduinoPlatform> platformMap = new HashMap<String, ArduinoPlatform>();
        for (ArduinoPlatform platform : this.platforms) {
            ArduinoPlatform p;
            if (!platform.isInstalled() || (p = (ArduinoPlatform)platformMap.get(platform.getName())) != null && ArduinoPackage.compareVersions(platform.getVersion(), p.getVersion()) <= 0) continue;
            platformMap.put(platform.getName(), platform);
        }
        return Collections.unmodifiableCollection(platformMap.values());
    }

    public static int compareVersions(String version1, String version2) {
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        if (version2 == null) {
            return 1;
        }
        String[] v1 = version1.split("\\.");
        String[] v2 = version2.split("\\.");
        int i = 0;
        while (i < Math.max(v1.length, v2.length)) {
            block11: {
                int vi2;
                int vi1;
                block10: {
                    if (v1.length <= i) {
                        return v2.length < i ? 0 : -1;
                    }
                    if (v2.length <= i) {
                        return 1;
                    }
                    vi1 = Integer.parseInt(v1[i]);
                    vi2 = Integer.parseInt(v2[i]);
                    if (vi1 >= vi2) break block10;
                    return -1;
                }
                try {
                    if (vi1 > vi2) {
                        return 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    int c = v1[i].compareTo(v2[i]);
                    if (c < 0) {
                        return -1;
                    }
                    if (c <= 0) break block11;
                    return 1;
                }
            }
            ++i;
        }
        return 0;
    }

    public ArduinoPlatform getPlatform(String name) {
        ArduinoPlatform foundPlatform = null;
        for (ArduinoPlatform platform : this.platforms) {
            if (!platform.getName().equals(name)) continue;
            if (foundPlatform == null) {
                foundPlatform = platform;
                continue;
            }
            if (!platform.isInstalled() || ArduinoPackage.compareVersions(platform.getVersion(), foundPlatform.getVersion()) <= 0) continue;
            foundPlatform = platform;
        }
        return foundPlatform;
    }

    public List<ArduinoTool> getTools() {
        return this.tools;
    }

    public ArduinoTool getTool(String toolName, String version) {
        for (ArduinoTool tool : this.tools) {
            if (!tool.getName().equals(toolName) || !tool.getVersion().equals(version)) continue;
            return tool;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArduinoPackage) {
            return ((ArduinoPackage)obj).getName().equals(this.name);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

