/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.PackageIndex;

public class LibraryIndex {
    private List<ArduinoLibrary> libraries;
    private Map<String, Set<String>> categories = new HashMap<String, Set<String>>();
    private Map<String, ArduinoLibrary> latestLibs = new HashMap<String, ArduinoLibrary>();

    public void resolve() throws IOException {
        for (PackageIndex index : ArduinoManager.instance.getPackageIndices()) {
            for (ArduinoPackage pkg : index.getPackages()) {
                for (ArduinoPlatform platform : pkg.getPlatforms()) {
                    File[] libraryDirs;
                    if (!platform.isInstalled() || (libraryDirs = platform.getInstallPath().resolve("libraries").toFile().listFiles()) == null) continue;
                    File[] fileArray = libraryDirs;
                    int n = libraryDirs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File libraryDir = fileArray[n2];
                        Path propsPath = libraryDir.toPath().resolve("library.properties");
                        if (propsPath.toFile().exists()) {
                            this.libraries.add(new ArduinoLibrary(propsPath));
                        }
                        ++n2;
                    }
                }
            }
        }
        for (ArduinoLibrary library : this.libraries) {
            Set<String> categoryLibs;
            String name = library.getName();
            String category = library.getCategory();
            if (category == null) {
                category = "Uncategorized";
            }
            if ((categoryLibs = this.categories.get(category)) == null) {
                categoryLibs = new HashSet<String>();
                this.categories.put(category, categoryLibs);
            }
            categoryLibs.add(name);
            ArduinoLibrary current = this.latestLibs.get(name);
            if (current != null) {
                if (ArduinoPackage.compareVersions(library.getVersion(), current.getVersion()) <= 0) continue;
                this.latestLibs.put(name, library);
                continue;
            }
            this.latestLibs.put(name, library);
        }
    }

    public ArduinoLibrary getLibrary(String name) {
        return this.latestLibs.get(name);
    }

    public Collection<String> getCategories() {
        return Collections.unmodifiableCollection(this.categories.keySet());
    }

    public Collection<ArduinoLibrary> getLibraries(String category) {
        Set<String> categoryLibs = this.categories.get(category);
        if (categoryLibs == null) {
            return new ArrayList<ArduinoLibrary>(0);
        }
        ArrayList<ArduinoLibrary> libs = new ArrayList<ArduinoLibrary>(categoryLibs.size());
        for (String name : categoryLibs) {
            libs.add(this.latestLibs.get(name));
        }
        return libs;
    }
}

