/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.eclipse.cdt.examples.dsf.timers.AlarmService;
import org.eclipse.cdt.examples.dsf.timers.ServicesShutdownSequence;
import org.eclipse.cdt.examples.dsf.timers.ServicesStartupSequence;
import org.eclipse.cdt.examples.dsf.timers.TimerService;
import org.eclipse.cdt.examples.dsf.timers.TimersVMAdapter;
import org.eclipse.cdt.examples.dsf.timers.TimersVMProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class TimersView
extends ViewPart {
    public static final String ID_VIEW_TIMERS = "org.eclipse.cdt.examples.dsf.TimersView";
    private TreeModelViewer fViewer;
    private PresentationContext fPresentationContext;
    private DsfExecutor fExecutor;
    private DsfSession fSession;
    private DsfServicesTracker fServices;
    private TimersVMAdapter fTimersVMAdapter;
    private Action fToggleLayoutAction;
    private Action fAddTimerAction;
    private Action fAddTriggerAction;
    private Action fRemoveAction;

    public void createPartControl(Composite parent) {
        block4: {
            this.fPresentationContext = new PresentationContext(ID_VIEW_TIMERS);
            this.fViewer = new TreeModelViewer(parent, 0x10010000, (IPresentationContext)this.fPresentationContext);
            this.fExecutor = new DefaultDsfExecutor();
            this.fSession = DsfSession.startSession((DsfExecutor)this.fExecutor, (String)"Timers(DSF Example)");
            this.fServices = new DsfServicesTracker(DsfExamplesPlugin.getBundleContext(), this.fSession.getId());
            ServicesStartupSequence startupSeq = new ServicesStartupSequence(this.fSession);
            this.fSession.getExecutor().execute((Runnable)((Object)startupSeq));
            try {
                startupSeq.get();
            }
            catch (InterruptedException interruptedException) {
                assert (false);
            }
            catch (ExecutionException executionException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        this.fTimersVMAdapter = new TimersVMAdapter(this.fSession, (IPresentationContext)this.fPresentationContext);
        this.fSession.registerModelAdapter(IElementContentProvider.class, (Object)this.fTimersVMAdapter);
        this.fSession.registerModelAdapter(IModelProxyFactory.class, (Object)this.fTimersVMAdapter);
        this.fSession.registerModelAdapter(IColumnPresentationFactory.class, (Object)this.fTimersVMAdapter);
        IAdaptable viewerInputObject = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter.isInstance((Object)TimersView.this.fTimersVMAdapter)) {
                    return TimersView.this.fTimersVMAdapter;
                }
                return null;
            }

            public String toString() {
                return "Timers View Root";
            }
        };
        this.fViewer.setInput((Object)viewerInputObject);
        this.makeActions();
        this.contributeToActionBars();
    }

    public void dispose() {
        try {
            block7: {
                this.fSession.getExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        TimersView.this.fSession.unregisterModelAdapter(IElementContentProvider.class);
                        TimersView.this.fSession.unregisterModelAdapter(IModelProxyFactory.class);
                        TimersView.this.fSession.unregisterModelAdapter(IColumnPresentationFactory.class);
                    }
                }).get();
                this.fTimersVMAdapter.dispose();
                this.fTimersVMAdapter = null;
                ServicesShutdownSequence shutdownSeq = new ServicesShutdownSequence(this.fSession);
                this.fSession.getExecutor().execute((Runnable)((Object)shutdownSeq));
                try {
                    shutdownSeq.get();
                }
                catch (InterruptedException interruptedException) {
                    assert (false);
                }
                catch (ExecutionException executionException) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
            this.fSession.getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    DsfSession.endSession((DsfSession)TimersView.this.fSession);
                    TimersView.this.fSession = null;
                    TimersView.this.fExecutor.shutdown();
                    TimersView.this.fExecutor = null;
                }
            }).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        super.dispose();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fToggleLayoutAction);
        manager.add((IAction)this.fAddTimerAction);
        manager.add((IAction)this.fAddTriggerAction);
        manager.add((IAction)this.fRemoveAction);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.fToggleLayoutAction = new Action("Toggle Layout", 2){

            public void run() {
                TimersVMProvider.ViewLayout layout = this.isChecked() ? TimersVMProvider.ViewLayout.TRIGGERS_AT_TOP : TimersVMProvider.ViewLayout.TIMERS_AT_TOP;
                IVMProvider provider = TimersView.this.fTimersVMAdapter.getVMProvider((IPresentationContext)TimersView.this.fPresentationContext);
                ((TimersVMProvider)provider).setViewLayout(layout);
            }
        };
        this.fToggleLayoutAction.setToolTipText("Toggle Layout");
        this.fToggleLayoutAction.setImageDescriptor(DsfExamplesPlugin.getDefault().getImageRegistry().getDescriptor("icons/layout.gif"));
        this.fAddTimerAction = new Action("Add New Timer"){

            public void run() {
                TimersView.this.fExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((TimerService)((Object)TimersView.this.fServices.getService(TimerService.class))).startTimer();
                    }
                });
            }
        };
        this.fAddTimerAction.setToolTipText("Add a new timer");
        this.fAddTimerAction.setImageDescriptor(this.getImage("icons/timer.gif"));
        this.fAddTriggerAction = new Action("Add New Trigger"){

            public void run() {
                int tmpTriggerValue;
                block3: {
                    InputDialog inputDialog = new InputDialog(TimersView.this.getSite().getShell(), "New Trigger", "Please enter trigger value", "", new IInputValidator(){

                        public String isValid(String input) {
                            try {
                                int i = Integer.parseInt(input);
                                if (i <= 0) {
                                    return "Please enter a positive integer";
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                return "Please enter a positive integer";
                            }
                            return null;
                        }
                    });
                    if (inputDialog.open() != 0) {
                        return;
                    }
                    tmpTriggerValue = -1;
                    try {
                        tmpTriggerValue = Integer.parseInt(inputDialog.getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
                final int triggerValue = tmpTriggerValue;
                TimersView.this.fExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((AlarmService)((Object)TimersView.this.fServices.getService(AlarmService.class))).createTrigger(triggerValue);
                    }
                });
            }
        };
        this.fAddTriggerAction.setToolTipText("Add a new trigger");
        this.fAddTriggerAction.setImageDescriptor(this.getImage("icons/alarm.gif"));
        this.fRemoveAction = new Action("Remove"){

            public void run() {
                Object selectedElement = ((IStructuredSelection)TimersView.this.fViewer.getSelection()).getFirstElement();
                if (!(selectedElement instanceof IDMVMContext)) {
                    return;
                }
                final IDMContext selectedCtx = ((IDMVMContext)selectedElement).getDMContext();
                if (selectedCtx instanceof TimerService.TimerDMContext) {
                    TimersView.this.fExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ((TimerService)((Object)TimersView.this.fServices.getService(TimerService.class))).killTimer((TimerService.TimerDMContext)selectedCtx);
                        }
                    });
                } else if (selectedCtx instanceof AlarmService.TriggerDMContext) {
                    TimersView.this.fExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ((AlarmService)((Object)TimersView.this.fServices.getService(AlarmService.class))).deleteTrigger((AlarmService.TriggerDMContext)selectedCtx);
                        }
                    });
                }
            }
        };
        this.fRemoveAction.setToolTipText("Remove selected item");
        this.fRemoveAction.setImageDescriptor(this.getImage("icons/remove.gif"));
    }

    private ImageDescriptor getImage(String key) {
        return DsfExamplesPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }
}

