/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.autotools.core.AutotoolsPropertyConstants;
import org.eclipse.cdt.internal.autotools.core.ErrorParser;
import org.eclipse.cdt.internal.autotools.core.ErrorParserManager;
import org.eclipse.cdt.internal.autotools.core.MarkerGenerator;
import org.eclipse.cdt.internal.autotools.core.configure.AutotoolsConfigurationManager;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.core.configure.IConfigureOption;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.ITarget;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IMultiConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.remote.core.RemoteCommandLauncher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteResource;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public class AutotoolsNewMakeGenerator
extends MarkerGenerator {
    public final String CONFIG_STATUS = "config.status";
    public final String MAKEFILE = "Makefile";
    public final String MAKEFILE_CVS = "Makefile.cvs";
    public final String SETTINGS_FILE_NAME = ".cdtconfigure";
    public final String SHELL_COMMAND = "sh";
    public final String AUTOGEN_TOOL_ID = "autogen";
    public final String CONFIGURE_TOOL_ID = "configure";
    public final String GENERATED_TARGET = "org.eclipse.cdt.autotools.core.generated.MakeTarget";
    private static final String MAKE_TARGET_KEY = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".buildtargets";
    private static final String BUILD_TARGET_ELEMENT = "buildTargets";
    private static final String TARGET_ELEMENT = "target";
    private static final String TARGET_ATTR_ID = "targetID";
    private static final String TARGET_ATTR_PATH = "path";
    private static final String TARGET_ATTR_NAME = "name";
    private static final String TARGET_STOP_ON_ERROR = "stopOnError";
    private static final String TARGET_USE_DEFAULT_CMD = "useDefaultCommand";
    private static final String TARGET_ARGUMENTS = "buildArguments";
    private static final String TARGET_COMMAND = "buildCommand";
    private static final String TARGET_RUN_ALL_BUILDERS = "runAllBuilders";
    private static final String TARGET = "buildTarget";
    private static final String DEFAULT_AUTORECONF = "autoreconf";
    private IProject project;
    private IProgressMonitor monitor;
    private IPath buildLocation;
    private String buildDir;
    private String srcDir;
    private String winOSType = "";
    private IConfiguration cfg;
    private ICConfigurationDescription cdesc;
    private IAConfiguration toolsCfg;
    private IBuilder builder;

    public void generateDependencies() throws CoreException {
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        return this.regenerateMakefiles(false);
    }

    private void initializeBuildConfigDirs(IConfiguration c, IAConfiguration a) {
        IBuilder b = c.getBuilder();
        IPath buildDirectory = b.getBuildLocation();
        if (buildDirectory == null || buildDirectory.isEmpty()) {
            buildDirectory = this.getProjectLocation();
        }
        this.buildLocation = buildDirectory;
        this.buildDir = buildDirectory.toString();
        this.srcDir = a.getConfigToolDirectory();
        try {
            String resolved;
            this.srcDir = resolved = ManagedBuildManager.getBuildMacroProvider().resolveValue(this.srcDir, "", null, 3, (Object)c);
        }
        catch (BuildMacroException buildMacroException) {}
    }

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        ICProjectDescription pdesc = CCorePlugin.getDefault().getProjectDescription(project);
        this.cdesc = pdesc.getActiveConfiguration();
        this.cfg = info.getDefaultConfiguration();
        this.builder = this.cfg.getBuilder();
        this.monitor = monitor;
        CUIPlugin.getDefault().getPreferenceStore().getString("dummy");
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public boolean isGeneratedResource(IResource resource) {
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
            this.refresh();
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private boolean createDirectory(String dirName) throws CoreException {
        File f;
        Path path = new Path(dirName);
        boolean rc = true;
        if (dirName.length() == 0 || dirName.equals(".")) {
            path = this.getProjectLocation().append(dirName);
        }
        if (!(f = path.toFile()).exists() && (rc = f.mkdirs())) {
            this.refresh();
        }
        return rc;
    }

    private void refresh() throws CoreException {
        IRemoteResource remRes = (IRemoteResource)this.getProject().getAdapter(IRemoteResource.class);
        if (remRes != null) {
            remRes.refresh((IProgressMonitor)new SubProgressMonitor(this.monitor, -1));
        }
    }

    public String getMakefileName() {
        return "Makefile";
    }

    public MultiStatus reconfigure() throws CoreException {
        return this.regenerateMakefiles(true);
    }

    public MultiStatus regenerateMakefiles(boolean reconfigure) throws CoreException {
        MultiStatus status = null;
        if (this.cfg instanceof IMultiConfiguration) {
            IMultiConfiguration mfcg = (IMultiConfiguration)this.cfg;
            Object[] objs = mfcg.getItems();
            int i = 0;
            while (i < objs.length) {
                IConfiguration icfg = (IConfiguration)objs[i];
                Status rc = this.regenerateMakefiles(icfg, reconfigure);
                if (!rc.isOK()) {
                    if (status == null) {
                        status = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), 4, "", null);
                    }
                    status.add((IStatus)rc);
                }
                ++i;
            }
        } else {
            Status rc = this.regenerateMakefiles(this.cfg, reconfigure);
            if (!rc.isOK()) {
                if (status == null) {
                    status = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), 4, "", null);
                }
                status.add((IStatus)rc);
            }
        }
        if (status == null) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, "", null);
        }
        return status;
    }

    private Status regenerateMakefiles(IConfiguration icfg, boolean reconfigure) throws CoreException {
        MultiStatus status;
        int rc = 0;
        String errMsg = new String();
        boolean needFullConfigure = false;
        this.checkCancel();
        AutotoolsConfigurationManager.getInstance().syncConfigurations(this.getProject());
        this.toolsCfg = AutotoolsConfigurationManager.getInstance().getConfiguration(this.getProject(), icfg.getId());
        this.initializeBuildConfigDirs(icfg, this.toolsCfg);
        if (!this.createDirectory(this.buildDir)) {
            rc = 4;
            errMsg = AutotoolsPlugin.getFormattedString("MakeGenerator.createdir.error", new String[]{this.buildDir});
            MultiStatus multiStatus = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), rc, errMsg, null);
        }
        this.checkCancel();
        IConsole console = CCorePlugin.getDefault().getConsole("org.eclipse.cdt.autotools.ui.configureConsole");
        boolean consoleStart = true;
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        try {
            try {
                IPath configfile = this.buildLocation.append("config.status");
                IPath topConfigFile = this.getProjectLocation().append("config.status");
                IPath makefilePath = this.buildLocation.append("Makefile");
                IPath topMakefilePath = this.getProjectLocation().append("Makefile");
                File configStatus = configfile.toFile();
                File topConfigStatus = topConfigFile.toFile();
                File makefile = makefilePath.toFile();
                File topMakefile = topMakefilePath.toFile();
                if (!configfile.equals((Object)topConfigFile) && topConfigStatus.exists() && topMakefile != null && topMakefile.exists()) {
                    String args;
                    String[] makeargs = new String[1];
                    IPath makeCmd = this.builder.getBuildCommand();
                    String target = null;
                    try {
                        target = this.getProject().getPersistentProperty(AutotoolsPropertyConstants.CLEAN_MAKE_TARGET);
                    }
                    catch (CoreException coreException) {}
                    if (target == null) {
                        target = "distclean";
                    }
                    if ((args = this.builder.getBuildArguments()) != null && !(args = args.trim()).equals("")) {
                        String[] newArgs = this.makeArray(args);
                        makeargs = new String[newArgs.length + 1];
                        System.arraycopy(newArgs, 0, makeargs, 0, newArgs.length);
                    }
                    makeargs[makeargs.length - 1] = target;
                    rc = this.runCommand(makeCmd, this.getProjectLocation(), makeargs, AutotoolsPlugin.getResourceString("MakeGenerator.clean.topdir"), errMsg, console, consoleStart);
                    consoleStart = false;
                }
                if (this.toolsCfg.isDirty() || reconfigure) {
                    needFullConfigure = true;
                    if (this.buildLocation != null && this.buildLocation.toFile().exists()) {
                        String cleanDelete = null;
                        try {
                            cleanDelete = this.getProject().getPersistentProperty(AutotoolsPropertyConstants.CLEAN_DELETE);
                        }
                        catch (CoreException coreException) {}
                        if (cleanDelete != null && cleanDelete.equals("true")) {
                            this.buildLocation.toFile().delete();
                        } else if (makefile != null && makefile.exists()) {
                            String args;
                            String[] makeargs = new String[1];
                            IPath makeCmd = this.builder.getBuildCommand();
                            String target = null;
                            try {
                                target = this.getProject().getPersistentProperty(AutotoolsPropertyConstants.CLEAN_MAKE_TARGET);
                            }
                            catch (CoreException coreException) {}
                            if (target == null) {
                                target = "distclean";
                            }
                            if ((args = this.builder.getBuildArguments()) != null && !(args = args.trim()).equals("")) {
                                String[] newArgs = this.makeArray(args);
                                makeargs = new String[newArgs.length + 1];
                                System.arraycopy(newArgs, 0, makeargs, 0, newArgs.length);
                            }
                            makeargs[makeargs.length - 1] = target;
                            rc = this.runCommand(makeCmd, this.buildLocation, makeargs, AutotoolsPlugin.getFormattedString("MakeGenerator.clean.builddir", new String[]{this.buildDir}), errMsg, console, consoleStart);
                            consoleStart = false;
                        }
                    }
                    try {
                        this.project.setSessionProperty(AutotoolsPropertyConstants.SCANNER_INFO_DIRTY, (Object)Boolean.TRUE);
                    }
                    catch (CoreException coreException) {}
                }
                ArrayList<String> configureEnvs = new ArrayList<String>();
                ArrayList<String> configureCmdParms = new ArrayList<String>();
                IPath configurePath = this.getConfigurePath(configureEnvs, configureCmdParms);
                String[] configArgs = this.getConfigArgs(configureCmdParms);
                ArrayList<String> autogenEnvs = new ArrayList<String>();
                ArrayList<String> autogenCmdParms = new ArrayList<String>();
                IPath autogenPath = this.getAutogenPath(autogenEnvs, autogenCmdParms);
                if (!needFullConfigure && configStatus != null && configStatus.exists()) {
                    if (makefile == null || !makefile.exists()) {
                        rc = this.runScript(configfile, this.buildLocation, null, AutotoolsPlugin.getFormattedString("MakeGenerator.run.config.status", new String[]{this.buildDir}), errMsg, console, null, consoleStart);
                        consoleStart = false;
                    }
                } else if (configurePath.toFile().exists()) {
                    rc = this.runScript(configurePath, this.buildLocation, configArgs, AutotoolsPlugin.getFormattedString("MakeGenerator.gen.makefile", new String[]{this.buildDir}), errMsg, console, configureEnvs, consoleStart);
                    consoleStart = false;
                    if (rc != 4) {
                        File makefileFile = this.buildLocation.append("Makefile").toFile();
                        this.addMakeTargetsToManager(makefileFile);
                        this.toolsCfg.setDirty(false);
                    }
                } else if (autogenPath.toFile().exists()) {
                    if (configStatus.exists()) {
                        configStatus.delete();
                    }
                    String[] autogenArgs = this.getAutogenArgs(autogenCmdParms);
                    rc = this.runScript(autogenPath, autogenPath.removeLastSegments(1), autogenArgs, AutotoolsPlugin.getFormattedString("MakeGenerator.autogen.sh", new String[]{this.buildDir}), errMsg, console, autogenEnvs, consoleStart);
                    consoleStart = false;
                    if (rc != 4) {
                        this.refresh();
                        configStatus = configfile.toFile();
                        if (configStatus == null || !configStatus.exists()) {
                            if (!configurePath.toFile().exists()) {
                                String[] reconfArgs = new String[1];
                                String reconfCmd = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTORECONF_TOOL);
                                if (reconfCmd == null) {
                                    reconfCmd = DEFAULT_AUTORECONF;
                                }
                                Path reconfCmdPath = new Path(reconfCmd);
                                reconfArgs[0] = "-i";
                                rc = this.runScript((IPath)reconfCmdPath, this.getSourcePath(), reconfArgs, AutotoolsPlugin.getFormattedString("MakeGenerator.autoreconf", new String[]{this.buildDir}), errMsg, console, null, consoleStart);
                                consoleStart = false;
                                this.refresh();
                            }
                            if (rc != 4 && configurePath.toFile().exists() && (rc = this.runScript(configurePath, this.buildLocation, configArgs, AutotoolsPlugin.getFormattedString("MakeGenerator.gen.makefile", new String[]{this.buildDir}), errMsg, console, configureEnvs, false)) != 4) {
                                File makefileFile = this.buildLocation.append("Makefile").toFile();
                                this.addMakeTargetsToManager(makefileFile);
                                this.toolsCfg.setDirty(false);
                            }
                        } else {
                            File makefileFile = this.buildLocation.append("Makefile").toFile();
                            this.addMakeTargetsToManager(makefileFile);
                            this.toolsCfg.setDirty(false);
                        }
                    }
                } else if (this.makefileCvsExists()) {
                    String[] makeargs = new String[1];
                    IPath makeCmd = this.builder.getBuildCommand();
                    makeargs[0] = "-f" + this.getMakefileCVSPath().toOSString();
                    rc = this.runCommand(makeCmd, this.getProjectLocation().append(this.buildDir), makeargs, AutotoolsPlugin.getFormattedString("MakeGenerator.makefile.cvs", new String[]{this.buildDir}), errMsg, console, consoleStart);
                    consoleStart = false;
                    if (rc != 4) {
                        File makefileFile = this.getProjectLocation().append(this.buildDir).append("Makefile").toFile();
                        this.addMakeTargetsToManager(makefileFile);
                        this.toolsCfg.setDirty(false);
                    }
                } else {
                    String[] reconfArgs = new String[1];
                    String reconfCmd = this.project.getPersistentProperty(AutotoolsPropertyConstants.AUTORECONF_TOOL);
                    if (reconfCmd == null) {
                        reconfCmd = DEFAULT_AUTORECONF;
                    }
                    Path reconfCmdPath = new Path(reconfCmd);
                    reconfArgs[0] = "-i";
                    rc = this.runScript((IPath)reconfCmdPath, this.getSourcePath(), reconfArgs, AutotoolsPlugin.getFormattedString("MakeGenerator.autoreconf", new String[]{this.buildDir}), errMsg, console, null, consoleStart);
                    consoleStart = false;
                    if (rc != 4) {
                        this.refresh();
                        if (configurePath.toFile().exists() && (rc = this.runScript(configurePath, this.buildLocation, configArgs, AutotoolsPlugin.getFormattedString("MakeGenerator.gen.makefile", new String[]{this.buildDir}), errMsg, console, configureEnvs, false)) != 4) {
                            File makefileFile = this.buildLocation.append("Makefile").toFile();
                            this.addMakeTargetsToManager(makefileFile);
                            this.toolsCfg.setDirty(false);
                        }
                    }
                }
                if (makefile == null || !makefile.exists()) {
                    rc = 4;
                    errMsg = AutotoolsPlugin.getResourceString("MakeGenerator.didnt.generate");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                rc = 4;
                status = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), rc, errMsg, null);
                if (rc != 0) {
                    status.add((IStatus)new Status(rc, AutotoolsPlugin.getUniqueIdentifier(), 0, errMsg, null));
                }
            }
        }
        finally {
            status = new MultiStatus(AutotoolsPlugin.getUniqueIdentifier(), rc, errMsg, null);
            if (rc != 0) {
                status.add((IStatus)new Status(rc, AutotoolsPlugin.getUniqueIdentifier(), 0, errMsg, null));
            }
        }
        return status;
    }

    public static String stripEnvVars(String command, ArrayList<String> envVars) {
        Pattern p1 = Pattern.compile("(\\w+[=]\\\".*?\\\"\\s+)\\w+.*");
        Pattern p2 = Pattern.compile("(\\w+[=]'.*?'\\s+)\\w+.*");
        Pattern p3 = Pattern.compile("(\\w+[=][^\\s]+\\s+)\\w+.*");
        Pattern p4 = Pattern.compile("\\w+\\s+(\\w+[=]\\\".*?\\\"\\s*)+.*");
        Pattern p5 = Pattern.compile("\\w+\\s+(\\w+[=]'.*?'\\s*)+.*");
        Pattern p6 = Pattern.compile("\\w+\\s+(\\w+[=][^\\s]+).*");
        boolean finished = false;
        while (!finished) {
            Matcher m1 = p1.matcher(command);
            if (m1.matches()) {
                command = command.replaceFirst("\\w+[=]\\\".*?\\\"", "").trim();
                String s = m1.group(1).trim();
                envVars.add(s.replaceAll("\\\"", ""));
                continue;
            }
            Matcher m2 = p2.matcher(command);
            if (m2.matches()) {
                command = command.replaceFirst("\\w+[=]'.*?'", "").trim();
                String s = m2.group(1).trim();
                envVars.add(s.replaceAll("'", ""));
                continue;
            }
            Matcher m3 = p3.matcher(command);
            if (m3.matches()) {
                command = command.replaceFirst("\\w+[=][^\\s]+", "").trim();
                envVars.add(m3.group(1).trim());
                continue;
            }
            Matcher m4 = p4.matcher(command);
            if (m4.matches()) {
                command = command.replaceFirst("\\w+[=]\\\".*?\\\"", "").trim();
                String s = m4.group(1).trim();
                envVars.add(s.replaceAll("\\\"", ""));
                continue;
            }
            Matcher m5 = p5.matcher(command);
            if (m5.matches()) {
                command = command.replaceFirst("\\w+[=]'.*?'", "").trim();
                String s = m5.group(1).trim();
                envVars.add(s.replaceAll("'", ""));
                continue;
            }
            Matcher m6 = p6.matcher(command);
            if (m6.matches()) {
                command = command.replaceFirst("\\w+[=][^\\s+]+", "").trim();
                envVars.add(m6.group(1).trim());
                continue;
            }
            finished = true;
        }
        return command;
    }

    public static String stripEnvVarsFromOption(String str, ArrayList<String> envVars) {
        Pattern p1 = Pattern.compile("(\\w+[=]\\\".*?\\\"\\s*).*");
        Pattern p2 = Pattern.compile("(\\w+[=]'.*?'\\s*).*");
        Pattern p3 = Pattern.compile("(\\w+[=][^\\s]+).*");
        boolean finished = false;
        while (!finished) {
            Matcher m1 = p1.matcher(str);
            if (m1.matches()) {
                str = str.replaceFirst("\\w+[=]\\\".*?\\\"", "").trim();
                String s = m1.group(1).trim();
                envVars.add(s.replaceAll("\\\"", ""));
                continue;
            }
            Matcher m2 = p2.matcher(str);
            if (m2.matches()) {
                str = str.replaceFirst("\\w+[=]'.*?'", "").trim();
                String s = m2.group(1).trim();
                envVars.add(s.replaceAll("'", ""));
                continue;
            }
            Matcher m3 = p3.matcher(str);
            if (m3.matches()) {
                str = str.replaceFirst("\\w+[=][^\\s]+", "").trim();
                envVars.add(m3.group(1).trim());
                continue;
            }
            finished = true;
        }
        return str;
    }

    private IPath getProjectLocation() {
        return this.project.getLocation();
    }

    private IPath getBuildPath() {
        return new Path(this.buildDir);
    }

    private IPath getSourcePath() {
        IResource sourceResource;
        IPath sourcePath = this.srcDir.equals("") ? this.getProjectLocation() : ((sourceResource = this.project.findMember(this.srcDir)).exists() && sourceResource.getType() == 2 ? sourceResource.getLocation() : this.getProjectLocation().append(this.srcDir));
        return sourcePath;
    }

    protected IPath getConfigurePath(ArrayList<String> envVars, ArrayList<String> cmdParms) {
        String[] tokens;
        IConfigureOption configOption = this.toolsCfg.getOption("configure");
        String command = "configure";
        if (configOption != null) {
            command = AutotoolsNewMakeGenerator.stripEnvVars(configOption.getValue().trim(), envVars);
        }
        if ((tokens = command.split("\\s")).length > 1) {
            command = tokens[0];
            int i = 1;
            while (i < tokens.length) {
                cmdParms.add(tokens[i]);
                ++i;
            }
        }
        Object configPath = Path.fromOSString((String)command).isAbsolute() ? new Path(command) : this.getSourcePath().append(command);
        return configPath;
    }

    protected IPath getMakefileCVSPath() {
        IPath makefileCVSPath = this.getSourcePath().append("Makefile.cvs");
        return makefileCVSPath;
    }

    protected boolean makefileCvsExists() {
        IPath makefileCVSPath = this.getMakefileCVSPath();
        return makefileCVSPath.toFile().exists();
    }

    protected IPath getAutogenPath(ArrayList<String> envVars, ArrayList<String> cmdParms) {
        String[] tokens;
        IConfigureOption autogenOption = this.toolsCfg.getOption("autogen");
        String command = "autogen.sh";
        if (autogenOption != null) {
            command = AutotoolsNewMakeGenerator.stripEnvVars(autogenOption.getValue().trim(), envVars);
        }
        if ((tokens = command.split("\\s")).length > 1) {
            command = tokens[0];
            int i = 1;
            while (i < tokens.length) {
                cmdParms.add(tokens[i]);
                ++i;
            }
        }
        IPath autogenPath = this.getSourcePath().append(command);
        return autogenPath;
    }

    private String[] getAutogenArgs(ArrayList<String> cmdParms) {
        ArrayList<String> autogenArgs = this.toolsCfg.getToolArgs("autogen");
        cmdParms.addAll(autogenArgs);
        return cmdParms.toArray(new String[cmdParms.size()]);
    }

    private String[] getConfigArgs(ArrayList<String> cmdParms) {
        ArrayList<String> configArgs = this.toolsCfg.getToolArgs("configure");
        cmdParms.addAll(configArgs);
        return cmdParms.toArray(new String[cmdParms.size()]);
    }

    private int runCommand(IPath commandPath, IPath runPath, String[] args, String jobDescription, String errMsg, IConsole console, boolean consoleStart) throws BuildException, CoreException, NullPointerException, IOException {
        int rc = 0;
        this.removeAllMarkers(this.project);
        String[] configTargets = args;
        if (args == null) {
            configTargets = new String[]{};
        }
        int i = 0;
        while (i < configTargets.length) {
            try {
                String resolved;
                configTargets[i] = resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(configTargets[i], "", " ", 3, (Object)this.cfg);
            }
            catch (BuildMacroException buildMacroException) {}
            ++i;
        }
        String[] msgs = new String[]{commandPath.toString(), this.project.getName()};
        this.monitor.subTask(AutotoolsPlugin.getFormattedString("MakeGenerator.make.message", msgs));
        ConsoleOutputStream consoleOutStream = null;
        ErrorParserManager epm = null;
        StringBuffer buf = new StringBuffer();
        if (consoleStart) {
            console.start(this.project);
        }
        try {
            OutputStream stdout;
            consoleOutStream = console.getOutputStream();
            String[] consoleHeader = new String[]{jobDescription, this.toolsCfg.getId(), this.project.getName()};
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(jobDescription);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(System.getProperty("line.separator", "\n"));
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            RemoteCommandLauncher launcher = new RemoteCommandLauncher();
            launcher.setProject(this.project);
            IEnvironmentVariable[] variables = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(this.cdesc, true);
            String[] env = null;
            ArrayList<String> envList = new ArrayList<String>();
            if (variables != null) {
                int i2 = 0;
                while (i2 < variables.length) {
                    envList.add(String.valueOf(variables[i2].getName()) + "=" + variables[i2].getValue());
                    ++i2;
                }
                env = envList.toArray(new String[envList.size()]);
            }
            URI uri = URIUtil.toURI((IPath)runPath);
            epm = new ErrorParserManager(this.project, uri, this, new String[]{"org.eclipse.cdt.autotools.core.errorParser"});
            epm.setOutputStream((OutputStream)consoleOutStream);
            epm.addErrorParser("org.eclipse.cdt.autotools.core.errorParser", new ErrorParser(this.getSourcePath(), this.getBuildPath()));
            OutputStream stderr = stdout = epm.getOutputStream();
            launcher.showCommand(true);
            Process proc = launcher.execute(commandPath, configTargets, env, runPath, (IProgressMonitor)new SubProgressMonitor(this.monitor, -1));
            int exitValue = 0;
            if (proc != null) {
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException iOException) {}
                if (launcher.waitAndRead(stdout, stderr, (IProgressMonitor)new SubProgressMonitor(this.monitor, -1)) != 0) {
                    errMsg = launcher.getErrorMessage();
                }
                if (errMsg == null || errMsg.length() == 0) {
                    try {
                        exitValue = proc.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        exitValue = proc.exitValue();
                    }
                }
                this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh"));
                try {
                    this.project.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh.error"));
                }
            } else {
                errMsg = launcher.getErrorMessage();
            }
            buf = new StringBuffer();
            if (errMsg != null && errMsg.length() > 0) {
                String errorDesc = AutotoolsPlugin.getResourceString("MakeGenerator.generation.error");
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(errorDesc);
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append("(").append(errMsg).append(")");
                rc = 4;
            } else if (exitValue >= 1 || exitValue < 0) {
                String[] errArg = new String[]{Integer.toString(proc.exitValue()), commandPath.toString()};
                errMsg = AutotoolsPlugin.getFormattedString("MakeGenerator.config.error", errArg);
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(AutotoolsPlugin.getResourceString("MakeGenerator.generation.error"));
                buf.append(System.getProperty("line.separator", "\n"));
                rc = proc.exitValue() == 1 ? 2 : 4;
            } else {
                String successMsg = AutotoolsPlugin.getResourceString("MakeGenerator.success");
                buf.append(successMsg);
                buf.append(System.getProperty("line.separator", "\n"));
                rc = 0;
            }
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
        }
        finally {
            if (consoleOutStream != null) {
                consoleOutStream.close();
            }
            if (epm != null) {
                epm.close();
            }
        }
        if (rc == 4 && !this.hasMarkers((IResource)this.project)) {
            this.addMarker((IResource)this.project, -1, errMsg, 3, null);
        }
        return rc;
    }

    private String getWinOSType() {
        if (this.winOSType.equals("")) {
            try {
                RemoteCommandLauncher launcher = new RemoteCommandLauncher();
                launcher.setProject(this.getProject());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IEnvironmentVariable[] variables = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(this.cdesc, true);
                String[] env = new String[]{};
                ArrayList<String> envList = new ArrayList<String>();
                if (variables != null) {
                    int i = 0;
                    while (i < variables.length) {
                        envList.add(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue());
                        ++i;
                    }
                    env = envList.toArray(new String[envList.size()]);
                }
                launcher.execute((IPath)new Path("sh"), new String[]{"-c", "echo $OSTYPE"}, env, (IPath)new Path("."), (IProgressMonitor)new SubProgressMonitor(this.monitor, -1));
                if (launcher.waitAndRead((OutputStream)out, (OutputStream)out) == 0) {
                    this.winOSType = out.toString().trim();
                }
            }
            catch (CoreException coreException) {}
        }
        return this.winOSType;
    }

    private String getOSName() {
        IRemoteResource remRes = (IRemoteResource)this.getProject().getAdapter(IRemoteResource.class);
        if (remRes != null) {
            IRemoteConnection conn;
            URI uri = remRes.getActiveLocationURI();
            IRemoteServicesManager remoteServiceManager = AutotoolsPlugin.getService(IRemoteServicesManager.class);
            IRemoteConnectionType connectionType = remoteServiceManager.getConnectionType(uri);
            if (connectionType != null && (conn = connectionType.getConnection(uri)) != null) {
                if (!conn.isOpen()) {
                    try {
                        conn.open((IProgressMonitor)new SubProgressMonitor(this.monitor, -1));
                    }
                    catch (RemoteConnectionException remoteConnectionException) {}
                }
                if (conn.isOpen()) {
                    return conn.getProperty("os.name");
                }
            }
        }
        return Platform.getOS();
    }

    private String getPathString(IPath path) {
        String s = path.toString();
        if (this.getOSName().equals("win32")) {
            s = this.getWinOSType().equals("cygwin") ? s.replaceAll("^([a-zA-Z]):", "/cygdrive/$1") : s.replaceAll("^([a-zA-Z]):", "/$1");
        }
        return s;
    }

    private String fixEscapeChars(String s) {
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\\(", "\\\\(");
        s = s.replaceAll("\\)", "\\\\)");
        return s;
    }

    private int runScript(IPath commandPath, IPath runPath, String[] args, String jobDescription, String errMsg, IConsole console, ArrayList<String> additionalEnvs, boolean consoleStart) throws BuildException, CoreException, NullPointerException, IOException {
        int rc = 0;
        boolean removePWD = false;
        this.removeAllMarkers(this.project);
        String[] configTargets = null;
        if (args == null) {
            configTargets = new String[1];
        } else {
            configTargets = new String[args.length + 1];
            System.arraycopy(args, 0, configTargets, 1, args.length);
        }
        configTargets[0] = this.getPathString(commandPath);
        String osName = this.getOSName();
        if (osName.equals("win32") || osName.equals("macosx")) {
            removePWD = true;
        }
        String command = null;
        String[] stringArray = configTargets;
        int n = configTargets.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            command = command == null ? arg : String.valueOf(command) + " " + arg;
            ++n2;
        }
        configTargets = new String[]{"-c", command};
        int i = 0;
        while (i < configTargets.length) {
            try {
                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(configTargets[i], "", " ", 3, (Object)this.cfg);
                if (resolved.length() > 0 && resolved.charAt(0) != '-') {
                    resolved = AutotoolsNewMakeGenerator.stripEnvVarsFromOption(resolved, additionalEnvs);
                }
                configTargets[i] = this.fixEscapeChars(resolved);
            }
            catch (BuildMacroException buildMacroException) {}
            ++i;
        }
        String[] msgs = new String[]{commandPath.toString(), this.project.getName()};
        this.monitor.subTask(AutotoolsPlugin.getFormattedString("MakeGenerator.make.message", msgs));
        ConsoleOutputStream consoleOutStream = null;
        ErrorParserManager epm = null;
        StringBuffer buf = new StringBuffer();
        if (consoleStart) {
            console.start(this.project);
        }
        try {
            OutputStream stdout;
            consoleOutStream = console.getOutputStream();
            String[] consoleHeader = new String[]{jobDescription, this.toolsCfg.getId(), this.project.getName()};
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(jobDescription);
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(System.getProperty("line.separator", "\n"));
            if (additionalEnvs != null && additionalEnvs.size() > 0) {
                buf.append(AutotoolsPlugin.getResourceString("MakeGenerator.commandline.envvars"));
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append("\t");
                int i2 = 0;
                while (i2 < additionalEnvs.size()) {
                    String envvar = additionalEnvs.get(i2);
                    buf.append(envvar.replaceFirst("(\\w+=)(.*)", " $1\"$2\""));
                    ++i2;
                }
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(System.getProperty("line.separator", "\n"));
            }
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            RemoteCommandLauncher launcher = new RemoteCommandLauncher();
            launcher.setProject(this.project);
            IEnvironmentVariable[] variables = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(this.cdesc, true);
            String[] env = null;
            ArrayList<String> envList = new ArrayList<String>();
            if (variables != null) {
                int i3 = 0;
                while (i3 < variables.length) {
                    if (!removePWD || !variables[i3].getName().equals("PWD")) {
                        String value = variables[i3].getValue();
                        if (variables[i3].getName().equals("PWD") && value.charAt(value.length() - 1) == '/') {
                            value = value.substring(0, value.length() - 1);
                        }
                        envList.add(String.valueOf(variables[i3].getName()) + "=" + value);
                    }
                    ++i3;
                }
                if (additionalEnvs != null) {
                    envList.addAll(additionalEnvs);
                }
                env = envList.toArray(new String[envList.size()]);
            }
            URI uri = URIUtil.toURI((IPath)runPath);
            epm = new ErrorParserManager(this.project, uri, this, new String[]{"org.eclipse.cdt.autotools.core.errorParser"});
            epm.setOutputStream((OutputStream)consoleOutStream);
            epm.addErrorParser("org.eclipse.cdt.autotools.core.errorParser", new ErrorParser(this.getSourcePath(), this.getBuildPath()));
            OutputStream stderr = stdout = epm.getOutputStream();
            launcher.showCommand(true);
            Process proc = launcher.execute((IPath)new Path("sh"), configTargets, env, runPath, (IProgressMonitor)new SubProgressMonitor(this.monitor, -1));
            int exitValue = 0;
            if (proc != null) {
                try {
                    proc.getOutputStream().close();
                }
                catch (IOException iOException) {}
                if (launcher.waitAndRead(stdout, stderr, (IProgressMonitor)new SubProgressMonitor(this.monitor, -1)) != 0) {
                    errMsg = launcher.getErrorMessage();
                }
                if (errMsg == null || errMsg.length() == 0) {
                    try {
                        exitValue = proc.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        exitValue = proc.exitValue();
                    }
                }
                this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh"));
                try {
                    this.project.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    this.monitor.subTask(AutotoolsPlugin.getResourceString("MakeGenerator.refresh.error"));
                }
            } else {
                errMsg = launcher.getErrorMessage();
            }
            buf = new StringBuffer();
            if (errMsg != null && errMsg.length() > 0) {
                String errorDesc = AutotoolsPlugin.getResourceString("MakeGenerator.generation.error");
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(errorDesc);
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append("(").append(errMsg).append(")");
                rc = 4;
            } else if (exitValue >= 1 || exitValue < 0) {
                String[] errArg = new String[]{Integer.toString(proc.exitValue()), commandPath.toString()};
                errMsg = AutotoolsPlugin.getFormattedString("MakeGenerator.config.error", errArg);
                buf.append(System.getProperty("line.separator", "\n"));
                buf.append(AutotoolsPlugin.getResourceString("MakeGenerator.generation.error"));
                buf.append(System.getProperty("line.separator", "\n"));
                rc = proc.exitValue() == 1 ? 2 : 4;
            } else {
                String successMsg = AutotoolsPlugin.getResourceString("MakeGenerator.success");
                buf.append(successMsg);
                buf.append(System.getProperty("line.separator", "\n"));
                rc = 0;
            }
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
        }
        finally {
            if (consoleOutStream != null) {
                consoleOutStream.close();
            }
            if (epm != null) {
                epm.close();
            }
        }
        if (rc == 4 && !this.hasMarkers((IResource)this.project)) {
            this.addMarker((IResource)this.project, -1, errMsg, 3, null);
        }
        return rc;
    }

    private ICStorageElement createTargetElement(ICStorageElement parent, IMakeTarget target) {
        ICStorageElement targetElem = parent.createChild(TARGET_ELEMENT);
        targetElem.setAttribute(TARGET_ATTR_NAME, target.getName());
        targetElem.setAttribute(TARGET_ATTR_ID, target.getTargetBuilderID());
        targetElem.setAttribute(TARGET_ATTR_PATH, target.getContainer().getProjectRelativePath().toString());
        ICStorageElement elem = targetElem.createChild(TARGET_COMMAND);
        elem.setValue(target.getBuildAttribute("org.eclipse.cdt.make.core.build.command", this.builder.getBuildCommand().toOSString()));
        String targetAttr = target.getBuildAttribute("org.eclipse.cdt.make.core.build.arguments", null);
        if (targetAttr != null) {
            elem = targetElem.createChild(TARGET_ARGUMENTS);
            elem.setValue(targetAttr);
        }
        if ((targetAttr = target.getBuildAttribute(IMakeTarget.BUILD_TARGET, null)) != null) {
            elem = targetElem.createChild(TARGET);
            elem.setValue(targetAttr);
        }
        elem = targetElem.createChild(TARGET_STOP_ON_ERROR);
        elem.setValue(Boolean.valueOf(target.isStopOnError()).toString());
        elem = targetElem.createChild(TARGET_USE_DEFAULT_CMD);
        elem.setValue(Boolean.valueOf(target.isDefaultBuildCmd()).toString());
        elem = targetElem.createChild(TARGET_RUN_ALL_BUILDERS);
        elem.setValue(Boolean.valueOf(target.runAllBuilders()).toString());
        return targetElem;
    }

    private void saveTargets(IMakeTarget[] makeTargets) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.getProject(), true);
        ICStorageElement rootElement = descriptor.getProjectStorageElement(MAKE_TARGET_KEY);
        rootElement.clear();
        rootElement = rootElement.createChild(BUILD_TARGET_ELEMENT);
        int i = 0;
        while (i < makeTargets.length) {
            this.createTargetElement(rootElement, makeTargets[i]);
            ++i;
        }
        descriptor.saveProjectData();
    }

    private void addMakeTargetsToManager(File makefileFile) throws CoreException {
        if (makefileFile == null || !makefileFile.exists()) {
            return;
        }
        this.checkCancel();
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        String statusMsg = AutotoolsPlugin.getResourceString("MakeGenerator.refresh.MakeTargets");
        this.monitor.subTask(statusMsg);
        IMakeTargetManager makeTargetManager = MakeCorePlugin.getDefault().getTargetManager();
        IMakefile makefile = MakeCorePlugin.createMakefile((URI)makefileFile.toURI(), (boolean)false, null);
        ITargetRule[] targets = makefile.getTargetRules();
        ITarget target = null;
        HashMap<String, IMakeTarget> makeTargets = new HashMap<String, IMakeTarget>();
        String[] id = makeTargetManager.getTargetBuilders(this.getProject());
        if (id.length == 0) {
            return;
        }
        String targetBuildID = id[0];
        IMakeBuilderInfo buildInfo = MakeCorePlugin.createBuildInfo((IProject)this.getProject(), (String)makeTargetManager.getBuilderID(targetBuildID));
        boolean isStopOnError = buildInfo.isStopOnError();
        IPath buildCommand = buildInfo.getBuildCommand();
        String defaultBuildCommand = buildCommand.toString();
        String buildArguments = buildInfo.getBuildArguments();
        IMakeTarget dummyTarget = makeTargetManager.createTarget(this.project, "\ndummyTarget\n", targetBuildID);
        makeTargetManager.setTargets((IContainer)this.project, new IMakeTarget[]{dummyTarget});
        int i = 0;
        while (i < targets.length) {
            target = targets[i].getTarget();
            String targetName = target.toString();
            if (this.isValidTarget(targetName, makeTargetManager)) {
                try {
                    IMakeTarget makeTarget = makeTargetManager.createTarget(this.project, targetName, targetBuildID);
                    makeTarget.setContainer((IContainer)this.project);
                    makeTarget.setStopOnError(isStopOnError);
                    makeTarget.setRunAllBuilders(false);
                    makeTarget.setUseDefaultBuildCmd(true);
                    makeTarget.setBuildAttribute(IMakeTarget.BUILD_ARGUMENTS, buildArguments);
                    makeTarget.setBuildAttribute(IMakeTarget.BUILD_COMMAND, defaultBuildCommand);
                    makeTarget.setBuildAttribute("org.eclipse.cdt.autotools.core.generated.MakeTarget", "true");
                    makeTarget.setBuildAttribute(IMakeTarget.BUILD_TARGET, targetName);
                    makeTarget.setBuildAttribute(IMakeTarget.BUILD_LOCATION, this.buildDir);
                    makeTargets.put(makeTarget.getName(), makeTarget);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        IMakeTarget[] makeTargetArray = new IMakeTarget[makeTargets.size()];
        Collection values = makeTargets.values();
        ArrayList valueList = new ArrayList(values);
        valueList.toArray(makeTargetArray);
        MakeTargetComparator compareMakeTargets = new MakeTargetComparator();
        Arrays.sort(makeTargetArray, compareMakeTargets);
        Class<?> c = makeTargetManager.getClass();
        boolean targetsAdded = false;
        try {
            Method m = c.getMethod("setTargets", IContainer.class, IMakeTarget[].class);
            m.invoke((Object)makeTargetManager, this.project, makeTargetArray);
            targetsAdded = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (!targetsAdded) {
            this.saveTargets(makeTargetArray);
        }
    }

    private boolean isValidTarget(String targetName, IMakeTargetManager makeTargetManager) {
        return !targetName.endsWith("-am") && !targetName.endsWith("PROGRAMS") && !targetName.endsWith("-generic") && targetName.indexOf(36) < 0 && targetName.charAt(0) != '.' && !targetName.equals(targetName.toUpperCase());
    }

    private String[] makeArray(String string) {
        String str;
        string = string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            boolean needsToAdd = true;
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    inComment = !inComment;
                    needsToAdd = false;
                }
            }
            if (c == ' ' && !inComment) {
                String str2;
                if (buffer.length() > 0 && (str2 = buffer.toString().trim()).length() > 0) {
                    aList.add(str2);
                }
                buffer = new StringBuilder();
            } else if (needsToAdd) {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0 && (str = buffer.toString().trim()).length() > 0) {
            aList.add(str);
        }
        return aList.toArray(new String[aList.size()]);
    }

    protected static class MakeTargetComparator
    implements Comparator<Object> {
        protected MakeTargetComparator() {
        }

        @Override
        public int compare(Object a, Object b) {
            IMakeTarget make1 = (IMakeTarget)a;
            IMakeTarget make2 = (IMakeTarget)b;
            return make1.getName().compareToIgnoreCase(make2.getName());
        }
    }
}

