/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.build.ArduinoBuildConfiguration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ArduinoLibrary {
    private String name;
    private String version;
    private String author;
    private String maintainer;
    private String sentence;
    private String paragraph;
    private String website;
    private String category;
    private List<String> architectures;
    private List<String> types;
    private String url;
    private String archiveFileName;
    private int size;
    private String checksum;
    private Path installPath;

    public ArduinoLibrary() {
    }

    public ArduinoLibrary(Path propertiesFile) throws IOException {
        this.installPath = propertiesFile.getParent();
        Properties props = new Properties();
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileReader reader = new FileReader(propertiesFile.toFile());){
            props.load(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.name = props.getProperty("name");
        this.version = props.getProperty("version");
        this.author = props.getProperty("author");
        this.maintainer = props.getProperty("maintainer");
        this.sentence = props.getProperty("sentence");
        this.paragraph = props.getProperty("paragraph");
        this.category = props.getProperty("category");
        this.architectures = Arrays.asList(props.getProperty("architectures").split(","));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public String getSentence() {
        return this.sentence;
    }

    public void setSentence(String sentence) {
        this.sentence = sentence;
    }

    public String getParagraph() {
        return this.paragraph;
    }

    public void setParagraph(String paragraph) {
        this.paragraph = paragraph;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<String> getArchitectures() {
        return this.architectures;
    }

    public void setArchitectures(List<String> architectures) {
        this.architectures = architectures;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.archiveFileName = archiveFileName;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Path getInstallPath() {
        return this.installPath != null ? this.installPath : ArduinoPreferences.getArduinoHome().resolve("libraries").resolve(this.name.replace(' ', '_')).resolve(this.version);
    }

    public boolean isInstalled() {
        return this.getInstallPath().toFile().exists();
    }

    public IStatus install(IProgressMonitor monitor) {
        if (this.isInstalled()) {
            return Status.OK_STATUS;
        }
        return ArduinoManager.downloadAndInstall(this.url, this.archiveFileName, this.getInstallPath(), monitor);
    }

    public Collection<Path> getIncludePath() {
        Path installPath = this.getInstallPath();
        Path srcPath = installPath.resolve("src");
        if (srcPath.toFile().isDirectory()) {
            return Collections.singletonList(srcPath);
        }
        return Collections.singletonList(installPath);
    }

    private void getSources(Collection<String> sources, Path dir, boolean recurse) {
        File[] fileArray = dir.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (recurse) {
                    this.getSources(sources, file.toPath(), recurse);
                }
            } else if (ArduinoBuildConfiguration.isSource(file.getName())) {
                sources.add(ArduinoBuildConfiguration.pathString(file.toPath()));
            }
            ++n2;
        }
    }

    public Collection<String> getSources() {
        ArrayList<String> sources = new ArrayList<String>();
        Path installPath = this.getInstallPath();
        Path srcPath = installPath.resolve("src");
        if (srcPath.toFile().isDirectory()) {
            this.getSources(sources, srcPath, true);
        } else {
            this.getSources(sources, installPath, false);
            Path utilityPath = installPath.resolve("utility");
            if (utilityPath.toFile().isDirectory()) {
                this.getSources(sources, utilityPath, false);
            }
        }
        return sources;
    }
}

