/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;

public class ArduinoToolSystem {
    private String host;
    private String archiveFileName;
    private String url;
    private String checksum;
    private String size;
    private transient ArduinoTool tool;

    public void setOwner(ArduinoTool tool) {
        this.tool = tool;
    }

    public String getHost() {
        return this.host;
    }

    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getSize() {
        return this.size;
    }

    public boolean isApplicable() {
        switch (Platform.getOS()) {
            case "win32": {
                return "i686-mingw32".equals(this.host);
            }
            case "macosx": {
                switch (this.host) {
                    case "x86_64-apple-darwin": 
                    case "i386-apple-darwin11": {
                        return true;
                    }
                }
                return false;
            }
            case "linux": {
                switch (Platform.getOSArch()) {
                    case "x86_64": {
                        return "x86_64-pc-linux-gnu".equals(this.host);
                    }
                    case "x86": {
                        return "i686-pc-linux-gnu".equals(this.host);
                    }
                }
                return false;
            }
        }
        return false;
    }

    public IStatus install(IProgressMonitor monitor) {
        return ArduinoManager.downloadAndInstall(this.url, this.archiveFileName, this.tool.getInstallPath(), monitor);
    }
}

