/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.board;

import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoTool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ToolDependency {
    private String packager;
    private String name;
    private String version;
    private transient ArduinoPlatform platform;

    public void setOwner(ArduinoPlatform platform) {
        this.platform = platform;
    }

    public String getPackager() {
        return this.packager;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public ArduinoTool getTool() throws CoreException {
        ArduinoPackage pkg = this.platform.getPackage();
        if (!pkg.getName().equals(this.packager)) {
            pkg = pkg.getManager().getPackage(this.packager);
        }
        return pkg.getTool(this.name, this.version);
    }

    public IStatus install(IProgressMonitor monitor) {
        try {
            ArduinoTool tool = this.getTool();
            if (tool == null) {
                return new Status(4, Activator.getId(), String.format("Tool not found %s %s", this.name, this.version));
            }
            return this.getTool().install(monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }
}

