/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoPreferences;
import org.eclipse.cdt.arduino.core.internal.ArduinoTemplateGenerator;
import org.eclipse.cdt.arduino.core.internal.HierarchicalProperties;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoLibrary;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.board.ToolDependency;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoConsoleParser;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoErrorParser;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ArduinoBuildConfiguration {
    private static final String PACKAGE_NAME = "packageName";
    private static final String PLATFORM_NAME = "platformName";
    private static final String BOARD_NAME = "boardName";
    private final IBuildConfiguration config;
    private ArduinoBoard board;
    private Properties properties;
    private IScannerInfo cScannerInfo;
    private IScannerInfo cppScannerInfo;
    private static final boolean isWindows = Platform.getOS().equals("win32");
    private static Map<IBuildConfiguration, ArduinoBuildConfiguration> cache = new HashMap<IBuildConfiguration, ArduinoBuildConfiguration>();

    private ArduinoBuildConfiguration(IBuildConfiguration config) {
        this.config = config;
    }

    public static ArduinoBuildConfiguration getConfig(IProject project, ArduinoRemoteConnection target, IProgressMonitor monitor) throws CoreException {
        Object arduinoConfig;
        ArduinoBoard board = target.getBoard();
        IBuildConfiguration[] iBuildConfigurationArray = project.getBuildConfigs();
        int n = iBuildConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfiguration config = iBuildConfigurationArray[n2];
            arduinoConfig = (ArduinoBuildConfiguration)config.getAdapter(ArduinoBuildConfiguration.class);
            if (((ArduinoBuildConfiguration)arduinoConfig).matches(target)) {
                return arduinoConfig;
            }
            ++n2;
        }
        HashSet<String> configNames = new HashSet<String>();
        arduinoConfig = project.getBuildConfigs();
        int n3 = ((IBuildConfiguration[])arduinoConfig).length;
        n = 0;
        while (n < n3) {
            Object config = arduinoConfig[n];
            configNames.add(config.getName());
            ++n;
        }
        String newName = board.getId();
        int n4 = 0;
        while (configNames.contains(newName)) {
            newName = String.valueOf(board.getId()) + ++n4;
        }
        configNames.add(newName);
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setBuildConfigs(configNames.toArray(new String[configNames.size()]));
        project.setDescription(projectDesc, monitor);
        IBuildConfiguration config = project.getBuildConfig(newName);
        ArduinoBuildConfiguration arduinoConfig2 = (ArduinoBuildConfiguration)config.getAdapter(ArduinoBuildConfiguration.class);
        arduinoConfig2.setBoard(target);
        return arduinoConfig2;
    }

    public void setActive(IProgressMonitor monitor) throws CoreException {
        IProject project = this.config.getProject();
        if (this.config.equals(project.getActiveBuildConfig())) {
            return;
        }
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setActiveBuildConfig(this.config.getName());
        project.setDescription(projectDesc, monitor);
        CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(project));
    }

    public IEclipsePreferences getSettings() {
        return (IEclipsePreferences)new ProjectScope(this.config.getProject()).getNode(Activator.getId()).node("config").node(this.config.getName());
    }

    public void setBoard(ArduinoBoard board) throws CoreException {
        this.board = board;
        ArduinoPlatform platform = board.getPlatform();
        ArduinoPackage pkg = platform.getPackage();
        IEclipsePreferences settings = this.getSettings();
        settings.put(PACKAGE_NAME, pkg.getName());
        settings.put(PLATFORM_NAME, platform.getName());
        settings.put(BOARD_NAME, board.getName());
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Saving preferences", (Throwable)e));
        }
    }

    public void setBoard(ArduinoRemoteConnection target) throws CoreException {
        this.board = target.getBoard();
        ArduinoPlatform platform = this.board.getPlatform();
        ArduinoPackage pkg = platform.getPackage();
        IEclipsePreferences settings = this.getSettings();
        settings.put(PACKAGE_NAME, pkg.getName());
        settings.put(PLATFORM_NAME, platform.getName());
        settings.put(BOARD_NAME, this.board.getName());
        HierarchicalProperties menus = this.board.getMenus();
        if (menus != null) {
            for (String id : menus.getChildren().keySet()) {
                String key = "menu_" + id;
                String value = target.getRemoteConnection().getAttribute(key);
                if (value == null) continue;
                settings.put(key, value);
            }
        }
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Saving preferences", (Throwable)e));
        }
    }

    public boolean matches(ArduinoRemoteConnection target) throws CoreException {
        ArduinoBoard otherBoard = target.getBoard();
        if (!this.getBoard().equals(otherBoard)) {
            return false;
        }
        IEclipsePreferences settings = this.getSettings();
        HierarchicalProperties menus = this.board.getMenus();
        if (menus != null) {
            for (String id : menus.getChildren().keySet()) {
                String key = "menu_" + id;
                if (settings.get(key, "").equals(target.getRemoteConnection().getAttribute(key))) continue;
                return false;
            }
        }
        return true;
    }

    public ArduinoBoard getBoard() throws CoreException {
        if (this.board == null) {
            IEclipsePreferences settings = this.getSettings();
            String packageName = settings.get(PACKAGE_NAME, "");
            String platformName = settings.get(PLATFORM_NAME, "");
            String boardName = settings.get(BOARD_NAME, "");
            this.board = ArduinoManager.instance.getBoard(boardName, platformName, packageName);
        }
        return this.board;
    }

    private Properties getProperties() throws CoreException {
        if (this.properties == null) {
            ArduinoBoard board = this.getBoard();
            this.properties = board.getBoardProperties();
            IEclipsePreferences settings = this.getSettings();
            HierarchicalProperties menus = board.getMenus();
            if (menus != null) {
                for (String menuId : menus.getChildren().keySet()) {
                    String value = settings.get("menu_", "");
                    if (value.isEmpty()) continue;
                    this.properties.putAll((Map<?, ?>)board.getMenuProperties(menuId, value));
                }
            }
            ArduinoPlatform platform = board.getPlatform();
            this.properties.putAll((Map<?, ?>)board.getPlatform().getPlatformProperties());
            for (ToolDependency toolDep : platform.getToolsDependencies()) {
                this.properties.putAll((Map<?, ?>)toolDep.getTool().getToolProperties());
            }
            this.properties.put("runtime.platform.path", platform.getInstallPath().toString());
            this.properties.put("runtime.ide.version", "10607");
            this.properties.put("build.arch", platform.getArchitecture().toUpperCase());
            this.properties.put("build.path", this.config.getName());
        }
        this.properties.put("build.project_name", this.config.getProject().getName());
        return this.properties;
    }

    public IFolder getBuildFolder() throws CoreException {
        IProject project = this.config.getProject();
        return project.getFolder("build");
    }

    public File getBuildDirectory() throws CoreException {
        return new File(this.getBuildFolder().getLocationURI());
    }

    public IFile getMakeFile() throws CoreException {
        IFolder buildFolder = this.getBuildFolder();
        ArduinoBoard board = this.getBoard();
        String makeFileName = String.valueOf(board.getId()) + ".mk";
        return buildFolder.getFile(makeFileName);
    }

    public IFile generateMakeFile(IProgressMonitor monitor) throws CoreException {
        IProject project = this.config.getProject();
        IFolder buildFolder = this.getBuildFolder();
        if (!buildFolder.exists()) {
            buildFolder.create(true, true, monitor);
            ICProject cproject = CoreModel.getDefault().create(project);
            IOutputEntry output = CoreModel.newOutputEntry((IPath)buildFolder.getFullPath());
            IPathEntry[] oldEntries = cproject.getRawPathEntries();
            IPathEntry[] newEntries = new IPathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = output;
            cproject.setRawPathEntries(newEntries, monitor);
        }
        ArduinoBoard board = this.getBoard();
        ArduinoPlatform platform = board.getPlatform();
        IFile makeFile = this.getMakeFile();
        HashMap<String, Object> buildModel = new HashMap<String, Object>();
        buildModel.put("boardId", board.getId());
        final Path projectPath = new File(project.getLocationURI()).toPath();
        final ArrayList sourceFiles = new ArrayList();
        ISourceRoot[] iSourceRootArray = CCorePlugin.getDefault().getCoreModel().create(project).getSourceRoots();
        int n = iSourceRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceRoot sourceRoot = iSourceRootArray[n2];
            sourceRoot.getResource().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1 && ArduinoBuildConfiguration.isSource(proxy.getName())) {
                        Path sourcePath = new File(proxy.requestResource().getLocationURI()).toPath();
                        sourceFiles.add(ArduinoBuildConfiguration.pathString(projectPath.relativize(sourcePath)));
                    }
                    return true;
                }
            }, 0);
            ++n2;
        }
        buildModel.put("project_srcs", sourceFiles);
        ArrayList<String> librarySources = new ArrayList<String>();
        for (ArduinoLibrary lib : ArduinoManager.instance.getLibraries(project)) {
            librarySources.addAll(lib.getSources());
        }
        buildModel.put("libraries_srcs", librarySources);
        buildModel.put("libraries_path", ArduinoBuildConfiguration.pathString(ArduinoPreferences.getArduinoHome().resolve("libraries")));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getProperties());
        buildModel.put("build_path", properties.get("build.path"));
        buildModel.put("project_name", project.getName());
        String includes = null;
        for (Path include : platform.getIncludePath()) {
            includes = includes == null ? "-I" : String.valueOf(includes) + " -I";
            includes = String.valueOf(includes) + '\"' + ArduinoBuildConfiguration.pathString(include) + '\"';
        }
        for (ArduinoLibrary lib : ArduinoManager.instance.getLibraries(project)) {
            for (Path include : lib.getIncludePath()) {
                includes = String.valueOf(includes) + " -I\"" + ArduinoBuildConfiguration.pathString(include) + '\"';
            }
        }
        properties.put("includes", includes);
        Path platformPath = platform.getInstallPath();
        buildModel.put("platform_path", ArduinoBuildConfiguration.pathString(platformPath));
        buildModel.put("platform_srcs", platform.getSources(properties.getProperty("build.core")));
        properties.put("object_file", "$@");
        properties.put("source_file", "$<");
        properties.put("archive_file", "core.a");
        properties.put("object_files", "$(PROJECT_OBJS) $(LIBRARIES_OBJS)");
        buildModel.put("recipe_cpp_o_pattern", this.resolveProperty("recipe.cpp.o.pattern", properties));
        buildModel.put("recipe_c_o_pattern", this.resolveProperty("recipe.c.o.pattern", properties));
        buildModel.put("recipe_S_o_pattern", this.resolveProperty("recipe.S.o.pattern", properties));
        buildModel.put("recipe_ar_pattern", this.resolveProperty("recipe.ar.pattern", properties));
        buildModel.put("recipe_c_combine_pattern", this.resolveProperty("recipe.c.combine.pattern", properties));
        buildModel.put("recipe_objcopy_eep_pattern", this.resolveProperty("recipe.objcopy.eep.pattern", properties));
        buildModel.put("recipe_objcopy_hex_pattern", this.resolveProperty("recipe.objcopy.hex.pattern", properties));
        buildModel.put("recipe_size_pattern", this.resolveProperty("recipe.size.pattern", properties));
        ArduinoTemplateGenerator templateGen = new ArduinoTemplateGenerator();
        templateGen.generateFile(buildModel, "board.mk", makeFile, monitor);
        return makeFile;
    }

    public static boolean isSource(String filename) {
        String ext;
        int i = filename.lastIndexOf(46);
        switch (ext = filename.substring(i + 1)) {
            case "S": 
            case "c": 
            case "cpp": {
                return true;
            }
        }
        return false;
    }

    private String resolveProperty(String property, Properties dict) {
        String last;
        String res = dict.getProperty(property);
        if (res == null) {
            return null;
        }
        do {
            last = res;
            int i = res.indexOf(123);
            while (i >= 0) {
                String p2;
                String r2;
                int n;
                if ((n = res.indexOf(125, ++i)) >= 0 && (r2 = dict.getProperty(p2 = res.substring(i, n))) != null) {
                    res = res.replace(String.valueOf('{') + p2 + '}', r2);
                }
                i = n;
                i = res.indexOf(123, i);
            }
        } while (!res.equals(last));
        return res;
    }

    public void setEnvironment(Map<String, String> env) throws CoreException {
    }

    public String getMakeCommand() {
        return isWindows ? ArduinoPreferences.getArduinoHome().resolve("tools/make/make").toString() : "make";
    }

    public String[] getBuildCommand() throws CoreException {
        return new String[]{this.getMakeCommand(), "-f", this.getMakeFile().getName()};
    }

    public String[] getCleanCommand() throws CoreException {
        return new String[]{this.getMakeCommand(), "-f", this.getMakeFile().getName(), "clean"};
    }

    public String[] getSizeCommand() throws CoreException {
        return new String[]{this.getMakeCommand(), "-f", this.getMakeFile().getName(), "size"};
    }

    public String getCodeSizeRegex() throws CoreException {
        return this.getBoard().getPlatform().getPlatformProperties().getProperty("recipe.size.regex");
    }

    public int getMaxCodeSize() throws CoreException {
        String sizeStr = this.getProperties().getProperty("upload.maximum_size");
        return sizeStr != null ? Integer.parseInt(sizeStr) : -1;
    }

    public String getDataSizeRegex() throws CoreException {
        return this.getBoard().getPlatform().getPlatformProperties().getProperty("recipe.size.regex.data");
    }

    public int getMaxDataSize() throws CoreException {
        String sizeStr = this.getProperties().getProperty("upload.maximum_data_size");
        return sizeStr != null ? Integer.parseInt(sizeStr) : -1;
    }

    public String[] getUploadCommand(String serialPort) throws CoreException {
        HierarchicalProperties toolProps;
        String toolName = this.getProperties().getProperty("upload.tool");
        Properties properties = this.getProperties();
        properties.put("serial.port", serialPort);
        HierarchicalProperties toolsProps = new HierarchicalProperties(this.getBoard().getPlatform().getPlatformProperties()).getChild("tools");
        if (toolsProps != null && (toolProps = toolsProps.getChild(toolName)) != null) {
            properties.putAll((Map<?, ?>)toolProps.flatten());
        }
        properties.put("upload.verbose", properties.getProperty("upload.params.verbose", ""));
        properties.put("upload.resetmethod", "ck");
        String command = this.resolveProperty("upload.pattern", properties);
        if (command == null) {
            return new String[]{"command not specified"};
        }
        if (isWindows) {
            return this.splitCommand(command);
        }
        return new String[]{"sh", "-c", command};
    }

    public IScannerInfo getScannerInfo(IResource resource) throws CoreException {
        block11: {
            IContentType contentType = CCorePlugin.getContentType((IProject)resource.getProject(), (String)resource.getName());
            if (contentType == null) break block11;
            switch (contentType.getId()) {
                case "org.eclipse.cdt.core.cxxHeader": 
                case "org.eclipse.cdt.core.cxxSource": {
                    if (this.cppScannerInfo == null) {
                        this.cppScannerInfo = this.calculateScannerInfo("recipe.cpp.o.pattern", resource);
                    }
                    return this.cppScannerInfo;
                }
            }
            if (this.cScannerInfo == null) {
                this.cScannerInfo = this.calculateScannerInfo("recipe.c.o.pattern", resource);
            }
            return this.cScannerInfo;
        }
        return this.cppScannerInfo;
    }

    public void clearScannerInfoCache() {
        this.cppScannerInfo = null;
        this.cScannerInfo = null;
    }

    public static String pathString(Path path) {
        String str = path.toString();
        if (isWindows) {
            str = str.replaceAll("\\\\", "/");
        }
        return str;
    }

    private IScannerInfo calculateScannerInfo(String recipe, IResource resource) throws CoreException {
        try {
            ArduinoPlatform platform = this.getBoard().getPlatform();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.getProperties());
            Path tmpFile = Files.createTempFile("cdt", ".cpp", new FileAttribute[0]);
            properties.put("source_file", ArduinoBuildConfiguration.pathString(tmpFile));
            properties.put("object_file", "-");
            String includes = "-E -P -v -dD";
            for (Path include : platform.getIncludePath()) {
                includes = String.valueOf(includes) + " -I\"" + ArduinoBuildConfiguration.pathString(include) + '\"';
            }
            Collection<ArduinoLibrary> libs = ArduinoManager.instance.getLibraries(this.config.getProject());
            for (ArduinoLibrary lib : libs) {
                for (Path path : lib.getIncludePath()) {
                    includes = String.valueOf(includes) + " -I\"" + ArduinoBuildConfiguration.pathString(path) + '\"';
                }
            }
            properties.put("includes", includes);
            String[] command = isWindows ? this.splitCommand(this.resolveProperty(recipe, properties)) : new String[]{"sh", "-c", this.resolveProperty(recipe, properties)};
            ProcessBuilder processBuilder = new ProcessBuilder(command).directory(tmpFile.getParent().toFile()).redirectErrorStream(true);
            this.setEnvironment(processBuilder.environment());
            Process process = processBuilder.start();
            HashMap<String, String> symbols = new HashMap<String, String>();
            ArrayList<String> includePath = new ArrayList<String>();
            Pattern definePattern = Pattern.compile("#define (.*)\\s(.*)");
            boolean inIncludePaths = false;
            Throwable throwable = null;
            Object var16_18 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = reader.readLine();
                while (line != null) {
                    if (inIncludePaths) {
                        if (line.equals("End of search list.")) {
                            inIncludePaths = false;
                        } else {
                            includePath.add(line.trim());
                        }
                    } else if (line.startsWith("#define ")) {
                        Matcher matcher = definePattern.matcher(line);
                        if (matcher.matches()) {
                            symbols.put(matcher.group(1), matcher.group(2));
                        }
                    } else if (line.equals("#include <...> search starts here:")) {
                        inIncludePaths = true;
                    }
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Files.delete(tmpFile);
            ExtendedScannerInfo scannerInfo = new ExtendedScannerInfo(symbols, includePath.toArray(new String[includePath.size()]));
            return scannerInfo;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), "Compiler built-ins", (Throwable)e));
        }
    }

    private String[] splitCommand(String command) {
        return command.replaceAll("\"", "").split("\\s+");
    }

    public ArduinoConsoleParser[] getBuildConsoleParsers() {
        return new ArduinoConsoleParser[]{new ArduinoErrorParser("(.*?):(\\d+):(\\d+:)? (fatal )?error: (.*)"){

            @Override
            protected int getSeverity(Matcher matcher) {
                return 2;
            }

            @Override
            protected String getMessage(Matcher matcher) {
                return matcher.group(matcher.groupCount());
            }

            @Override
            protected int getLineNumber(Matcher matcher) {
                return Integer.parseInt(matcher.group(2));
            }

            @Override
            protected String getFileName(Matcher matcher) {
                return matcher.group(1);
            }

            @Override
            protected int getLinkOffset(Matcher matcher) {
                return 0;
            }

            @Override
            protected int getLinkLength(Matcher matcher) {
                return matcher.group(1).length() + 1 + matcher.group(2).length() + 1 + matcher.group(3).length();
            }
        }};
    }

    /* synthetic */ ArduinoBuildConfiguration(IBuildConfiguration iBuildConfiguration, ArduinoBuildConfiguration arduinoBuildConfiguration) {
        this(iBuildConfiguration);
    }

    public static class Factory
    implements IAdapterFactory {
        public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
            if (adapterType.equals(ArduinoBuildConfiguration.class) && adaptableObject instanceof IBuildConfiguration) {
                IBuildConfiguration config = (IBuildConfiguration)adaptableObject;
                ArduinoBuildConfiguration arduinoConfig = (ArduinoBuildConfiguration)cache.get(config);
                if (arduinoConfig == null) {
                    arduinoConfig = new ArduinoBuildConfiguration(config, null);
                    cache.put(config, arduinoConfig);
                }
                return (T)arduinoConfig;
            }
            return null;
        }

        public Class<?>[] getAdapterList() {
            return new Class[]{ArduinoBuildConfiguration.class};
        }
    }
}

