/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.launch;

import org.eclipse.cdt.arduino.core.internal.console.ArduinoConsoleParser;
import org.eclipse.cdt.arduino.core.internal.console.ArduinoErrorParser;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.launch.ArduinoConsole;
import org.eclipse.cdt.arduino.ui.internal.launch.ArduinoHyperlink;
import org.eclipse.cdt.arduino.ui.internal.launch.ArduinoPatternMatchListener;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.PatternMatchEvent;

public class ArduinoErrorMatchListener
extends ArduinoPatternMatchListener {
    public ArduinoErrorMatchListener(ArduinoConsole arduinoConsole, ArduinoErrorParser parser) {
        super(arduinoConsole, (ArduinoConsoleParser)parser);
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            String text = this.textConsole.getDocument().get(event.getOffset(), event.getLength());
            IMarker marker = ((ArduinoErrorParser)this.parser).generateMarker(this.arduinoConsole.getBuildDirectory(), text);
            if (marker != null) {
                this.textConsole.addHyperlink((IHyperlink)new ArduinoHyperlink(marker), event.getOffset() + marker.getAttribute("arduino.link.offset", 0), marker.getAttribute("arduino.link.length", event.getLength()));
            }
        }
        catch (CoreException | BadLocationException e) {
            Activator.log((Exception)e);
        }
    }
}

