/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.remote;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPackage;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class ArduinoTargetPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Combo portSelector;
    private Combo boardSelector;
    private ArduinoBoard[] boards;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        IRemoteConnection remoteConnection = (IRemoteConnection)this.getElement().getAdapter(IRemoteConnection.class);
        ArduinoRemoteConnection arduinoRemote = (ArduinoRemoteConnection)remoteConnection.getService(ArduinoRemoteConnection.class);
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.ArduinoTargetPropertyPage_0);
        this.portSelector = new Combo(comp, 8);
        this.portSelector.setLayoutData((Object)new GridData(768));
        String currentPort = arduinoRemote.getPortName();
        int i = 0;
        int portSel = -1;
        try {
            String[] stringArray = SerialPort.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String port = stringArray[n2];
                this.portSelector.add(port);
                portSel = port.equals(currentPort) ? i : (portSel < 0 ? 0 : portSel);
                ++i;
                ++n2;
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
        if (portSel >= 0) {
            this.portSelector.select(portSel);
        } else {
            this.setMessage(Messages.ArduinoTargetPropertyPage_1, 3);
            this.setValid(false);
        }
        Label boardLabel = new Label(comp, 0);
        boardLabel.setText(Messages.ArduinoTargetPropertyPage_2);
        this.boardSelector = new Combo(comp, 8);
        this.boardSelector.setLayoutData((Object)new GridData(768));
        try {
            ArduinoBoard currentBoard = arduinoRemote.getBoard();
            List boardList = ArduinoManager.instance.getBoards();
            this.boards = new ArduinoBoard[boardList.size()];
            i = 0;
            int boardSel = 0;
            Iterator iterator = boardList.iterator();
            while (iterator.hasNext()) {
                ArduinoBoard board;
                this.boards[i] = board = (ArduinoBoard)iterator.next();
                this.boardSelector.add(board.getName());
                if (board.equals((Object)currentBoard)) {
                    boardSel = i;
                }
                ++i;
            }
            this.boardSelector.select(boardSel);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return comp;
    }

    public boolean performOk() {
        IRemoteConnection remoteConnection = (IRemoteConnection)this.getElement().getAdapter(IRemoteConnection.class);
        IRemoteConnectionWorkingCopy workingCopy = remoteConnection.getWorkingCopy();
        String portName = this.portSelector.getItem(this.portSelector.getSelectionIndex());
        workingCopy.setAttribute("arduinoPortName", portName);
        ArduinoBoard board = this.boards[this.boardSelector.getSelectionIndex()];
        workingCopy.setAttribute("arduinoBoardName", board.getName());
        ArduinoPlatform platform = board.getPlatform();
        workingCopy.setAttribute("arduinoPlatformName", platform.getName());
        ArduinoPackage pkg = platform.getPackage();
        workingCopy.setAttribute("arduinoPackageName", pkg.getName());
        try {
            workingCopy.save();
        }
        catch (RemoteConnectionException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return true;
    }
}

