/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.rewrite.DeclarationGenerator;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public final class CxxAstUtils {
    private CxxAstUtils() {
    }

    public static IType unwindTypedef(IType type) {
        return SemanticUtil.getNestedType((IType)type, (int)1);
    }

    public static boolean isInMacro(IASTNode node) {
        IASTNodeSelector nodeSelector = node.getTranslationUnit().getNodeSelector(node.getTranslationUnit().getFilePath());
        IASTFileLocation fileLocation = node.getFileLocation();
        if (fileLocation == null) {
            return true;
        }
        IASTPreprocessorMacroExpansion macro = nodeSelector.findEnclosingMacroExpansion(fileLocation.getNodeOffset(), fileLocation.getNodeLength());
        return macro != null;
    }

    public static IASTFunctionDefinition getEnclosingFunction(IASTNode node) {
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        return (IASTFunctionDefinition)node;
    }

    public static IASTCompositeTypeSpecifier getEnclosingCompositeTypeSpecifier(IASTNode node) {
        while (node != null && !(node instanceof IASTCompositeTypeSpecifier)) {
            node = node.getParent();
        }
        return (IASTCompositeTypeSpecifier)node;
    }

    public static IASTStatement getEnclosingStatement(IASTNode node) {
        while (node != null && !(node instanceof IASTStatement)) {
            node = node.getParent();
        }
        return (IASTStatement)node;
    }

    public static IASTDeclaration createDeclaration(IASTName astName, INodeFactory factory, IIndex index) {
        IType inferredType = null;
        IASTSimpleDeclaration declaration = null;
        inferredType = CxxAstUtils.tryInferTypeFromBinaryExpr(astName);
        if (inferredType == null) {
            declaration = CxxAstUtils.tryInferTypeFromFunctionCall(astName, factory, index);
        }
        if (declaration != null) {
            return declaration;
        }
        if (inferredType != null) {
            DeclarationGenerator generator = DeclarationGenerator.create((INodeFactory)factory);
            IASTDeclarator declarator = generator.createDeclaratorFromType(inferredType, astName.toCharArray());
            IASTDeclSpecifier declspec = generator.createDeclSpecFromType(inferredType);
            IASTSimpleDeclaration simpleDeclaration = factory.newSimpleDeclaration(declspec);
            simpleDeclaration.addDeclarator(declarator);
            return simpleDeclaration;
        }
        IASTDeclarator declarator = factory.newDeclarator(astName.copy(IASTNode.CopyStyle.withLocations));
        IASTSimpleDeclSpecifier declspec = factory.newSimpleDeclSpecifier();
        declspec.setType(IBasicType.Kind.eInt);
        IASTSimpleDeclaration simpleDeclaration = factory.newSimpleDeclaration((IASTDeclSpecifier)declspec);
        simpleDeclaration.addDeclarator(declarator);
        return simpleDeclaration;
    }

    private static IType tryInferTypeFromBinaryExpr(IASTName astName) {
        if (astName.getParent() instanceof IASTIdExpression && astName.getParent().getParent() instanceof IASTBinaryExpression) {
            IASTNode binaryExpr = astName.getParent().getParent();
            IASTNode[] iASTNodeArray = binaryExpr.getChildren();
            int n = iASTNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode node = iASTNodeArray[n2];
                if (node != astName.getParent()) {
                    return ((IASTExpression)node).getExpressionType();
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static IASTSimpleDeclaration tryInferTypeFromFunctionCall(IASTName astName, INodeFactory factory, IIndex index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setNameInNestedDeclarator(IASTDeclarator declarator, IASTName astName) {
        while (declarator.getNestedDeclarator() != null) {
            declarator = declarator.getNestedDeclarator();
        }
        declarator.setName(astName);
    }

    public static ITranslationUnit getTranslationUnitFromIndexName(IIndexName decl) throws CoreException {
        IIndexFile file = decl.getFile();
        if (file != null) {
            return CoreModelUtil.findTranslationUnitForLocation((URI)file.getLocation().getURI(), null);
        }
        return null;
    }

    public static IASTCompositeTypeSpecifier getCompositeTypeFromFunction(final IASTFunctionDefinition function, final IIndex index) {
        final IASTCompositeTypeSpecifier[] returnSpecifier = new IASTCompositeTypeSpecifier[1];
        final HashMap astCache = new HashMap();
        function.accept(new ASTVisitor(){
            {
                this.shouldVisitDeclarators = true;
                this.shouldVisitNames = true;
            }

            public int visit(IASTName name) {
                if (!(name instanceof ICPPASTQualifiedName) || name.getParent().getParent() != function) {
                    return 3;
                }
                ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
                if (qname.getChildren().length < 2) {
                    return 3;
                }
                IASTName namePart = (IASTName)qname.getChildren()[qname.getChildren().length - 2];
                IBinding binding = namePart.resolveBinding();
                try {
                    try {
                        IIndexName[] declarations;
                        index.acquireReadLock();
                        IIndexName[] iIndexNameArray = declarations = index.findDeclarations(binding);
                        int n = declarations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IIndexName decl = iIndexNameArray[n2];
                            ITranslationUnit tu = CxxAstUtils.getTranslationUnitFromIndexName(decl);
                            if (tu != null) {
                                IASTTranslationUnit ast = null;
                                if (astCache.containsKey(tu)) {
                                    ast = (IASTTranslationUnit)astCache.get(tu);
                                } else {
                                    ast = tu.getAST(index, 2);
                                    astCache.put(tu, ast);
                                }
                                IASTNode node = ast.getNodeSelector(null).findEnclosingNode(decl.getNodeOffset(), decl.getNodeLength());
                                IASTCompositeTypeSpecifier specifier = CxxAstUtils.getEnclosingCompositeTypeSpecifier(node);
                                if (specifier != null) {
                                    returnSpecifier[0] = specifier;
                                    break;
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        index.releaseReadLock();
                        return 2;
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                        index.releaseReadLock();
                        return 2;
                    }
                }
                finally {
                    index.releaseReadLock();
                }
                return 2;
            }
        });
        return returnSpecifier[0];
    }

    public static boolean isThrowStatement(IASTNode statement) {
        if (!(statement instanceof IASTExpressionStatement)) {
            return false;
        }
        IASTExpression expression = ((IASTExpressionStatement)statement).getExpression();
        if (!(expression instanceof IASTUnaryExpression)) {
            return false;
        }
        return ((IASTUnaryExpression)expression).getOperator() == 12;
    }

    public static boolean isExitStatement(IASTNode statement) {
        IASTName name;
        IBinding binding;
        NoReturnImplicitCallFinder noReturnFinder = new NoReturnImplicitCallFinder();
        statement.accept((ASTVisitor)noReturnFinder);
        if (noReturnFinder.noReturn) {
            return true;
        }
        if (!(statement instanceof IASTExpressionStatement)) {
            return false;
        }
        IASTExpression expression = ((IASTExpressionStatement)statement).getExpression();
        if (!(expression instanceof IASTFunctionCallExpression)) {
            return false;
        }
        IASTExpression functionNameExpression = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
        if (functionNameExpression instanceof IASTIdExpression && (binding = (name = ((IASTIdExpression)functionNameExpression).getName()).resolveBinding()) instanceof IFunction && ((IFunction)binding).isNoReturn()) {
            return true;
        }
        return functionNameExpression.getRawSignature().equals("exit");
    }

    private static class FunctionNameFinderVisitor
    extends NameFinderVisitor {
        private FunctionNameFinderVisitor() {
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTFieldReference) {
                this.name = ((IASTFieldReference)expression).getFieldName();
                return 2;
            }
            return super.visit(expression);
        }
    }

    public static class NameFinderVisitor
    extends ASTVisitor {
        public IASTName name;

        public NameFinderVisitor() {
            this.shouldVisitNames = true;
        }

        public int visit(IASTName name) {
            this.name = name;
            return 2;
        }
    }

    private static class NoReturnImplicitCallFinder
    extends ASTVisitor {
        boolean noReturn;

        NoReturnImplicitCallFinder() {
            this.shouldVisitImplicitNames = true;
            this.shouldVisitImplicitDestructorNames = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof IASTImplicitName && (binding = name.resolveBinding()) instanceof IFunction && ((IFunction)binding).isNoReturn()) {
                this.noReturn = true;
                return 2;
            }
            return 3;
        }
    }
}

