/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.ui.editors.AbstractDebugTextHover;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.ExpressionInformationControlCreator;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class AbstractDsfDebugTextHover
extends AbstractDebugTextHover
implements ITextHoverExtension2 {
    protected abstract String getModelId();

    protected String getHoverFormat() {
        return "NATURAL.Format";
    }

    protected IStack.IFrameDMContext getFrame() {
        IAdaptable adaptable = this.getSelectionAdaptable();
        if (adaptable != null) {
            return (IStack.IFrameDMContext)adaptable.getAdapter(IStack.IFrameDMContext.class);
        }
        return null;
    }

    protected boolean canEvaluate() {
        IDebugModelProvider modelProvider;
        if (this.getFrame() == null) {
            return false;
        }
        IAdaptable adaptable = this.getSelectionAdaptable();
        if (adaptable != null && (modelProvider = (IDebugModelProvider)adaptable.getAdapter(IDebugModelProvider.class)) != null) {
            String[] models = modelProvider.getModelIdentifiers();
            String myModel = this.getModelId();
            int i = 0;
            while (i < models.length) {
                if (models[i].equals(myModel)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected String evaluateExpression(String expression) {
        block8: {
            IStack.IFrameDMContext frame = this.getFrame();
            if (frame == null) {
                return null;
            }
            String sessionId = frame.getSessionId();
            DsfServicesTracker dsfServicesTracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), sessionId);
            try {
                GetExpressionValueQuery query = new GetExpressionValueQuery(frame, expression, dsfServicesTracker);
                DsfSession session = DsfSession.getSession((String)sessionId);
                if (session == null) break block8;
                session.getExecutor().execute((Runnable)((Object)query));
                try {
                    IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)query.get();
                    if (data != null) {
                        String string = data.getFormattedValue();
                        return string;
                    }
                }
                catch (Exception exception) {
                }
            }
            finally {
                dsfServicesTracker.dispose();
            }
        }
        return null;
    }

    protected boolean useExpressionExplorer() {
        return false;
    }

    protected final IInformationControlCreator createExpressionInformationControlCreator(boolean showDetailPane, int defaultExpansionLevel) {
        return new ExpressionInformationControlCreator(showDetailPane, defaultExpansionLevel);
    }

    protected IInformationControlCreator createExpressionInformationControlCreator() {
        return this.createExpressionInformationControlCreator(true, 1);
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.useExpressionExplorer()) {
            return this.createExpressionInformationControlCreator();
        }
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        DsfSession dsfSession;
        IStack.IFrameDMContext frameDmc;
        String simpleInfo = this.getHoverInfo(textViewer, hoverRegion);
        if (!this.useExpressionExplorer() || simpleInfo == null) {
            return simpleInfo;
        }
        final String text = this.getExpressionText(textViewer, hoverRegion);
        if (text != null && !text.isEmpty() && (frameDmc = this.getFrame()) != null && (dsfSession = DsfSession.getSession((String)frameDmc.getSessionId())) != null) {
            Callable<IExpressions.IExpressionDMContext> callable = new Callable<IExpressions.IExpressionDMContext>(){

                @Override
                public IExpressions.IExpressionDMContext call() throws Exception {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfUIPlugin.getBundleContext(), frameDmc.getSessionId());
                    try {
                        IExpressions expressions = (IExpressions)tracker.getService(IExpressions.class);
                        if (expressions != null) {
                            IExpressions.IExpressionDMContext iExpressionDMContext = expressions.createExpression((IDMContext)frameDmc, text);
                            return iExpressionDMContext;
                        }
                        return null;
                    }
                    finally {
                        tracker.dispose();
                    }
                }
            };
            try {
                return dsfSession.getExecutor().submit((Callable)callable).get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {}
        }
        return null;
    }

    private class GetExpressionValueQuery
    extends Query<IFormattedValues.FormattedValueDMData> {
        private final IStack.IFrameDMContext frame;
        private final String expression;
        private DsfServicesTracker dsfServicesTracker;

        public GetExpressionValueQuery(IStack.IFrameDMContext frame, String expression, DsfServicesTracker dsfServicesTracker) {
            this.frame = frame;
            this.expression = expression;
            this.dsfServicesTracker = dsfServicesTracker;
        }

        protected void execute(final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
            DsfSession session = DsfSession.getSession((String)this.frame.getSessionId());
            IExpressions expressions = (IExpressions)this.dsfServicesTracker.getService(IExpressions.class);
            if (expressions == null) {
                rm.setStatus(DsfUIPlugin.newErrorStatus(10004, "No expression service", null));
                rm.done();
                return;
            }
            IExpressions.IExpressionDMContext expressionDMC = expressions.createExpression((IDMContext)this.frame, this.expression);
            IFormattedValues.FormattedValueDMContext formattedValueContext = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)expressionDMC, AbstractDsfDebugTextHover.this.getHoverFormat());
            expressions.getFormattedExpressionValue(formattedValueContext, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)session.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)((IFormattedValues.FormattedValueDMData)this.getData()));
                    rm.done();
                }

                protected void handleFailure() {
                    rm.done();
                }
            });
        }
    }
}

