/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.VariablesPlugin;

public class MakeTarget
extends PlatformObject
implements IMakeTarget {
    private static final int USE_PROJECT_ENV_SETTING = 3;
    private final MakeTargetManager manager;
    private final IProject project;
    private String name;
    private boolean isDefaultBuildCmd;
    private boolean isStopOnError;
    boolean runAllBuidlers = true;
    private final String targetBuilderID;
    private IContainer container;
    private int appendEnvironment = 3;
    private boolean appendProjectEnvironment = true;
    private Map<String, String> buildEnvironment = new HashMap<String, String>();
    private final Map<String, String> targetAttributes = new HashMap<String, String>();

    public MakeTarget(MakeTargetManager manager, IProject project, String targetBuilderID, String name) throws CoreException {
        this.manager = manager;
        this.project = project;
        this.targetBuilderID = targetBuilderID;
        this.name = name;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(project, manager.getBuilderID(targetBuilderID));
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, info.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make"));
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, info.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, ""));
        this.isDefaultBuildCmd = info.isDefaultBuildCmd();
        this.isStopOnError = info.isStopOnError();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setContainer(IContainer container) {
        this.container = container;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    Map<String, String> getAttributeMap() {
        return this.targetAttributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTargetBuilderID() {
        return this.targetBuilderID;
    }

    @Override
    public boolean isStopOnError() {
        return this.isStopOnError;
    }

    @Override
    public void setStopOnError(boolean stopOnError) throws CoreException {
        this.isStopOnError = stopOnError;
        this.manager.updateTarget(this);
    }

    @Override
    public boolean isDefaultBuildCmd() {
        return this.isDefaultBuildCmd;
    }

    @Override
    public void setUseDefaultBuildCmd(boolean useDefault) throws CoreException {
        this.isDefaultBuildCmd = useDefault;
        this.manager.updateTarget(this);
    }

    @Override
    public IPath getBuildCommand() {
        if (this.isDefaultBuildCmd()) {
            try {
                IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
                return info.getBuildCommand();
            }
            catch (CoreException coreException) {}
        }
        String result = this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make");
        try {
            result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
        }
        catch (CoreException coreException) {}
        return new Path(result);
    }

    @Override
    public void setBuildCommand(IPath command) throws CoreException {
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, command.toString());
    }

    @Override
    public String getBuildArguments() {
        if (this.isDefaultBuildCmd()) {
            try {
                IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
                return info.getBuildArguments();
            }
            catch (CoreException coreException) {}
        }
        String result = this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, "");
        try {
            result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    @Override
    public void setBuildArguments(String arguments) throws CoreException {
        this.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, arguments);
    }

    @Override
    public void setBuildTarget(String target) throws CoreException {
        this.setBuildAttribute(IMakeTarget.BUILD_TARGET, target);
    }

    @Override
    public String getBuildTarget() {
        String result = this.getBuildAttribute(IMakeTarget.BUILD_TARGET, "");
        try {
            result = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(result, false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    @Override
    public void setRunAllBuilders(boolean runAllBuilders) throws CoreException {
        this.runAllBuidlers = runAllBuilders;
        this.manager.updateTarget(this);
    }

    @Override
    public boolean runAllBuilders() {
        return this.runAllBuidlers;
    }

    @Override
    public void setBuildAttribute(String name, String value) throws CoreException {
        this.targetAttributes.put(name, value);
        this.manager.updateTarget(this);
    }

    @Override
    public String getBuildAttribute(String name, String defaultValue) {
        String value = this.targetAttributes.get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    public IPath getBuildLocation() {
        return this.container.getLocation();
    }

    @Override
    public void setBuildLocation(IPath location) throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getErrorParsers() {
        try {
            IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
            return projectInfo.getErrorParsers();
        }
        catch (CoreException coreException) {
            return new String[0];
        }
    }

    @Override
    public void setErrorParsers(String[] parsers) throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getExpandedEnvironment() throws CoreException {
        Map<String, String> env = null;
        if (this.appendProjectEnvironment()) {
            IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
            env = projectInfo.getEnvironment();
        }
        if (env == null) {
            env = this.getEnvironment();
        } else {
            env.putAll(this.getEnvironment());
        }
        HashMap<String, String> envMap = new HashMap<String, String>(env.entrySet().size());
        boolean win32 = Platform.getOS().equals("win32");
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String value;
            String key = entry.getKey();
            if (win32) {
                key = key.toUpperCase();
            }
            String translated = value = entry.getValue();
            translated = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value, false);
            envMap.put(key, translated);
        }
        return envMap;
    }

    @Override
    public boolean appendProjectEnvironment() {
        return this.appendProjectEnvironment;
    }

    @Override
    public void setAppendProjectEnvironment(boolean append) {
        this.appendProjectEnvironment = append;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.buildEnvironment;
    }

    @Override
    public void setEnvironment(Map<String, String> env) throws CoreException {
        this.buildEnvironment = new HashMap<String, String>(env);
        this.manager.updateTarget(this);
    }

    @Override
    public void setAppendEnvironment(boolean append) throws CoreException {
        this.appendEnvironment = append ? 1 : 0;
        this.manager.updateTarget(this);
    }

    @Override
    public boolean appendEnvironment() {
        return this.appendEnvironment == 3 ? this.getProjectEnvSetting() : this.appendEnvironment == 1;
    }

    private boolean getProjectEnvSetting() {
        try {
            IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), this.manager.getBuilderID(this.targetBuilderID));
            return projectInfo.appendEnvironment();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public IContainer getContainer() {
        return this.container;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MakeTarget) {
            MakeTarget other = (MakeTarget)obj;
            return (this.container != null ? this.container.equals((Object)other.getContainer()) : other.getContainer() == null) && this.name.equals(other.getName());
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.container.hashCode() * 17) + this.name != null ? this.name.hashCode() : 0;
    }

    @Override
    public void build(IProgressMonitor monitor) throws CoreException {
        final String builderID = this.manager.getBuilderID(this.targetBuilderID);
        final HashMap<String, String> infoMap = new HashMap<String, String>();
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(infoMap, builderID);
        info.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make"));
        info.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, this.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, ""));
        info.setUseDefaultBuildCmd(this.isDefaultBuildCmd());
        info.setStopOnError(this.isStopOnError());
        info.setIncrementalBuildEnable(true);
        info.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL, this.getBuildAttribute(IMakeTarget.BUILD_TARGET, ""));
        info.setCleanBuildEnable(false);
        info.setEnvironment(this.getExpandedEnvironment());
        info.setAppendEnvironment(this.appendEnvironment());
        if (this.container != null && this.container != this.project) {
            info.setBuildAttribute(IMakeCommonBuildInfo.BUILD_LOCATION, this.container.getFullPath().toString());
        }
        IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), builderID);
        info.setErrorParsers(projectInfo.getErrorParsers());
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (MakeTarget.this.runAllBuidlers) {
                    ICommand[] commands = MakeTarget.this.project.getDescription().getBuildSpec();
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)commands.length);
                    ICommand[] iCommandArray = commands;
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICommand command = iCommandArray[n2];
                        if (command.getBuilderName().equals(builderID)) {
                            MakeTarget.this.project.build(6, builderID, (Map)infoMap, (IProgressMonitor)subMonitor.newChild(1));
                        } else {
                            MakeTarget.this.project.build(6, command.getBuilderName(), command.getArguments(), (IProgressMonitor)subMonitor.newChild(1));
                        }
                        ++n2;
                    }
                    monitor.done();
                } else {
                    MakeTarget.this.project.build(6, builderID, (Map)infoMap, monitor);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, null, 0, monitor);
        }
        finally {
            monitor.done();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProject.class)) {
            return this.getProject();
        }
        if (adapter.equals(IResource.class)) {
            return this.container;
        }
        return super.getAdapter(adapter);
    }
}

