/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IModules;
import org.eclipse.cdt.dsf.debug.service.IModules2;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.IRefreshAllTarget;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class DsfLoadSymbolsCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        ISelection iselection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection selection = iselection instanceof IStructuredSelection ? (IStructuredSelection)iselection : null;
        boolean all = event.getCommand().getId().equals("org.eclipse.cdt.debug.ui.command.loadAllSymbols");
        String sessionId = this.getSessionIdFromContext(selection);
        this.loadSymbols(selection, sessionId, all);
        return null;
    }

    void loadSymbols(final IStructuredSelection selection, String sessionId, final boolean all) {
        if (sessionId == null) {
            return;
        }
        final DsfSession dsfSession = DsfSession.getSession((String)sessionId);
        if (dsfSession == null || !dsfSession.isActive()) {
            return;
        }
        dsfSession.getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                if (all) {
                    DsfLoadSymbolsCommandHandler.this.queueLoadAllSymbols(dsfSession);
                } else {
                    for (Object o : selection.toList()) {
                        DsfLoadSymbolsCommandHandler.this.queueLoadSymbols(dsfSession, o);
                    }
                }
            }
        });
    }

    @ConfinedToDsfExecutor(value="session.getExecutor()")
    private void queueLoadSymbols(final DsfSession session, final Object module) {
        if (!(module instanceof IDMVMContext)) {
            return;
        }
        IDMContext context = ((IDMVMContext)module).getDMContext();
        if (context instanceof IModules.IModuleDMContext) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
            try {
                IModules2 modules = (IModules2)tracker.getService(IModules2.class);
                if (modules != null) {
                    modules.loadSymbols((IModules.IModuleDMContext)context, new RequestMonitor((Executor)session.getExecutor(), null){

                        protected void handleSuccess() {
                            DsfLoadSymbolsCommandHandler.this.doRefresh(session, module);
                        }
                    });
                }
            }
            finally {
                tracker.dispose();
            }
        }
    }

    @ConfinedToDsfExecutor(value="session.getExecutor()")
    private void queueLoadAllSymbols(final DsfSession session) {
        IAdaptable debugContext = DebugUITools.getDebugContext();
        IDMContext dmcontext = (IDMContext)debugContext.getAdapter(IDMContext.class);
        IModules.ISymbolDMContext symDmc = (IModules.ISymbolDMContext)DMContexts.getAncestorOfType((IDMContext)dmcontext, IModules.ISymbolDMContext.class);
        if (symDmc != null) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
            try {
                IModules2 modules = (IModules2)tracker.getService(IModules2.class);
                if (modules != null) {
                    modules.loadSymbolsForAllModules(symDmc, new RequestMonitor((Executor)session.getExecutor(), null){

                        protected void handleSuccess() {
                            DsfLoadSymbolsCommandHandler.this.doRefresh(session, DebugUITools.getDebugContext());
                        }
                    });
                }
            }
            finally {
                tracker.dispose();
            }
        }
    }

    private void doRefresh(DsfSession session, Object element) {
        if (element != null) {
            try {
                IRefreshAllTarget refreshTarget = (IRefreshAllTarget)session.getModelAdapter(IRefreshAllTarget.class);
                if (refreshTarget != null) {
                    refreshTarget.refresh((ISelection)new StructuredSelection(element));
                }
            }
            catch (CoreException coreException) {}
        }
    }

    private String getSessionIdFromContext(IStructuredSelection selection) {
        ILaunch launch;
        IDMContext context;
        String sessionId;
        Object element = selection.getFirstElement();
        if (element instanceof IDMVMContext && (sessionId = (context = ((IDMVMContext)element).getDMContext()).getSessionId()) != null) {
            return sessionId;
        }
        IAdaptable debugContext = DebugUITools.getDebugContext();
        sessionId = null;
        if (debugContext instanceof IDMVMContext) {
            sessionId = ((IDMVMContext)debugContext).getDMContext().getSessionId();
        } else if (debugContext instanceof GdbLaunch) {
            GdbLaunch gdbLaunch = (GdbLaunch)debugContext;
            if (!gdbLaunch.isTerminated()) {
                sessionId = gdbLaunch.getSession().getId();
            }
        } else if (debugContext instanceof GDBProcess && !(launch = ((GDBProcess)debugContext).getLaunch()).isTerminated() && launch instanceof GdbLaunch) {
            sessionId = ((GdbLaunch)launch).getSession().getId();
        }
        return sessionId;
    }
}

