/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.internal.ui.pinclone.PinCloneUtils;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.AbstractContainerVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbPinProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.GdbExecutionContextLabelText;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch.MessagesForGdbLaunchVM;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMDelegatingPropertiesUpdate;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;

public class ContainerVMNode
extends AbstractContainerVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private boolean fHideRunningThreadsProperty = false;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.cdt.dsf.gdb.hideRunningThreads")) {
                ContainerVMNode.this.fHideRunningThreadsProperty = (Boolean)event.getNewValue();
            }
        }
    };
    private final String MEMENTO_NAME = "CONTAINER_MEMENTO_NAME";

    public ContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fHideRunningThreadsProperty = store.getBoolean("org.eclipse.cdt.dsf.gdb.hideRunningThreads");
    }

    public void dispose() {
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }

    public String toString() {
        return "ContainerVMNode(" + this.getSession().getId() + ")";
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new GdbExecutionContextLabelText(MessagesForGdbLaunchVM.ContainerVMNode_No_columns__exited_format, new String[]{"name_known", "name", "id_known", "id", "exit_code_known", "exit_code"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean exited = (Boolean)properties.get("thread_exited");
                return Boolean.TRUE.equals(exited);
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_OS_PROCESS_TERMINATED")){
            {
                this.setPropertyNames(new String[]{"thread_exited"});
            }
        }, new GdbExecutionContextLabelText(MessagesForGdbLaunchVM.ContainerVMNode_No_columns__text_format, new String[]{"name_known", "name", "id_known", "id", "cores_id_known", "cores_id", "thread_summary_known", "thread_summary"}), new LabelText(MessagesForGdbLaunchVM.ContainerVMNode_No_columns__Error__label, new String[0]), new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugt_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"is_suspended", "pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean prop = (Boolean)properties.get("is_suspended");
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return prop != null && pin_prop != null && pin_color_prop != null ? !prop.booleanValue() && pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.FALSE.equals(properties.get("is_suspended"));
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_r.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(1) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_g.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(0) : false;
            }
        }, new LabelImage(CDTSharedImages.getImageDescriptor((String)"icons/obj16/debugts_obj_b.gif")){
            {
                this.setPropertyNames(new String[]{"pinned_context", "pin_color"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean pin_prop = (Boolean)properties.get("pinned_context");
                Object pin_color_prop = properties.get("pin_color");
                return pin_prop != null && pin_color_prop != null ? pin_prop.booleanValue() && pin_color_prop.equals(2) : false;
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_DEBUG_TARGET_SUSPENDED"))}));
        return provider;
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        ICommandControlService controlService = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        if (processService == null || controlService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        processService.getProcessesBeingDebugged((IDMContext)controlService.getContext(), (DataRequestMonitor)new ViewerDataRequestMonitor<IDMContext[]>(this.getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    ContainerVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                if (this.getData() != null) {
                    ContainerVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                }
                update.done();
            }
        });
    }

    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] parentUpdates = new IPropertiesUpdate[updates.length];
        int i = 0;
        while (i < updates.length) {
            final IPropertiesUpdate update = updates[i];
            final ViewerCountingRequestMonitor countringRm = new ViewerCountingRequestMonitor(ImmediateExecutor.getInstance(), (IViewerUpdate)updates[i]);
            int count = 0;
            parentUpdates[i] = new VMDelegatingPropertiesUpdate(updates[i], (RequestMonitor)countringRm);
            ++count;
            IDMContext dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IDMContext.class);
            IPinProvider.IPinElementColorDescriptor colorDesc = PinCloneUtils.getPinElementColorDescriptor(GdbPinProvider.getPinnedHandles(), (Object)dmc);
            updates[i].setProperty("pin_color", colorDesc != null ? Integer.valueOf(colorDesc.getOverlayColor()) : null);
            updates[i].setProperty("pinned_context", (Object)PinCloneUtils.isPinnedTo(GdbPinProvider.getPinnedHandles(), (Object)dmc));
            if (update.getProperties().contains("name") || update.getProperties().contains("id") || update.getProperties().contains("cores_id") || update.getProperties().contains("thread_exited") || update.getProperties().contains("exit_code")) {
                IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
                IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IProcessDMContext.class);
                if (processService == null || procDmc == null) {
                    update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10002, "Service or handle invalid", null));
                } else {
                    processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>(this.getExecutor(), (IViewerUpdate)update){

                        public void handleCompleted() {
                            if (this.isSuccess()) {
                                ContainerVMNode.this.fillThreadDataProperties(update, (IProcesses.IThreadDMData)this.getData());
                            } else {
                                update.setStatus(this.getStatus());
                            }
                            countringRm.done();
                        }
                    });
                    ++count;
                }
            }
            if (update.getProperties().contains("thread_summary")) {
                this.fillThreadSummary(update, (RequestMonitor)countringRm);
                ++count;
            }
            countringRm.setDoneCount(count);
            ++i;
        }
        super.updatePropertiesInSessionThread(parentUpdates);
    }

    protected void fillThreadDataProperties(IPropertiesUpdate update, IProcesses.IThreadDMData data) {
        String[] cores;
        Object showFullPathPreference;
        String fileName = data.getName();
        if (fileName != null && (showFullPathPreference = this.getVMProvider().getPresentationContext().getProperty("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths")) instanceof Boolean && !((Boolean)showFullPathPreference).booleanValue()) {
            fileName = new Path(fileName).lastSegment();
        }
        update.setProperty("name", (Object)fileName);
        update.setProperty("id", (Object)data.getId());
        String coresStr = null;
        if (data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null) {
            StringBuffer str = new StringBuffer();
            String[] stringArray = cores;
            int n = cores.length;
            int n2 = 0;
            while (n2 < n) {
                String core = stringArray[n2];
                str.append(String.valueOf(core) + ",");
                ++n2;
            }
            if (str.length() > 0) {
                coresStr = str.substring(0, str.length() - 1);
            }
        }
        update.setProperty("cores_id", coresStr);
        if (data instanceof IGDBProcesses.IGdbThreadExitedDMData) {
            update.setProperty("thread_exited", (Object)true);
            Integer exitCode = ((IGDBProcesses.IGdbThreadExitedDMData)data).getExitCode();
            if (exitCode != null) {
                update.setProperty("exit_code", (Object)exitCode);
            }
        }
    }

    protected void fillThreadSummary(final IPropertiesUpdate update, final RequestMonitor rm) {
        if (!this.fHideRunningThreadsProperty) {
            update.setProperty("thread_summary", null);
            rm.done();
            return;
        }
        IProcesses processService = (IProcesses)this.getServicesTracker().getService(IProcesses.class);
        IRunControl.IContainerDMContext procDmc = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (processService == null || procDmc == null) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10002, "Service or handle invalid", null));
        } else {
            processService.getProcessesBeingDebugged((IDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    IRunControl runControl = (IRunControl)ContainerVMNode.this.getServicesTracker().getService(IRunControl.class);
                    if (!this.isSuccess() || !(this.getData() instanceof IRunControl.IExecutionDMContext[]) || runControl == null) {
                        update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10002, "Unable to get threads summary", null));
                        rm.done();
                        return;
                    }
                    int runningCount = 0;
                    IRunControl.IExecutionDMContext[] iExecutionDMContextArray = (IRunControl.IExecutionDMContext[])this.getData();
                    int n = iExecutionDMContextArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRunControl.IExecutionDMContext execDmc = iExecutionDMContextArray[n2];
                        if (!runControl.isSuspended(execDmc) && !runControl.isStepping(execDmc)) {
                            ++runningCount;
                        }
                        ++n2;
                    }
                    update.setProperty("thread_summary", (Object)String.format("(%d %s)", runningCount, MessagesForGdbLaunchVM.ContainerVMNode_filtered_running_threads));
                    rm.done();
                }
            });
        }
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            return 1024;
        }
        if (e instanceof IGDBProcesses.IThreadRemovedDMEvent) {
            IDMContext dmc;
            IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
            if (dmc instanceof IProcesses.IProcessDMContext) {
                return 1024;
            }
            return 0;
        }
        return super.getDeltaFlags(e);
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof ICommandControlService.ICommandControlShutdownDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (e instanceof IGDBProcesses.IThreadRemovedDMEvent) {
            IDMContext dmc;
            IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
            if (dmc instanceof IProcesses.IProcessDMContext) {
                parentDelta.setFlags(parentDelta.getFlags() | 0x400);
            }
        } else {
            super.buildDelta(e, parentDelta, nodeOffset, requestMonitor);
            return;
        }
        requestMonitor.done();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            final IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            String mementoName = memento.getString("CONTAINER_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            } else {
                request.done();
            }
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IProcesses.IProcessDMContext procDmc;
            IDMContext dmc;
            final IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext && (procDmc = (IProcesses.IProcessDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IProcesses.IProcessDMContext.class)) != null) {
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IProcesses processService = (IProcesses)ContainerVMNode.this.getServicesTracker().getService(IProcesses.class);
                            if (processService != null) {
                                processService.getExecutionData((IProcesses.IThreadDMContext)procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)processService.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((IProcesses.IThreadDMData)this.getData()).getName() + ((IProcesses.IThreadDMData)this.getData()).getId());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    request.done();
                }
            } else {
                request.done();
            }
            ++n2;
        }
    }
}

