/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.IWorkingCopyProvider;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.cdt.internal.core.dom.rewrite.ICTextFileChangeFactory;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.corext.template.c.CodeTemplateContextType;
import org.eclipse.cdt.internal.corext.template.c.FileTemplateContextType;
import org.eclipse.cdt.internal.ui.CElementAdapterFactory;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.buildconsole.GlobalBuildConsoleManager;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.WorkingCopyManager;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.internal.ui.refactoring.CTextFileChangeFactory;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.internal.ui.text.doctools.EditorReopener;
import org.eclipse.cdt.internal.ui.text.folding.CFoldingStructureProviderRegistry;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.util.ProblemMarkerManager;
import org.eclipse.cdt.internal.ui.util.Util;
import org.eclipse.cdt.internal.ui.viewsupport.CDTContextActivator;
import org.eclipse.cdt.ui.CUIPreferenceInitializer;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.Messages;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class CUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.ui";
    public static final String PLUGIN_CORE_ID = "org.eclipse.cdt.core";
    public static final String EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";
    public static final String CVIEW_ID = "org.eclipse.cdt.ui.CView";
    public static final String C_PROBLEMMARKER = "org.eclipse.cdt.core.problem";
    public static final String ID_COMMENT_OWNER = "org.eclipse.cdt.ui.DocCommentOwner";
    public static final String ID_INCLUDE_BROWSER = "org.eclipse.cdt.ui.includeBrowser";
    public static final String ID_CALL_HIERARCHY = "org.eclipse.cdt.ui.callHierarchy";
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.cdt.ui.typeHierarchy";
    public static final String C_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCWizard";
    public static final String CPP_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCCWizard";
    public static final String CWIZARD_CATEGORY_ID = "org.eclipse.cdt.ui.newCWizards";
    @Deprecated
    public static final String CCWIZARD_CATEGORY_ID = "org.eclipse.cdt.ui.newCCWizards";
    public static final String SEARCH_ACTION_SET_ID = "org.eclipse.cdt.ui.SearchActionSet";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static CUIPlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private static final String CONTENTASSIST = "org.eclipse.cdt.ui/debug/contentassist";
    public static final String ID_CPERSPECTIVE = "org.eclipse.cdt.ui.CPerspective";
    @Deprecated
    public static final String ID_CHIERARCHY_PERSPECTIVE = "org.eclipse.cdt.ui.CHierarchyPerspective";
    @Deprecated
    public static final String ID_CBROWSING_PERSPECTIVE = "org.eclipse.cdt.ui.CBrowsingPerspective";
    @Deprecated
    public static String ID_PROJECTS_VIEW;
    @Deprecated
    public static String ID_NAMESPACES_VIEW;
    @Deprecated
    public static String ID_TYPES_VIEW;
    @Deprecated
    public static String ID_MEMBERS_VIEW;
    private static final String CUSTOM_TEMPLATES_KEY = "org.eclipse.cdt.ui.text.templates.custom";
    public static final String ID_CELEMENT_CREATION_ACTION_SET = "org.eclipse.cdt.ui.CElementCreationActionSet";
    public static final String CVIEWS_SCOPE = "org.eclipse.cdt.ui.cViewScope";
    private static final String CODE_TEMPLATES_KEY = "org.eclipse.cdt.ui.text.custom_code_templates";
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private CEditorTextHoverDescriptor[] fCEditorTextHoverDescriptors;
    private CFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private IPreferenceStore fCombinedPreferenceStore;
    private IPreferenceStore fCorePreferenceStore;
    private CoreModel fCoreModel;
    private CDocumentProvider fDocumentProvider;
    private WorkingCopyManager fWorkingCopyManager;
    private CTextTools fTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private final Map<String, BuildConsoleManager> fBuildConsoleManagers;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private CElementAdapterFactory fCElementAdapterFactory;
    private ContributionContextTypeRegistry fContextTypeRegistry;
    private TemplateStore fTemplateStore;
    private ASTProvider fASTProvider;
    private ContextTypeRegistry fCodeTemplateContextTypeRegistry;
    private TemplateStore fCodeTemplateStore;
    private IPropertyChangeListener fThemeListener;

    static {
        ID_PROJECTS_VIEW = "org.eclipse.cdt.ui.ProjectsView";
        ID_NAMESPACES_VIEW = "org.eclipse.cdt.ui.NamespacesView";
        ID_TYPES_VIEW = "org.eclipse.cdt.ui.TypesView";
        ID_MEMBERS_VIEW = "org.eclipse.cdt.ui.MembersView";
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.ui.CPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    @Deprecated
    public synchronized IBufferFactory getBufferFactory() {
        return ((WorkingCopyManager)this.getWorkingCopyManager()).getBufferFactory();
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return CUIPlugin.getDefault().getWorkingCopyManager().getSharedWorkingCopies();
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + key + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format((String)CUIPlugin.getResourceString(key), (Object[])new Object[]{arg});
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format((String)CUIPlugin.getResourceString(key), (Object[])args);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static CUIPlugin getDefault() {
        return fgCPlugin;
    }

    public static void log(Throwable e) {
        CUIPlugin.log("Error", e);
    }

    public static void log(String message, Throwable e) {
        CUIPlugin.log((IStatus)CUIPlugin.createErrorStatus(message, e));
    }

    public static void log(IStatus status) {
        CUIPlugin.getDefault().getLog().log(status);
    }

    public static void logError(String message) {
        CUIPlugin.log(message, null);
    }

    @Deprecated
    public void logErrorMessage(String message) {
        CUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public static Status createErrorStatus(String message) {
        return CUIPlugin.createErrorStatus(message, null);
    }

    public static Status createErrorStatus(String message, Throwable e) {
        return new Status(4, PLUGIN_ID, 4, message, e);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s, boolean logError) {
        if (logError) {
            CUIPlugin.log(s);
        }
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t, boolean logError) {
        IStatus status;
        if (logError) {
            CUIPlugin.log(message, t);
        }
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, PLUGIN_ID, -1, "Internal Error: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public CUIPlugin() {
        fgCPlugin = this;
        this.fDocumentProvider = null;
        this.fTextTools = null;
        this.fBuildConsoleManagers = new HashMap<String, BuildConsoleManager>();
    }

    public synchronized CDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new CDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            CDocumentProvider provider = this.getDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public CTextTools getTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new CTextTools();
        }
        return this.fTextTools;
    }

    public IBuildConsoleManager getConsoleManager() {
        return this.getConsoleManager(CUIPlugin.getResourceString("BuildConsole.name"), "org.eclipse.cdt.ui.CDTBuildConsole");
    }

    public IBuildConsoleManager getConsoleManager(String name, String contextId) {
        return this.getConsoleManager(name, contextId, null);
    }

    public IBuildConsoleManager getConsoleManager(String name, String contextId, URL iconUrl) {
        Assert.isNotNull((Object)contextId);
        BuildConsoleManager manager = this.fBuildConsoleManagers.get(contextId);
        if (manager == null) {
            manager = new BuildConsoleManager();
            this.fBuildConsoleManagers.put(contextId, manager);
            manager.startup(name, contextId, iconUrl);
        }
        return manager;
    }

    public void startGlobalConsole() {
        GlobalBuildConsoleManager.startGlobalConsole();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        this.registerAdapters();
        IWorkingCopyProvider workingCopyProvider = new IWorkingCopyProvider(){

            public IWorkingCopy[] getWorkingCopies() {
                return CUIPlugin.getSharedWorkingCopies();
            }
        };
        CCorePlugin.getDefault().getDOM().setWorkingCopyProvider(workingCopyProvider);
        if (PlatformUI.isWorkbenchRunning()) {
            this.getASTProvider();
            this.fThemeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                        CUIPreferenceInitializer.setThemeBasedPreferences(PreferenceConstants.getPreferenceStore(), true);
                    }
                }
            };
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fThemeListener);
        }
        CDTContextActivator.getInstance().install();
        DocCommentOwnerManager.getInstance().addListener(new EditorReopener());
        ASTRewriteAnalyzer.setCTextFileChangeFactory((ICTextFileChangeFactory)new CTextFileChangeFactory());
        UIJob prefsJob = new UIJob(CUIMessages.CUIPlugin_initPrefs){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                BuildConsolePreferencePage.initDefaults(CUIPlugin.this.getPreferenceStore());
                ContentAssistPreference.getInstance();
                return Status.OK_STATUS;
            }
        };
        prefsJob.setSystem(true);
        prefsJob.schedule();
        Job job = new Job(Messages.CUIPlugin_jobStartMakeUI){

            protected IStatus run(IProgressMonitor monitor) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.cdt.make.ui");
                try {
                    if (bundle != null) {
                        switch (bundle.getState()) {
                            case 4: 
                            case 8: {
                                bundle.start(1);
                            }
                        }
                    }
                }
                catch (BundleException e) {
                    return new Status(2, CUIPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        CDTContextActivator.getInstance().uninstall();
        if (this.fASTProvider != null) {
            this.fASTProvider.dispose();
            this.fASTProvider = null;
        }
        if (this.fTextTools != null) {
            this.fTextTools.dispose();
            this.fTextTools = null;
        }
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
            this.fImageDescriptorRegistry = null;
        }
        if (this.fBuildConsoleManagers != null) {
            Object[] bcm;
            Object[] objectArray = bcm = this.fBuildConsoleManagers.values().toArray();
            int n = bcm.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                BuildConsoleManager m = (BuildConsoleManager)element;
                if (m != null) {
                    m.shutdown();
                }
                ++n2;
            }
            this.fBuildConsoleManagers.clear();
        }
        GlobalBuildConsoleManager.stop();
        this.unregisterAdapters();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.shutdown();
            this.fDocumentProvider = null;
        }
        ContentAssistPreference.shutdown();
        if (this.fThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fThemeListener);
            this.fThemeListener = null;
        }
        super.stop(context);
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return CUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    protected void registerAdapters() {
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fCElementAdapterFactory = new CElementAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        manager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, IResource.class);
        manager.registerAdapters((IAdapterFactory)this.fCElementAdapterFactory, ICElement.class);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fCElementAdapterFactory);
    }

    @Deprecated
    public ISharedTextColors getSharedTextColors() {
        return EditorsUI.getSharedTextColors();
    }

    public void configurePluginDebugOptions() {
        String option;
        if (this.isDebugging() && (option = Platform.getDebugOption((String)CONTENTASSIST)) != null) {
            Util.VERBOSE_CONTENTASSIST = option.equalsIgnoreCase("true");
        }
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), this.getCorePreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.fCombinedPreferenceStore;
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.fCorePreferenceStore == null) {
            this.fCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_CORE_ID);
        }
        return this.fCorePreferenceStore;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorInput input;
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    IEditorPart ep = editorRef.getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty() && !inputs.contains(input = ep.getEditorInput())) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static IEditorPart[] getInstanciatedEditors() {
        IWorkbenchWindow[] windows;
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] references;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n5 = references.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference reference = iEditorReferenceArray[n6];
                    IEditorPart editor = reference.getEditor(false);
                    if (editor != null) {
                        result.add(editor);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public CEditorTextHoverDescriptor[] getCEditorTextHoverDescriptors() {
        if (this.fCEditorTextHoverDescriptors == null) {
            this.fCEditorTextHoverDescriptors = CEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((CEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fCEditorTextHoverDescriptors);
            int length = this.fCEditorTextHoverDescriptors.length;
            int first = -1;
            int last = length - 1;
            int problemHoverIndex = -1;
            int annotationHoverIndex = -1;
            int i = 0;
            while (i < length) {
                if (!this.fCEditorTextHoverDescriptors[i].getId().startsWith(PLUGIN_ID)) {
                    if (problemHoverIndex != -1 && annotationHoverIndex != -1) {
                        last = i - 1;
                        break;
                    }
                } else {
                    if (first == -1) {
                        first = i;
                    }
                    if (this.fCEditorTextHoverDescriptors[i].getId().equals("org.eclipse.cdt.ui.AnnotationHover")) {
                        annotationHoverIndex = i;
                    } else if (this.fCEditorTextHoverDescriptors[i].getId().equals("org.eclipse.cdt.ui.ProblemHover")) {
                        problemHoverIndex = i;
                    }
                }
                ++i;
            }
            CEditorTextHoverDescriptor hoverDescriptor = null;
            if (first > -1 && problemHoverIndex > -1 && problemHoverIndex > first) {
                hoverDescriptor = this.fCEditorTextHoverDescriptors[problemHoverIndex];
                System.arraycopy(this.fCEditorTextHoverDescriptors, first, this.fCEditorTextHoverDescriptors, first + 1, problemHoverIndex - first);
                this.fCEditorTextHoverDescriptors[first] = hoverDescriptor;
                if (annotationHoverIndex >= first && annotationHoverIndex < problemHoverIndex) {
                    ++annotationHoverIndex;
                }
            }
            if (annotationHoverIndex > -1 && annotationHoverIndex < last) {
                hoverDescriptor = this.fCEditorTextHoverDescriptors[annotationHoverIndex];
                System.arraycopy(this.fCEditorTextHoverDescriptors, annotationHoverIndex + 1, this.fCEditorTextHoverDescriptors, annotationHoverIndex, last - annotationHoverIndex);
                this.fCEditorTextHoverDescriptors[last] = hoverDescriptor;
            }
            int i2 = 0;
            while (i2 < length) {
                if ("org.eclipse.cdt.ui.BestMatchHover".equals(this.fCEditorTextHoverDescriptors[i2].getId())) {
                    if (i2 <= 0) break;
                    CEditorTextHoverDescriptor bestMatchHover = this.fCEditorTextHoverDescriptors[i2];
                    System.arraycopy(this.fCEditorTextHoverDescriptors, 0, this.fCEditorTextHoverDescriptors, 1, i2);
                    this.fCEditorTextHoverDescriptors[0] = bestMatchHover;
                    break;
                }
                ++i2;
            }
        }
        return this.fCEditorTextHoverDescriptors;
    }

    public void resetCEditorTextHoverDescriptors() {
        this.fCEditorTextHoverDescriptors = null;
    }

    public synchronized CFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new CFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry(EDITOR_ID);
            this.fContextTypeRegistry.addContextType("org.eclipse.cdt.ui.text.templates.c");
            this.fContextTypeRegistry.addContextType("org.eclipse.cdt.ui.text.templates.comment");
            this.fContextTypeRegistry.addContextType("org.eclipse.cdt.ui.text.templates.doccomment");
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                CUIPlugin.log(e);
            }
        }
        return this.fTemplateStore;
    }

    public ContextTypeRegistry getCodeTemplateContextRegistry() {
        if (this.fCodeTemplateContextTypeRegistry == null) {
            this.fCodeTemplateContextTypeRegistry = new ContributionContextTypeRegistry("org.eclipse.cdt.ui.codeTemplates");
            CodeTemplateContextType.registerContextTypes(this.fCodeTemplateContextTypeRegistry);
            FileTemplateContextType.registerContextTypes(this.fCodeTemplateContextTypeRegistry);
        }
        return this.fCodeTemplateContextTypeRegistry;
    }

    public TemplateStore getCodeTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            IPreferenceStore store = this.getPreferenceStore();
            this.fCodeTemplateStore = new ContributionTemplateStore(this.getCodeTemplateContextRegistry(), store, CODE_TEMPLATES_KEY);
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                CUIPlugin.log(e);
            }
            this.fCodeTemplateStore.startListeningForPreferenceChanges();
        }
        return this.fCodeTemplateStore;
    }

    public synchronized ASTProvider getASTProvider() {
        if (this.fASTProvider == null) {
            this.fASTProvider = new ASTProvider();
        }
        return this.fASTProvider;
    }

    public Shell getShell() {
        if (CUIPlugin.getActiveWorkbenchShell() != null) {
            return CUIPlugin.getActiveWorkbenchShell();
        }
        IWorkbenchWindow[] windows = CUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }
}

