/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.enablement;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.enablement.IBooleanExpression;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class HasNatureExpression
implements IBooleanExpression {
    public static final String NAME = "hasNature";
    private static final String NATURE_ID = "natureId";
    private String natureId;

    public HasNatureExpression(IManagedConfigElement element) {
        this.natureId = element.getAttribute(NATURE_ID);
    }

    @Override
    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOption option) {
        return this.evaluate(rcInfo);
    }

    @Override
    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOptionCategory category) {
        return this.evaluate(rcInfo);
    }

    private boolean evaluate(IResourceInfo rcInfo) {
        if (this.natureId == null || this.natureId.length() == 0) {
            return false;
        }
        IConfiguration config = rcInfo.getParent();
        if (config == null) {
            return false;
        }
        IResource resource = config.getOwner();
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        try {
            if (project.isAccessible()) {
                return project.hasNature(this.natureId);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

