/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.memory;

import com.ibm.icu.text.MessageFormat;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlock;
import org.eclipse.cdt.debug.core.model.provisional.IMemorySpaceAwareMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces2;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlock;
import org.eclipse.cdt.dsf.gdb.internal.memory.Messages;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory2;
import org.eclipse.cdt.dsf.service.DsfServices;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GdbMemoryBlockRetrieval
extends DsfMemoryBlockRetrieval
implements IMemorySpaceAwareMemoryBlockRetrieval {
    private final ServiceTracker<IMemorySpaces, IMemorySpaces> fMemorySpaceServiceTracker;
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String ATTR_EXPRESSION_LIST_CONTEXT = "context";
    private static final String MEMORY_BLOCK_EXPRESSION = "gdbmemoryBlockExpression";
    private static final String ATTR_MEMORY_BLOCK_EXPR_LABEL = "label";
    private static final String ATTR_MEMORY_BLOCK_EXPR_ADDRESS = "address";
    private static final String ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID = "memorySpaceID";
    private static final String CONTEXT_RESERVED = "reserved-for-future-use";

    public GdbMemoryBlockRetrieval(String modelId, ILaunchConfiguration config, DsfSession session) throws DebugException {
        super(modelId, config, session);
        BundleContext bundle = GdbPlugin.getBundleContext();
        String filter = DsfServices.createServiceFilter(IMemorySpaces.class, (String)session.getId());
        try {
            this.fMemorySpaceServiceTracker = new ServiceTracker(bundle, bundle.createFilter(filter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fMemorySpaceServiceTracker.open();
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        String memorySpaceID = null;
        IDMContext dmc = null;
        if (context instanceof IDMContext) {
            dmc = (IDMContext)context;
        } else if (context instanceof IAdaptable) {
            dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class);
        }
        if (dmc != null) {
            IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult result = this.decodeMemorySpaceExpression(dmc, expression);
            expression = result.getExpression();
            memorySpaceID = result.getMemorySpaceId();
        }
        return this.getMemoryBlock(expression, context, memorySpaceID);
    }

    public IMemorySpaceAwareMemoryBlock getMemoryBlock(String expression, Object context, String memorySpaceID) throws DebugException {
        BigInteger blockAddress;
        Object memoryDmc;
        block15: {
            memoryDmc = null;
            IDMContext dmc = null;
            if (context instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null) {
                memoryDmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
            }
            if (memoryDmc == null) {
                return null;
            }
            if (memoryDmc instanceof IMemorySpaces.IMemorySpaceDMContext) {
                assert (memorySpaceID != null);
                assert (memorySpaceID.equals(((IMemorySpaces.IMemorySpaceDMContext)memoryDmc).getMemorySpaceId()));
            } else if (memorySpaceID != null && memorySpaceID.length() > 0) {
                memoryDmc = new GdbMemoryBlock.MemorySpaceDMContext(this.getSession().getId(), memorySpaceID, (IDMContext)memoryDmc);
            }
            try {
                int base = 10;
                int offset = 0;
                if (expression.startsWith("0x") || expression.startsWith("0X")) {
                    base = 16;
                    offset = 2;
                } else if (expression.startsWith("0b")) {
                    base = 2;
                    offset = 2;
                } else if (expression.startsWith("0")) {
                    base = 8;
                    offset = 1;
                }
                blockAddress = new BigInteger(expression.substring(offset), base);
            }
            catch (NumberFormatException numberFormatException) {
                blockAddress = this.resolveMemoryAddress(dmc, expression);
                if (blockAddress != null) break block15;
                return null;
            }
        }
        int addressSize = this.getAddressSize((IMemory.IMemoryDMContext)memoryDmc);
        BigInteger endAddress = BigInteger.ONE.shiftLeft(addressSize * 8).subtract(BigInteger.ONE);
        if (endAddress.compareTo(blockAddress) < 0) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, MessageFormat.format((String)Messages.Err_ExceedsMaxAddress, (Object[])new Object[]{expression, endAddress.toString(16)}), null));
        }
        return new GdbMemoryBlock(this, (IMemory.IMemoryDMContext)memoryDmc, this.getModelId(), expression, blockAddress, this.getAddressableSize((IMemory.IMemoryDMContext)memoryDmc), 0L, memorySpaceID);
    }

    public void getMemorySpaces(final Object context, final IMemorySpaceAwareMemoryBlockRetrieval.GetMemorySpacesRequest request) {
        try {
            this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IMemorySpaces service;
                    IDMContext dmc = null;
                    if (context instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null && (service = (IMemorySpaces)GdbMemoryBlockRetrieval.this.fMemorySpaceServiceTracker.getService()) != null) {
                        service.getMemorySpaces(dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)GdbMemoryBlockRetrieval.this.getExecutor(), null){

                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    request.setMemorySpaces((String[])this.getData());
                                } else {
                                    request.setStatus(this.getStatus());
                                }
                                request.done();
                            }
                        });
                        return;
                    }
                    request.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Unable to get memory spaces", null));
                    request.done();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            request.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Unable to get memory spaces", null));
            request.done();
        }
    }

    public String encodeAddress(String expression, String memorySpaceID) {
        String result = null;
        IMemorySpaces service = (IMemorySpaces)this.fMemorySpaceServiceTracker.getService();
        if (service != null) {
            result = service.encodeAddress(expression, memorySpaceID);
        }
        if (result == null) {
            result = String.valueOf(memorySpaceID) + ':' + expression;
        }
        return result;
    }

    public IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult decodeAddress(String str) throws CoreException {
        String expression;
        String memorySpaceID;
        IMemorySpaces.DecodeResult result;
        IMemorySpaces service = (IMemorySpaces)this.fMemorySpaceServiceTracker.getService();
        if (service != null && (result = service.decodeAddress(str)) != null) {
            return new IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult(){

                public String getMemorySpaceId() {
                    return result.getMemorySpaceId();
                }

                public String getExpression() {
                    return result.getExpression();
                }
            };
        }
        int index = str.indexOf(58);
        if (index == -1) {
            memorySpaceID = null;
            expression = str;
        } else {
            memorySpaceID = str.substring(0, index);
            expression = index < str.length() - 1 ? str.substring(index + 1) : "";
        }
        return new IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult(){

            public String getMemorySpaceId() {
                return memorySpaceID;
            }

            public String getExpression() {
                return expression;
            }
        };
    }

    private IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult decodeMemorySpaceExpression(final IDMContext dmc, final String expression) throws DebugException {
        IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult decodeResult;
        try {
            decodeResult = this.decodeAddress(expression);
        }
        catch (CoreException e1) {
            throw new DebugException(e1.getStatus());
        }
        if (decodeResult.getMemorySpaceId() != null) {
            return decodeResult;
        }
        IMemorySpaces service = (IMemorySpaces)this.fMemorySpaceServiceTracker.getService();
        if (service instanceof IMemorySpaces2) {
            final IMemorySpaces2 memSpaceService = (IMemorySpaces2)service;
            Query<IMemorySpaces.DecodeResult> query = new Query<IMemorySpaces.DecodeResult>(){

                protected void execute(DataRequestMonitor<IMemorySpaces.DecodeResult> drm) {
                    memSpaceService.decodeExpression(dmc, expression, drm);
                }
            };
            this.getExecutor().execute((Runnable)query);
            try {
                final IMemorySpaces.DecodeResult result = (IMemorySpaces.DecodeResult)query.get();
                decodeResult = new IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult(){

                    public String getMemorySpaceId() {
                        return result.getMemorySpaceId();
                    }

                    public String getExpression() {
                        return result.getExpression();
                    }
                };
            }
            catch (InterruptedException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Error evaluating memory space expression (InterruptedException).", (Throwable)e));
            }
            catch (ExecutionException e) {
                throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5013, "Error evaluating memory space expression (ExecutionException).", (Throwable)e));
            }
        }
        return decodeResult;
    }

    ServiceTracker<IMemorySpaces, IMemorySpaces> getMemorySpaceServiceTracker() {
        return this.fMemorySpaceServiceTracker;
    }

    public String getMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)this);
        Document document = DebugPlugin.newDocument();
        Element expressionList = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        expressionList.setAttribute(ATTR_EXPRESSION_LIST_CONTEXT, CONTEXT_RESERVED);
        IMemoryBlock[] iMemoryBlockArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlock block = iMemoryBlockArray[n2];
            if (block instanceof IMemoryBlockExtension) {
                IMemoryBlockExtension memoryBlock = (IMemoryBlockExtension)block;
                Element expression = document.createElement(MEMORY_BLOCK_EXPRESSION);
                expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS, memoryBlock.getBigBaseAddress().toString());
                if (block instanceof IMemorySpaceAwareMemoryBlock) {
                    String memorySpaceID = ((IMemorySpaceAwareMemoryBlock)memoryBlock).getMemorySpaceID();
                    if (memorySpaceID != null) {
                        expression.setAttribute(ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID, memorySpaceID);
                        IMemorySpaceAwareMemoryBlockRetrieval.DecodeResult result = ((IMemorySpaceAwareMemoryBlockRetrieval)memoryBlock.getMemoryBlockRetrieval()).decodeAddress(memoryBlock.getExpression());
                        expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, result.getExpression());
                    } else {
                        expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, memoryBlock.getExpression());
                    }
                } else {
                    assert (false);
                    expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, memoryBlock.getExpression());
                }
                expressionList.appendChild(expression);
            }
            ++n2;
        }
        document.appendChild(expressionList);
        return DebugPlugin.serializeDocument((Document)document);
    }

    protected void createBlocksFromConfiguration(IMemory.IMemoryDMContext memoryCtx, String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (!root.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_LIST)) {
            Status status = new Status(4, "org.eclipse.cdt.dsf.gdb", 120, "Memory monitor initialization: invalid memento", null);
            throw new CoreException((IStatus)status);
        }
        if (root.getAttribute(ATTR_EXPRESSION_LIST_CONTEXT).equals(CONTEXT_RESERVED)) {
            ArrayList<GdbMemoryBlock> blocks = new ArrayList<GdbMemoryBlock>();
            NodeList expressionList = root.getChildNodes();
            int length = expressionList.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = expressionList.item(i);
                if (node.getNodeType() == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION)) {
                    String label = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL);
                    String address = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS);
                    String memorySpaceID = null;
                    if (entry.hasAttribute(ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID)) {
                        memorySpaceID = entry.getAttribute(ATTR_MEMORY_BLOCK_MEMORY_SPACE_ID);
                        if (memorySpaceID.length() == 0) {
                            memorySpaceID = null;
                            assert (false) : "should have either no memory space or a valid (non-empty) ID";
                        } else if (memoryCtx instanceof IMemorySpaces.IMemorySpaceDMContext) {
                            assert (((IMemorySpaces.IMemorySpaceDMContext)memoryCtx).getMemorySpaceId().equals(memorySpaceID));
                        } else {
                            memoryCtx = new GdbMemoryBlock.MemorySpaceDMContext(this.getSession().getId(), memorySpaceID, (IDMContext)memoryCtx);
                        }
                    }
                    BigInteger blockAddress = new BigInteger(address);
                    GdbMemoryBlock block = new GdbMemoryBlock(this, (IMemory.IMemoryDMContext)memoryCtx, this.getModelId(), label, blockAddress, this.getAddressableSize((IMemory.IMemoryDMContext)memoryCtx), 0L, memorySpaceID);
                    blocks.add(block);
                }
                ++i;
            }
            DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(blocks.toArray(new IMemoryBlock[blocks.size()]));
        }
    }

    public boolean creatingBlockRequiresMemorySpaceID() {
        IMemorySpaces service = (IMemorySpaces)this.fMemorySpaceServiceTracker.getService();
        if (service != null) {
            return service.creatingBlockRequiresMemorySpaceID();
        }
        return false;
    }

    private int getAddressableSize(IMemory.IMemoryDMContext context) {
        IGDBMemory2 memoryService = (IGDBMemory2)this.getServiceTracker().getService();
        if (memoryService != null && context != null) {
            return memoryService.getAddressableSize(context);
        }
        return super.getAddressableSize();
    }

    private int getAddressSize(IMemory.IMemoryDMContext context) {
        IGDBMemory memoryService = (IGDBMemory)this.getServiceTracker().getService();
        if (memoryService != null && context != null) {
            return memoryService.getAddressSize(context);
        }
        return super.getAddressSize();
    }
}

