/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import com.ibm.icu.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;

public class InferiorRuntimeProcess
extends RuntimeProcess {
    public InferiorRuntimeProcess(ILaunch launch, Process process, String name, Map<String, String> attributes) {
        super(launch, process, name, attributes);
    }

    protected void terminated() {
        this.setConsoleTerminatedLabel();
        super.terminated();
    }

    private void setConsoleTerminatedLabel() {
        if (this.getAttribute("org.eclipse.cdt.dsf.gdb.inferiorExited") != null) {
            int exitValue = 0;
            try {
                exitValue = this.getSystemProcess().exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return;
            }
            String label = this.getLabel();
            String type = null;
            ILaunchConfiguration config = this.getLaunch().getLaunchConfiguration();
            try {
                type = config.getType().getName();
            }
            catch (CoreException coreException) {
                type = null;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(config.getName());
            if (type != null) {
                buffer.append(" [");
                buffer.append(type);
                buffer.append("] ");
            }
            buffer.append(label);
            buffer.insert(0, MessageFormat.format((String)LaunchMessages.getString("InferiorRuntimeProcess_ExitValue"), (Object[])new Object[]{exitValue}));
            label = buffer.toString();
            this.setAttribute(IProcess.ATTR_PROCESS_LABEL, label);
        }
    }
}

