/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextListener;
import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextProvider;
import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextService;
import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class DisassemblyEditorManager
implements IWindowListener,
IDisassemblyContextListener,
IPartListener2 {
    private Map<Object, IEditorPart> fEditorParts;
    private Map<Object, String> fOpenDisassemblyPolicy;
    private Map<Object, ISteppingModeTarget> fSteppingModePolicy;
    private DisassemblyDocumentProvider fDocumentProvider = new DisassemblyDocumentProvider();

    public DisassemblyEditorManager() {
        this.fEditorParts = new HashMap<Object, IEditorPart>();
        this.fOpenDisassemblyPolicy = new HashMap<Object, String>();
        this.fSteppingModePolicy = new HashMap<Object, ISteppingModeTarget>();
        CDebugUIPlugin.getDefault().getWorkbench().addWindowListener((IWindowListener)this);
        IWorkbenchWindow window = CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            window.getPartService().addPartListener((IPartListener2)this);
        }
        this.getDisassemblyManager().addDisassemblyContextListener((IDisassemblyContextListener)this);
    }

    public void dispose() {
        this.getDisassemblyManager().removeDisassemblyContextListener((IDisassemblyContextListener)this);
        CDebugUIPlugin.getDefault().getWorkbench().removeWindowListener((IWindowListener)this);
        this.fSteppingModePolicy.clear();
        this.fOpenDisassemblyPolicy.clear();
        this.fEditorParts.clear();
        this.fDocumentProvider.dispose();
    }

    public DisassemblyDocumentProvider getDocumentProvider() {
        return this.fDocumentProvider;
    }

    public void openEditor(IWorkbenchPage page, Object debugContext) throws DebugException {
        Object disassemblyContext = this.getDiassemblyContext(debugContext);
        if (disassemblyContext != null) {
            IEditorPart editor = this.fEditorParts.get(disassemblyContext);
            if (editor == null) {
                ISourcePresentation sp = this.getSourcePresentation();
                if (sp == null) {
                    throw new DebugException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, "No disassembly editor found", null));
                }
                IEditorInput input = sp.getEditorInput(debugContext);
                try {
                    editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)sp.getEditorId(input, disassemblyContext));
                    this.fEditorParts.put(disassemblyContext, editor);
                    ISteppingModeTarget steppingModeTarget = this.getSteppingModeTarget(debugContext);
                    if (steppingModeTarget != null) {
                        if ("context".equals(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_STEP_MODE))) {
                            steppingModeTarget.enableInstructionStepping(true);
                        }
                        this.fSteppingModePolicy.put(disassemblyContext, steppingModeTarget);
                    }
                }
                catch (PartInitException e) {
                    throw new DebugException(e.getStatus());
                }
            }
            page.activate((IWorkbenchPart)editor);
        }
    }

    public IEditorPart findEditor(IWorkbenchPage page, Object debugContext) {
        Object disassemblyContext = this.getDiassemblyContext(debugContext);
        return disassemblyContext != null ? this.fEditorParts.get(disassemblyContext) : null;
    }

    public String getOpenDisassemblyMode(Object debugContext) {
        String mode = "never";
        Object disassemblyContext = this.getDiassemblyContext(debugContext);
        if (disassemblyContext != null && (mode = this.fOpenDisassemblyPolicy.get(disassemblyContext)) == null) {
            IPreferenceStore prefs = CDebugUIPlugin.getDefault().getPreferenceStore();
            mode = prefs.getString(IInternalCDebugUIConstants.PREF_OPEN_DISASSEMBLY_MODE);
            this.fOpenDisassemblyPolicy.put(disassemblyContext, mode);
        }
        return mode;
    }

    public void setOpenDisassemblyMode(Object debugContext, String mode) {
        Object disassemblyContext = this.getDiassemblyContext(debugContext);
        if (disassemblyContext == null) {
            return;
        }
        this.fOpenDisassemblyPolicy.put(disassemblyContext, mode);
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IEditorInput input;
        IWorkbenchPart part;
        if (this.isDisassemblyEditorPart(partRef) && (part = partRef.getPart(false)) instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof DisassemblyEditorInput) {
            Object disassemblyContext = ((DisassemblyEditorInput)input).getDisassemblyContext();
            this.fEditorParts.remove(disassemblyContext);
            ISteppingModeTarget steppingModeTarget = this.fSteppingModePolicy.remove(disassemblyContext);
            if (steppingModeTarget != null && "context".equals(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_STEP_MODE))) {
                steppingModeTarget.enableInstructionStepping(false);
            }
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IEditorInput input;
        IWorkbenchPart part;
        if (this.isDisassemblyEditorPart(partRef) && (part = partRef.getPart(false)) instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof DisassemblyEditorInput) {
            Object disassemblyContext = ((DisassemblyEditorInput)input).getDisassemblyContext();
            this.fEditorParts.put(disassemblyContext, (IEditorPart)part);
        }
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener2)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
    }

    public void contextAdded(Object context) {
    }

    public void contextRemoved(Object context) {
        final IEditorPart editor = this.fEditorParts.remove(context);
        if (editor != null) {
            UIJob job = new UIJob(editor.getSite().getShell().getDisplay(), "Closing disassembly"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    editor.getSite().getPage().closeEditor(editor, false);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    private IDisassemblyContextService getDisassemblyManager() {
        return CDebugCorePlugin.getDefault().getDisassemblyContextService();
    }

    private boolean isDisassemblyEditorPart(IWorkbenchPartReference partRef) {
        return partRef.getId().equals(ICDebugUIConstants.ID_DEFAULT_DISASSEMBLY_EDITOR);
    }

    private ISourcePresentation getSourcePresentation() {
        return new ISourcePresentation(){

            public IEditorInput getEditorInput(Object element) {
                Object disassemblyContext = DisassemblyEditorManager.this.getDiassemblyContext(element);
                return new DisassemblyEditorInput(element, disassemblyContext);
            }

            public String getEditorId(IEditorInput input, Object element) {
                return ICDebugUIConstants.ID_DEFAULT_DISASSEMBLY_EDITOR;
            }
        };
    }

    protected Object getDiassemblyContext(Object element) {
        IDisassemblyContextProvider adapter = this.getDisassemblyContextProvider(element);
        return adapter != null ? adapter.getDisassemblyContext(element) : null;
    }

    private IDisassemblyContextProvider getDisassemblyContextProvider(Object element) {
        IDisassemblyContextProvider adapter = null;
        if (element instanceof IDisassemblyContextProvider) {
            adapter = (IDisassemblyContextProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IDisassemblyContextProvider)adaptable.getAdapter(IDisassemblyContextProvider.class);
        }
        return adapter;
    }

    private ISteppingModeTarget getSteppingModeTarget(Object debugContext) {
        if (debugContext instanceof ISteppingModeTarget) {
            return (ISteppingModeTarget)debugContext;
        }
        if (debugContext instanceof IAdaptable) {
            return (ISteppingModeTarget)((IAdaptable)debugContext).getAdapter(ISteppingModeTarget.class);
        }
        return null;
    }
}

