/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.traditional;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.traditional.Rendering;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.traditional.TraditionalRenderingPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

abstract class CopyAction
extends Action {
    private Rendering fRendering;
    private int fClipboardType = 1;
    private CopyType fCopyType = CopyType.ALL;
    private static CopyType fDefaultCopyType = CopyType.UNDEFINED;

    public CopyAction(Rendering rendering, CopyType copyType, int clipboardType) {
        this.fCopyType = copyType;
        this.fClipboardType = clipboardType;
        this.fRendering = rendering;
        if (fDefaultCopyType == CopyType.UNDEFINED) {
            IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
            String defaultString = store.getString("memoryDefaultCopyAction");
            if (defaultString.length() > 0) {
                try {
                    fDefaultCopyType = Enum.valueOf(CopyType.class, defaultString);
                }
                catch (Exception exception) {
                    fDefaultCopyType = CopyType.ALL;
                }
            } else {
                fDefaultCopyType = CopyType.ALL;
            }
        }
    }

    public void checkStatus() {
        this.setChecked(fDefaultCopyType == this.fCopyType);
    }

    public void run() {
        Clipboard clip = null;
        try {
            if (this.fCopyType == CopyType.DEFAULT) {
                this.fCopyType = fDefaultCopyType;
            }
            if (this.fCopyType != fDefaultCopyType) {
                IPreferenceStore store = TraditionalRenderingPlugin.getDefault().getPreferenceStore();
                store.putValue("memoryDefaultCopyAction", this.fCopyType.name());
            }
            fDefaultCopyType = this.fCopyType;
            boolean copyAddress = this.fRendering.getPaneVisible(1) && (this.fCopyType == CopyType.ADDRESS || this.fCopyType == CopyType.ALL);
            boolean copyBinary = this.fRendering.getPaneVisible(2) && (this.fCopyType == CopyType.BINARY || this.fCopyType == CopyType.ALL);
            boolean copyText = this.fRendering.getPaneVisible(3) && (this.fCopyType == CopyType.TEXT || this.fCopyType == CopyType.ALL);
            clip = new Clipboard(this.fRendering.getDisplay());
            BigInteger start = this.fRendering.getSelection().getStart();
            BigInteger end = this.fRendering.getSelection().getEnd();
            if (end == null) {
                if (this.fCopyType == CopyType.ADDRESS) {
                    this.fRendering.copyAddressToClipboard();
                }
                return;
            }
            if (start.compareTo(end) > 0) {
                BigInteger bigI = end;
                end = start;
                start = bigI;
            }
            int radix = this.fRendering.getRadix();
            int bytesPerColumn = this.fRendering.getBytesPerColumn();
            boolean isLittleEndian = this.fRendering.isTargetLittleEndian();
            int columns = this.fRendering.getColumnCount();
            int addressableSize = this.fRendering.getAddressableSize();
            assert (addressableSize != 0);
            int addressesPerColumn = bytesPerColumn / addressableSize;
            BigInteger lengthToRead = end.subtract(start).multiply(BigInteger.valueOf(addressableSize));
            int rows = lengthToRead.divide(BigInteger.valueOf(columns * bytesPerColumn)).intValue();
            if (rows * columns * bytesPerColumn < lengthToRead.intValue()) {
                ++rows;
            }
            StringBuffer buffer = new StringBuffer();
            int row = 0;
            while (row < rows) {
                MemoryByte[] bytes;
                BigInteger cellAddress;
                int col;
                BigInteger rowAddress = start.add(BigInteger.valueOf(row * columns * addressesPerColumn));
                if (copyAddress) {
                    buffer.append(this.fRendering.getAddressString(rowAddress));
                    buffer.append("  ");
                }
                if (copyBinary) {
                    col = 0;
                    while (col < columns) {
                        cellAddress = rowAddress.add(BigInteger.valueOf(col * addressesPerColumn));
                        if (cellAddress.compareTo(end) < 0) {
                            try {
                                bytes = this.fRendering.getBytes(cellAddress, bytesPerColumn);
                                buffer.append(this.fRendering.getRadixText(bytes, radix, isLittleEndian));
                            }
                            catch (DebugException de) {
                                this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_COPY_OPERATION"), (Exception)((Object)de));
                                this.checkStatus();
                                if (clip != null) {
                                    clip.dispose();
                                }
                                return;
                            }
                        } else {
                            int i = this.fRendering.getRadixCharacterCount(radix, bytesPerColumn);
                            while (i > 0) {
                                buffer.append(' ');
                                --i;
                            }
                        }
                        if (col != columns - 1) {
                            buffer.append(' ');
                        }
                        ++col;
                    }
                }
                if (copyBinary && copyText) {
                    buffer.append("  ");
                }
                if (copyText) {
                    col = 0;
                    while (col < columns) {
                        cellAddress = rowAddress.add(BigInteger.valueOf(col * addressesPerColumn));
                        if (cellAddress.compareTo(end) < 0) {
                            try {
                                bytes = this.fRendering.getBytes(cellAddress, this.fRendering.getBytesPerColumn());
                                buffer.append(this.fRendering.formatText(bytes, isLittleEndian, this.fRendering.getTextMode()));
                            }
                            catch (DebugException de) {
                                this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_COPY_OPERATION"), (Exception)((Object)de));
                                this.checkStatus();
                                if (clip != null) {
                                    clip.dispose();
                                }
                                return;
                            }
                        }
                        ++col;
                    }
                }
                buffer.append("\n");
                ++row;
            }
            if (buffer.length() > 0) {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                clip.setContents(new Object[]{buffer.toString()}, new Transfer[]{plainTextTransfer}, this.fClipboardType);
            }
        }
        finally {
            this.checkStatus();
            if (clip != null) {
                clip.dispose();
            }
        }
    }

    public static enum CopyType {
        UNDEFINED,
        BINARY,
        TEXT,
        ADDRESS,
        ALL,
        DEFAULT;

    }
}

