/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DefaultPathEntryStore
implements IPathEntryStore,
ICDescriptorListener {
    static String PATH_ENTRY = "pathentry";
    static String PATH_ENTRY_ID = "org.eclipse.cdt.core.pathentry";
    static String ATTRIBUTE_KIND = "kind";
    static String ATTRIBUTE_PATH = "path";
    static String ATTRIBUTE_BASE_PATH = "base-path";
    static String ATTRIBUTE_BASE_REF = "base-ref";
    static String ATTRIBUTE_EXPORTED = "exported";
    static String ATTRIBUTE_SOURCEPATH = "sourcepath";
    static String ATTRIBUTE_ROOTPATH = "roopath";
    static String ATTRIBUTE_PREFIXMAPPING = "prefixmapping";
    static String ATTRIBUTE_EXCLUDING = "excluding";
    static String ATTRIBUTE_INCLUDE = "include";
    static String ATTRIBUTE_INCLUDE_FILE = "include-file";
    static String ATTRIBUTE_LIBRARY = "library";
    static String ATTRIBUTE_SYSTEM = "system";
    static String ATTRIBUTE_NAME = "name";
    static String ATTRIBUTE_VALUE = "value";
    static String ATTRIBUTE_MACRO_FILE = "macro-file";
    static String VALUE_TRUE = "true";
    static final IPathEntry[] NO_PATHENTRIES = new IPathEntry[0];
    List<IPathEntryStoreListener> listeners;
    IProject fProject;

    public DefaultPathEntryStore(IProject project) {
        this.fProject = project;
        this.listeners = Collections.synchronizedList(new ArrayList());
        CCorePlugin.getDefault().getCDescriptorManager().addDescriptorListener(this);
    }

    @Override
    public IPathEntry[] getRawPathEntries() throws CoreException {
        ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.fProject, false);
        if (cdesc != null) {
            ArrayList<IPathEntry> pathEntries = new ArrayList<IPathEntry>();
            ICStorageElement entry = cdesc.getProjectStorageElement(PATH_ENTRY_ID);
            ICStorageElement[] iCStorageElementArray = entry.getChildrenByName(PATH_ENTRY);
            int n = iCStorageElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICStorageElement childNode = iCStorageElementArray[n2];
                pathEntries.add(DefaultPathEntryStore.decodePathEntry(this.fProject, childNode));
                ++n2;
            }
            IPathEntry[] entries = new IPathEntry[pathEntries.size()];
            pathEntries.toArray(entries);
            return entries;
        }
        return NO_PATHENTRIES;
    }

    @Override
    public void setRawPathEntries(IPathEntry[] newRawEntries) throws CoreException {
        if (Arrays.equals(newRawEntries, this.getRawPathEntries())) {
            return;
        }
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(this.fProject, true);
        ICStorageElement rootElement = descriptor.getProjectStorageElement(PATH_ENTRY_ID);
        rootElement.clear();
        if (newRawEntries != null && newRawEntries.length > 0) {
            DefaultPathEntryStore.encodePathEntries(this.fProject.getFullPath(), rootElement, newRawEntries);
        }
        descriptor.saveProjectData();
    }

    static IPathEntry decodePathEntry(IProject project, ICStorageElement element) throws CModelException {
        char[][] patterns;
        int patternCount;
        Path path;
        IPath projectPath = project.getFullPath();
        String kindAttr = element.getAttribute(ATTRIBUTE_KIND);
        int kind = PathEntry.kindFromString(kindAttr);
        boolean isExported = false;
        if (element.hasAttribute(ATTRIBUTE_EXPORTED)) {
            isExported = element.getAttribute(ATTRIBUTE_EXPORTED).equals(VALUE_TRUE);
        }
        if (!(path = element.hasAttribute(ATTRIBUTE_PATH) ? new Path(element.getAttribute(ATTRIBUTE_PATH)) : new Path("")).isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path basePath = new Path(element.hasAttribute(ATTRIBUTE_BASE_PATH) ? element.getAttribute(ATTRIBUTE_BASE_PATH) : "");
        Path baseRef = new Path(element.hasAttribute(ATTRIBUTE_BASE_REF) ? element.getAttribute(ATTRIBUTE_BASE_REF) : "");
        String exclusion = element.getAttribute(ATTRIBUTE_EXCLUDING);
        IPath[] exclusionPatterns = APathEntry.NO_EXCLUSION_PATTERNS;
        if (exclusion != null && exclusion.length() > 0 && (patternCount = (patterns = CharOperation.splitOn('|', exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        switch (kind) {
            case 4: {
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 1: {
                Path sourceAttachmentPrefixMapping;
                Path libraryPath = new Path(element.getAttribute(ATTRIBUTE_LIBRARY));
                Path sourceAttachmentPath = element.hasAttribute(ATTRIBUTE_SOURCEPATH) ? new Path(element.getAttribute(ATTRIBUTE_SOURCEPATH)) : null;
                Path sourceAttachmentRootPath = element.hasAttribute(ATTRIBUTE_ROOTPATH) ? new Path(element.getAttribute(ATTRIBUTE_ROOTPATH)) : null;
                Path path2 = sourceAttachmentPrefixMapping = element.hasAttribute(ATTRIBUTE_PREFIXMAPPING) ? new Path(element.getAttribute(ATTRIBUTE_PREFIXMAPPING)) : null;
                if (!baseRef.isEmpty()) {
                    return CoreModel.newLibraryRefEntry((IPath)path, (IPath)baseRef, (IPath)libraryPath);
                }
                return CoreModel.newLibraryEntry((IPath)path, (IPath)basePath, (IPath)libraryPath, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, (IPath)sourceAttachmentPrefixMapping, isExported);
            }
            case 8: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getName())) {
                    return CoreModel.newSourceEntry((IPath)path, exclusionPatterns);
                }
                return CoreModel.newProjectEntry((IPath)path, isExported);
            }
            case 128: {
                return CoreModel.newOutputEntry((IPath)path, exclusionPatterns);
            }
            case 16: {
                Path includePath = new Path(element.getAttribute(ATTRIBUTE_INCLUDE));
                boolean isSystemInclude = false;
                if (element.hasAttribute(ATTRIBUTE_SYSTEM)) {
                    isSystemInclude = element.getAttribute(ATTRIBUTE_SYSTEM).equals(VALUE_TRUE);
                }
                if (!baseRef.isEmpty()) {
                    return CoreModel.newIncludeRefEntry((IPath)path, (IPath)baseRef, (IPath)includePath);
                }
                return CoreModel.newIncludeEntry((IPath)path, (IPath)basePath, (IPath)includePath, isSystemInclude, exclusionPatterns, isExported);
            }
            case 256: {
                Path includeFilePath = new Path(element.getAttribute(ATTRIBUTE_INCLUDE_FILE));
                return CoreModel.newIncludeFileEntry((IPath)path, (IPath)basePath, (IPath)baseRef, (IPath)includeFilePath, exclusionPatterns, isExported);
            }
            case 64: {
                String macroName = element.getAttribute(ATTRIBUTE_NAME);
                String macroValue = element.getAttribute(ATTRIBUTE_VALUE);
                if (!baseRef.isEmpty()) {
                    return CoreModel.newMacroRefEntry((IPath)path, (IPath)baseRef, macroName);
                }
                return CoreModel.newMacroEntry((IPath)path, macroName, macroValue, exclusionPatterns, isExported);
            }
            case 512: {
                Path macroFilePath = new Path(element.getAttribute(ATTRIBUTE_MACRO_FILE));
                return CoreModel.newMacroFileEntry((IPath)path, (IPath)basePath, (IPath)baseRef, (IPath)macroFilePath, exclusionPatterns, isExported);
            }
            case 32: {
                Path id = new Path(element.getAttribute(ATTRIBUTE_PATH));
                return CoreModel.newContainerEntry((IPath)id, isExported);
            }
        }
        CModelStatus status = new CModelStatus(4, "PathEntry: unknown kind (" + kindAttr + ")");
        throw new CModelException(status);
    }

    static void encodePathEntries(IPath projectPath, ICStorageElement configRootElement, IPathEntry[] entries) {
        IPathEntry[] iPathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntry entrie = iPathEntryArray[n2];
            ICStorageElement element = configRootElement.createChild(PATH_ENTRY);
            int kind = entrie.getEntryKind();
            element.setAttribute(ATTRIBUTE_KIND, PathEntry.kindToString(kind));
            IPath xmlPath = entrie.getPath();
            if (xmlPath == null) {
                xmlPath = new Path("");
            }
            if (kind != 32 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
                if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                    xmlPath = xmlPath.removeFirstSegments(1);
                    xmlPath = xmlPath.makeRelative();
                } else {
                    xmlPath = xmlPath.makeAbsolute();
                }
            }
            element.setAttribute(ATTRIBUTE_PATH, xmlPath.toString());
            switch (kind) {
                case 4: 
                case 8: 
                case 32: 
                case 128: {
                    break;
                }
                case 1: {
                    ILibraryEntry lib = (ILibraryEntry)entrie;
                    IPath libraryPath = lib.getLibraryPath();
                    element.setAttribute(ATTRIBUTE_LIBRARY, libraryPath.toString());
                    IPath sourcePath = lib.getSourceAttachmentPath();
                    if (sourcePath != null) {
                        if (projectPath != null && projectPath.isPrefixOf(sourcePath) && sourcePath.segment(0).equals(projectPath.segment(0))) {
                            sourcePath = sourcePath.removeFirstSegments(1);
                            sourcePath = sourcePath.makeRelative();
                        }
                        element.setAttribute(ATTRIBUTE_SOURCEPATH, sourcePath.toString());
                    }
                    if (lib.getSourceAttachmentRootPath() != null) {
                        element.setAttribute(ATTRIBUTE_ROOTPATH, lib.getSourceAttachmentRootPath().toString());
                    }
                    if (lib.getSourceAttachmentPrefixMapping() == null) break;
                    element.setAttribute(ATTRIBUTE_PREFIXMAPPING, lib.getSourceAttachmentPrefixMapping().toString());
                    break;
                }
                case 16: {
                    IPathEntry include = (IIncludeEntry)entrie;
                    IPath includePath = include.getIncludePath();
                    element.setAttribute(ATTRIBUTE_INCLUDE, includePath.toString());
                    if (!include.isSystemInclude()) break;
                    element.setAttribute(ATTRIBUTE_SYSTEM, VALUE_TRUE);
                    break;
                }
                case 256: {
                    IPathEntry include = (IIncludeFileEntry)entrie;
                    IPath includeFilePath = include.getIncludeFilePath();
                    element.setAttribute(ATTRIBUTE_INCLUDE_FILE, includeFilePath.toString());
                    break;
                }
                case 64: {
                    IPathEntry macro = (IMacroEntry)entrie;
                    element.setAttribute(ATTRIBUTE_NAME, macro.getMacroName());
                    element.setAttribute(ATTRIBUTE_VALUE, macro.getMacroValue());
                    break;
                }
                case 512: {
                    IPathEntry macro = (IMacroFileEntry)entrie;
                    element.setAttribute(ATTRIBUTE_MACRO_FILE, macro.getMacroFilePath().toString());
                }
            }
            if (entrie instanceof APathEntry) {
                APathEntry entry = (APathEntry)entrie;
                IPath basePath = entry.getBasePath();
                IPath baseRef = entry.getBaseReference();
                if (basePath != null && !basePath.isEmpty()) {
                    element.setAttribute(ATTRIBUTE_BASE_PATH, basePath.toString());
                } else if (baseRef != null && !baseRef.isEmpty()) {
                    element.setAttribute(ATTRIBUTE_BASE_REF, baseRef.toString());
                }
                IPath[] exclusionPatterns = entry.getExclusionPatterns();
                if (exclusionPatterns.length > 0) {
                    StringBuffer excludeRule = new StringBuffer(10);
                    int j = 0;
                    int max = exclusionPatterns.length;
                    while (j < max) {
                        if (j > 0) {
                            excludeRule.append('|');
                        }
                        excludeRule.append(exclusionPatterns[j]);
                        ++j;
                    }
                    element.setAttribute(ATTRIBUTE_EXCLUDING, excludeRule.toString());
                }
            }
            if (entrie.isExported()) {
                element.setAttribute(ATTRIBUTE_EXPORTED, VALUE_TRUE);
            }
            ++n2;
        }
    }

    @Override
    public void descriptorChanged(CDescriptorEvent event) {
        ICDescriptor cdesc;
        if (event.getType() == 1 && (cdesc = event.getDescriptor()) != null && cdesc.getProject() == this.fProject) {
            this.fireContentChangedEvent(this.fProject);
        }
    }

    @Override
    public void addPathEntryStoreListener(IPathEntryStoreListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePathEntryStoreListener(IPathEntryStoreListener listener) {
        this.listeners.remove(listener);
    }

    private void fireContentChangedEvent(IProject project) {
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, project, 1);
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.listeners.size()];
        this.listeners.toArray(observers);
        IPathEntryStoreListener[] iPathEntryStoreListenerArray = observers;
        int n = observers.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntryStoreListener observer = iPathEntryStoreListenerArray[n2];
            observer.pathEntryStoreChanged(evt);
            ++n2;
        }
    }

    @Override
    public void close() {
        PathEntryStoreChangedEvent evt = new PathEntryStoreChangedEvent(this, this.fProject, 2);
        IPathEntryStoreListener[] observers = new IPathEntryStoreListener[this.listeners.size()];
        this.listeners.toArray(observers);
        IPathEntryStoreListener[] iPathEntryStoreListenerArray = observers;
        int n = observers.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntryStoreListener observer = iPathEntryStoreListenerArray[n2];
            observer.pathEntryStoreChanged(evt);
            ++n2;
        }
        CCorePlugin.getDefault().getCDescriptorManager().removeDescriptorListener(this);
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public ICExtensionReference getExtensionReference() {
        return null;
    }

    @Override
    public ICConfigExtensionReference getConfigExtensionReference() {
        return null;
    }
}

